package com.elitesland.fin.common;

import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 日志操作描述
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/2/5 3:11 下午
 * @version:v1.0
 */
@Getter
public enum BusinessOperatiomEnum {

    INTERACT_FIN_APPLY(FinBusinessObjectConstant.INTERACT_FIN_APPLY, new HashMap<>())
    ;

    private final String businessType;
    private final Map<OperationTypeEnum, String> operationMap;


    BusinessOperatiomEnum(final String businessType, final Map<OperationTypeEnum, String> operationMap) {
        init(businessType,operationMap);
        this.businessType = businessType;
        this.operationMap = operationMap;

    }

    /**
     * 初始化（同一类型不同描述不处理）
     * @param businessType
     * @param operationMap
     */
    private void init(String businessType, Map<OperationTypeEnum, String> operationMap) {
        switch (businessType){
            case FinBusinessObjectConstant.INTERACT_FIN_APPLY:
                operationMap.put(OperationTypeEnum.ADD,"创建单据");
                operationMap.put(OperationTypeEnum.UPDATE,"编辑单据");
                operationMap.put(OperationTypeEnum.APPROVE_SUBMIT,"审批提交");
                operationMap.put(OperationTypeEnum.APPROVE_OK,"审批通过");
                operationMap.put(OperationTypeEnum.APPROVE_REJECT,"审批拒绝");
                break;
        }

    }


}
