/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.redis;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedLockUtils;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.application.service.redis.MyRedisService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MyRedisServiceImpl
implements MyRedisService {
    private static final Logger log = LoggerFactory.getLogger(MyRedisServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedLockUtils redLockUtils;

    @Override
    public <T> T getDataFromRedis(String dataKey, Class<T> cla, String msg, Supplier<T> supplier) {
        String nullString = "NULL";
        Object obj = null;
        Object objStr = this.redisUtils.get(dataKey);
        if (objStr != null) {
            if (nullString.equals(objStr)) {
                return null;
            }
            obj = JSON.parseObject((String)((String)objStr), cla);
            return (T)obj;
        }
        RedissonRedLock redLock = null;
        String lockKey = dataKey + ":LOCK";
        try {
            redLock = this.redLockUtils.getRedLock(lockKey);
            boolean lockFlag = redLock.tryLock(5L, 300L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("{},dataKey:{}\uff0c\u83b7\u53d6\u9501\u5931\u8d25", (Object)msg, (Object)dataKey);
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg + "\uff0cdataKey:" + dataKey + ",\u83b7\u53d6\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            objStr = this.redisUtils.get(dataKey);
            if (objStr != null) {
                if (nullString.equals(objStr)) {
                    T t = null;
                    return t;
                }
                Object object = obj = JSON.parseObject((String)((String)objStr), cla);
                return (T)object;
            }
            obj = supplier.get();
            if (obj == null) {
                this.redisUtils.set(dataKey, (Object)nullString);
                T t = null;
                return t;
            }
            this.redisUtils.set(dataKey, (Object)JSON.toJSONString((Object)obj));
            Object object = obj;
            return (T)object;
        }
        catch (Exception e) {
            log.error("{},dataKey:{}\uff0c\u83b7\u53d6\u9501\u5f02\u5e38", (Object)msg, (Object)dataKey);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg + "\uff0cdataKey:" + dataKey + ",\u83b7\u53d6\u9501\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        finally {
            redLock.unlock();
        }
    }

    @Override
    public <T> List<T> getListDataFromRedis(String dataKey, Class<T> cla, String msg, Supplier<List<T>> supplier) {
        String nullString = "NULL";
        List obj = null;
        Object objStr = this.redisUtils.get(dataKey);
        if (objStr != null) {
            if (nullString.equals(objStr)) {
                return null;
            }
            obj = JSON.parseArray((String)((String)objStr), cla);
            return obj;
        }
        RedissonRedLock redLock = null;
        String lockKey = dataKey + ":LOCK";
        try {
            redLock = this.redLockUtils.getRedLock(lockKey);
            boolean lockFlag = redLock.tryLock(5L, 300L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("{},dataKey:{}\uff0c\u83b7\u53d6\u9501\u5931\u8d25", (Object)msg, (Object)dataKey);
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg + "\uff0cdataKey:" + dataKey + ",\u83b7\u53d6\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            objStr = this.redisUtils.get(dataKey);
            if (objStr != null) {
                if (nullString.equals(objStr)) {
                    List<T> list = null;
                    return list;
                }
                List list = obj = JSON.parseArray((String)((String)objStr), cla);
                return list;
            }
            obj = supplier.get();
            if (obj == null) {
                this.redisUtils.set(dataKey, (Object)nullString);
                List<T> list = null;
                return list;
            }
            this.redisUtils.set(dataKey, (Object)JSON.toJSONString((Object)obj));
            List list = obj;
            return list;
        }
        catch (Exception e) {
            log.error("{},dataKey:{}\uff0c\u83b7\u53d6\u9501\u5f02\u5e38", (Object)msg, (Object)dataKey);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, msg + "\uff0cdataKey:" + dataKey + ",\u83b7\u53d6\u9501\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        finally {
            redLock.unlock();
        }
    }
}

