package com.elitesland.fin.application.facade.vo.saleinv;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.saleinv
 * @date 2022/5/6 18:15
 */
@Data
public class SaleInvVO  extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = 9110863935394913374L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("来源系统单号")
    private String sourceSysNo;

    @ApiModelProperty("开票申请单号")
    private String applyNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("发票登记单号")
    private String invRegNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额(开票申请金额)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalCurAmt;

    @ApiModelProperty("销售方发票抬头")
    private String saleInvTitle;

    @ApiModelProperty("销售税号")
    private String saleTaxNo;

    @ApiModelProperty("销售方电话")
    private String saleTel;

    @ApiModelProperty("销售详细地址")
    private String saleAdd;

    @ApiModelProperty("销售方开户行")
    private String saleBank;

    @ApiModelProperty("销售方银行账号")
    private String saleBankAcc;

    @ApiModelProperty("销售方备注")
    private String saleRemark;

    @ApiModelProperty("供应商ID")
    private Long saleId;

    @ApiModelProperty("供应商名称")
    private String saleName;

    @ApiModelProperty("供应商编码")
    private String saleCode;

    @ApiModelProperty("客户方发票抬头")
    private String custInvTitle;

    @ApiModelProperty("纳税人识别号")
    private String custTaxNo;

    @ApiModelProperty("客户地址")
    private String custAdd;

    @ApiModelProperty("客户电话")
    private String custTel;

    @ApiModelProperty("客户银行")
    private String custBank;

    @ApiModelProperty("客户银行账号")
    private String custBankAcc;

    @ApiModelProperty("客户备注")
    private String custRemark;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("开票人")
    private String invUser;

    @ApiModelProperty("收款人")
    private String recUser;

    @ApiModelProperty("复核人")
    private String revUser;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("推送方式")
    @SysCode(sys = "yst-fin", mod = "PUSH_METHOD")
    private String pushMethod;
    private String pushMethodName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("信息表编号")
    private String infoNo;

    @ApiModelProperty("快递编号")
    private String expressNo;

    @ApiModelProperty("开票状态")
    private String invState;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "INVOICE_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("备注")
    private String remark;

    @ExcelProperty("创建人")
    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty("创建日期")
    @ExcelConvert(name = "createTime", converter = DateTimeToDateConverter.class)
    private LocalDate createDate;

    @ApiModelProperty(value = "修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("相同商品合并开票：1是；0否")
    private String invMerge;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("开票客户名称")
    private String invCustName;

    @ApiModelProperty("开票客户编码")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    private Long invCustId;

    @JsonProperty
    public String getInvMergeName() {
        return "0".equals(invMerge) ? "否" : "是";
    }


    @ApiModelProperty("开票日期")
    private LocalDateTime drawDate;

    @ApiModelProperty("红冲日期")
    private LocalDateTime redPunchDate;


    @ApiModelProperty("当年对账类型是卡券订单对账的已红冲金额")
    private BigDecimal redAmt;

    @ApiModelProperty("当年对账类型是卡券订单对账的开票成功金额")
    private BigDecimal successAmt;

    @ApiModelProperty("已红冲金额/(开票成功金额-已红冲金额) 比例")
    private BigDecimal rate;

    @ApiModelProperty("是否超过10%")
    private Boolean hasRemind;

    @ApiModelProperty("对账类型/订单分组")
    @SysCode(sys = "yst-order",mod = "ORDER_TYPE3")
    private String docType3;
    private String docType3Name;

    /**
     * 订货人
     */
    @ApiModelProperty("订货人")
    private String recvContactName;
    /**
     * 订货联系电话
     */
    @ApiModelProperty("订货联系电话")
    private String recvContactTel;

}
