package com.elitesland.fin.application.service.inputinv;

import com.elitesland.fin.application.convert.inputinv.InputInvDtlConvert;
import com.elitesland.fin.application.facade.vo.inputinv.InputInvDtlVO;
import com.elitesland.fin.domain.param.inputinv.InputInvDtlPageParam;
import com.elitesland.fin.domain.service.inputinv.InputInvDtlDomainService;
import com.elitesland.fin.infr.dto.inputinv.InputInvDtlDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author zhiyu.he
 * @date 2022/5/6 17:21
 */
@Service
@RequiredArgsConstructor
public class InputInvDtlServiceImpl implements InputInvDtlService {

    private final InputInvDtlDomainService inputInvDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<InputInvDtlVO> page(InputInvDtlPageParam param) {
        PagingVO<InputInvDtlDTO> page = inputInvDtlDomainService.page(param);
        return InputInvDtlConvert.INSTANCE.convertPage(page);
    }
}
