package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_fast_code_line")
@org.hibernate.annotations.Table(appliesTo = "fin_fast_code_line", comment = "快码明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinFastCodeLineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "output_one", columnDefinition = "varchar(32) comment '输出1'")
    private String outputOne;

    @Column(name = "output_two", columnDefinition = "varchar(32) comment '输出2'")
    private String outputTwo;

    @Column(name = "output_three", columnDefinition = "varchar(32) comment '输出3'")
    private String outputThree;

    @Column(name = "condition_one", columnDefinition = "varchar(32) comment '条件1字段'")
    private String conditionOne;

    @Column(name = "condition_one_value", columnDefinition = "varchar(32) comment '条件1字段值'")
    private String conditionOneValue;

    @Column(name = "condition_two", columnDefinition = "varchar(32) comment '条件2字段'")
    private String conditionTwo;

    @Column(name = "condition_two_value", columnDefinition = "varchar(32) comment '条件2字段值'")
    private String conditionTwoValue;

    @Column(name = "condition_three", columnDefinition = "varchar(32) comment '条件3字段'")
    private String conditionThree;

    @Column(name = "condition_three_value", columnDefinition = "varchar(32) comment '条件3字段值'")
    private String conditionThreeValue;
}
