package com.elitesland.fin.domain.param.arorder;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.param.arorder
 * @date 2022/4/12 16:01
 */
@Data
public class ArOrderPageParam extends BaseModelParam {

    private static final long serialVersionUID = 7356019896853105505L;
    @ApiModelProperty("来源系统单号")
    private String sourceNo;



    @ApiModelProperty("应收单号")
    private String arOrderNo;
    @ApiModelProperty("应收单号集合")
    private List<String> arOrderNoList;
    @ApiModelProperty("销售公司编码")
    private String ouCode;
    @ApiModelProperty("销售公司编码集合")
    private List<String> ouCodeList;
    @ApiModelProperty("销售公司ID")
    private Long ouId;
    @ApiModelProperty("销售公司ID集合")
    private List<Long> ouIdList;
    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("来源单据")
    private String createMode;
    @ApiModelProperty("来源单据集合")
    private List<String> createModeList;
    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;
    @ApiModelProperty("应收单类型定义ID集合")
    private List<Long> arTypeIdList;
    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;
    @ApiModelProperty("应收单类型代码集合")
    private List<String> arTypeCodeList;
    @ApiModelProperty("单据状态")
    private String orderState;
    @ApiModelProperty("单据状态集合")
    private List<String> orderStateList;
    @ApiModelProperty("业务日期/开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty("业务日期/结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty("含税金额/开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty("含税金额/结束")
    private BigDecimal totalAmtEnd;

    @ApiModelProperty("不含税金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;
    @ApiModelProperty("币种编码集合")
    private List<String> currCodeList;
    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期/开始")
    private LocalDateTime auditDateStart;

    @ApiModelProperty("审核日期/结束")
    private LocalDateTime auditDateEnd;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户ID集合")
    private List<Long> custIdList;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户编码集合")
    private List<String> custCodeList;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售部门ID")
    private Long buId;
    @ApiModelProperty("销售部门ID集合")
    private List<Long> buIdList;
    @ApiModelProperty("销售部门编码")
    private String buCode;
    @ApiModelProperty("销售部门编码集合")
    private List<String> buCodeList;
    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;
    @ApiModelProperty("业务类型集合")
    private List<String> buTypeList;
    @ApiModelProperty("付款条件")
    private String payMent;

    @ApiModelProperty("核销状态")
    private String verState;
    @ApiModelProperty("核销状态集合")
    private List<String> verStateList;
    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;
    @ApiModelProperty("明细来源单号")
    private List<String> dtlSourceNoList;

    @ApiModelProperty(value = "销售组织ID")
    private Long orgId;
    @ApiModelProperty(value = "销售组织ID集合")
    private List<Long> orgIdList;
    @ApiModelProperty(value = "销售编码")
    private String orgCode;
    @ApiModelProperty(value = "销售编码集合")
    private List<String> orgCodeList;
    @ApiModelProperty(value = "销售名称")
    private String orgName;
    @ApiModelProperty(value = "销售名称集合")
    private List<String> orgNameList;
    @ApiModelProperty(value = "销售业务员ID")
    private Long saleUserId;
    @ApiModelProperty(value = "销售业务员ID集合")
    private List<Long> saleUserIdList;
    @ApiModelProperty(value = "销售业务员")
    private String saleUser;
    @ApiModelProperty(value = "销售业务员集合")
    private List<String> saleUserList;
    @ApiModelProperty(value = "单据类型")
    private String arOrderType;
    @ApiModelProperty(value = "单据类型集合")
    private List<String> arOrderTypeList;
    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;
    @ApiModelProperty("发票号")
    private String es2;

    private String writeOfFAmtCon;

    @ApiModelProperty(value = "内外部客户")
    private List<String> inOutCustList;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("付款协议编码集合")
    private List<String> protocolCodeList;

    @ApiModelProperty(value = "关联公司编码")
    private List<String> relevanceOuCodeList;
}
