package com.elitesland.fin.domain.service.account;


import com.elitesland.fin.domain.base.BaseRepo;
import com.elitesland.fin.entity.account.AccountRuleConfigDtlDO;
import com.elitesland.fin.repo.account.AccountRuleConfigDtlRepo;
import com.elitesland.fin.repo.account.AccountRuleConfigDtlRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Service
@AllArgsConstructor
public class AccountRuleConfigDtlDomainServiceImpl implements AccountRuleConfigDtlDomainService {
    private final AccountRuleConfigDtlRepo accountRuleConfigDtlRepo;

    private final AccountRuleConfigDtlRepoProc accountRuleConfigDtlRepoProc;

    @Override
    public BaseRepo<AccountRuleConfigDtlDO, Long> getDao() {
        return accountRuleConfigDtlRepo;
    }

    @Override
    public void updateDynamically(List<AccountRuleConfigDtlDO> invSceneConfigDtlDOS) {
        accountRuleConfigDtlRepoProc.updateDynamically(invSceneConfigDtlDOS);
    }

    @Override
    public List<AccountRuleConfigDtlDO> findAccountRuleConfigDtlByMasId(Long masId) {
        return accountRuleConfigDtlRepo.findByMasId(masId);
    }

    @Override
    public void deleteByParam(AccountRuleConfigDtlDO accountRuleConfigDtlDO) {
        accountRuleConfigDtlRepoProc.deleteByParam(accountRuleConfigDtlDO);
    }
}