package com.elitesland.fin.domain.service.aptype;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.aptype.ApTypeConvert;
import com.elitesland.fin.domain.entity.aptype.ApType;
import com.elitesland.fin.domain.entity.aptype.ApTypeDO;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.repo.aptype.ApTypeOuRepoProc;
import com.elitesland.fin.infr.repo.aptype.ApTypeRepo;
import com.elitesland.fin.infr.repo.aptype.ApTypeRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aptype
 * @date 2022/3/11 16:23
 */
@Service
@RequiredArgsConstructor
public class ApTypeDomainServiceImpl implements ApTypeDomainService {

    private final ApTypeRepo apTypeRepo;
    private final ApTypeRepoProc apTypeRepoProc;
    private final ApTypeOuRepoProc apTypeOuRepoProc;


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long save(ApType apType) {

        apType.checkNotNull();
        apType.setDefaultValue();
        Boolean existsByApTypeCode = apTypeRepoProc.existsByApTypeCode(apType.getApTypeCode());
        if (existsByApTypeCode) {
            throw new BusinessException("应付单类型编码已存在");
        }
        Boolean existsByApTypeName = apTypeRepoProc.existsByApTypeName(apType.getApTypeName());
        if (existsByApTypeName) {
            throw new BusinessException("应付单类型名称已存在");
        }
        // 如果第一条新增，则为默认
        Boolean isFir = apTypeRepoProc.isFir();
        if (isFir) {
            apType.setDefaultFlag(true);
        }
        ApTypeDO apTypeDO = ApTypeConvert.INSTANCE.convert(apType);
        ApTypeDO res = apTypeRepo.save(apTypeDO);
        return res.getId();
    }

    @Override
    public PagingVO<ApTypeDTO> page(ApTypePageParam apTypeParam) {
        List<Long> aptypeIds = new ArrayList<>();
        if (null != apTypeParam.getOuId()) {
            aptypeIds = apTypeOuRepoProc.queryByOuId(apTypeParam.getOuId());
        }
        PagingVO<ApTypeDTO> page = apTypeRepoProc.page(apTypeParam, aptypeIds);
        return page;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Boolean updateEnableFlag(List<Long> ids, Boolean enable) {
        apTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long updateDef(Long id) {
        // 设置默认为false
        apTypeRepoProc.updateDef();
        // 设置id对应的默认状态
        Long res = apTypeRepoProc.updateDefById(id);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(Long id) {
        Assert.notNull(id, "id不能为空");
        // 停用状态和默认状态不能被删除
        ApTypeDTO apTypeDTO = apTypeRepoProc.findById(id);
        if (apTypeDTO.getEnableFlag() || apTypeDTO.getDefaultFlag()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能删除未启用的数据和非默认的数据");
        }
        Long res = apTypeRepoProc.del(id);
        return res;
    }

    @Override
    public List<ApTypeDTO> findByIds(List<Long> ids) {
        List<ApTypeDTO> res = apTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    public ApTypeDTO getDef() {
        ApTypeDTO res = apTypeRepoProc.getDef();
        return res;
    }

    @Override
    public List<ApTypeDTO> getList() {
        List<ApTypeDTO> res = apTypeRepoProc.getList();
        return res;
    }

    @Override
    @SysCodeProc
    public List<ApTypeDTO> selectMatchByParam(ApTypePageParam apTypeParam){
        return apTypeRepoProc.selectMatchByParam(apTypeParam);

    }

    @Override
    @SysCodeProc
    public List<ApTypeDTO> selectByParam(ApTypePageParam apTypeParam){
        if (StringUtils.isBlank(apTypeParam.getApTypeCode())) {
            return Collections.EMPTY_LIST;
        }
        return apTypeRepoProc.selectByParam(apTypeParam);

    }

}
