package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zhiMing
 */
@Entity
@Table(name = "invoice_applyfor")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "invoice_applyfor", comment = "发票申请单")
@Data
@Accessors(chain = true)
@ApiModel(value = "invoice_applyfor", description = "发票申请单")
public class InvoiceApplyfor extends BaseModel implements Serializable {

    private static final long serialVersionUID = 7771781383048874325L;

    /**
     * 关联表ID
     */
    @Column(name = "sale_inv_id", columnDefinition = "bigint(20) comment '关联数据表ID'")
    private Long saleInvId;
}
