package com.elitesland.fin.infr.repo.paymentperiod;

import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeOuDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Repository
public interface AgingRangeOuRepo extends JpaRepository<AgingRangeOuDO, Long>, QuerydslPredicateExecutor<AgingRangeOuDO> {

    /**
     * 根据主表ID删除
     *
     * @param masId 主表ID
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteByMasId(Long masId);

    /**
     * 根据ID删除
     *
     * @param ids ID
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteByIdIn(List<Long> ids);

}
