package com.elitesland.fin.provider.bip.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.entity.push.FinPushResultDO;
import com.elitesland.fin.provider.bip.BipFinService;
import com.elitesland.fin.provider.bip.params.BipFinPaymentDTO;
import com.elitesland.fin.provider.bip.params.BipFinReceiptDTO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.repo.push.FinPushResultRepoProc;
import com.elitesland.pur.common.inter.PurPushRecordRepository;
import com.elitesland.pur.common.inter.bip.BipException;
import com.elitesland.pur.common.inter.bip.BipMoneyType;
import com.elitesland.pur.common.inter.bip.PurBipPushClient;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/23 周三
 */
@Component
public class BipFinServiceImpl implements BipFinService {
    private static final Logger logger = LoggerFactory.getLogger(BipFinServiceImpl.class);

    @Autowired
    private PurBipPushClient bipPushClient;
    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private AdjustOrderRepoProc adjustOrderRepoProc;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private FinPushResultRepoProc finPushResultRepoProc;
    @Autowired
    private PurPushRecordRepository purPushRecordRepository;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;
    @Autowired
    private UdcProvider udcProvider;

    @Override
    public ApiResult<String> pushReceiptOfSaoBeiAccountFlow(long creditAccountFlowId) {
        if (!bipPushClient.isEnabled()) {
            logger.info("未启用BIP");
            return ApiResult.ok();
        }

        var creditAccountFlow = creditAccountFlowRepoProc.get(creditAccountFlowId);
        Assert.notNull(creditAccountFlow, "流水不存在");

        tryPush(creditAccountFlow.getId(), creditAccountFlow.getFlowNo(), FinPushInter.BIP_FIN_REC_CREDIT_ACCOUNT_FLOW_SAOBEI_SAVE,
                (id, docNo) -> creditAccountFlowRepoProc.get(id), this::supportToRecSaoBei, this::convertSaoBei);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushReceiptOfStorageAccountFlow(long accountFlowId) {
        if (!bipPushClient.isEnabled()) {
            logger.info("未启用BIP");
            return ApiResult.ok();
        }

        var accountFlow = accountFlowRepoProc.get(accountFlowId);
        Assert.notNull(accountFlow, "流水不存在");

        pushPaymentOfStorageAccountFlow(accountFlowId);

        tryPush(accountFlow.getId(), accountFlow.getFlowNo(), FinPushInter.BIP_FIN_REC_ACCOUNT_FLOW_STORAGE_SAVE,
                (id, docNo) -> accountFlowRepoProc.get(id), this::supportToRecStorage, this::convertStorage);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushReceiptOfAdjustOrder(long adjustOrderId) {
        if (!bipPushClient.isEnabled()) {
            logger.info("未启用BIP");
            return ApiResult.ok();
        }

        var adjustOrder = adjustOrderRepoProc.get(adjustOrderId);
        Assert.notNull(adjustOrder, "单据不存在");

        tryPush(adjustOrder.getId(), adjustOrder.getDocNo(), FinPushInter.BIP_FIN_REC_ADJUST_ORDER_SAVE,
                (id, docNo) -> adjustOrderRepoProc.get(id), this::supportToRecAdjustOrder, this::convertAdjustOrder);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> pushPaymentOfStorageAccountFlow(long accountFlowId) {
        if (!bipPushClient.isEnabled()) {
            logger.info("未启用BIP");
            return ApiResult.ok();
        }

        var accountFlow = accountFlowRepoProc.get(accountFlowId);
        Assert.notNull(accountFlow, "流水不存在");

        tryPush(accountFlow.getId(), accountFlow.getFlowNo(), FinPushInter.BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE,
                (id, docNo) -> accountFlowRepoProc.get(id), this::supportToPayStorage, this::convertPayStorage);
        return ApiResult.ok();
    }

    private BipFinPaymentDTO convertPayStorage(AccountFlowDO accountFlowDO) {
        List<AccountFlowDO> accountFlowBatchList = accountFlowDO.getSourceId() == null ? Collections.emptyList()
                : accountFlowRepoProc.listBySourceId(accountFlowDO.getSourceId());

        // 来源单号相同的流水中 业务类型=贷款的流水
        AccountFlowDO accountFlowLoan = accountFlowBatchList.isEmpty() ? null : accountFlowBatchList.stream()
                .filter(t -> UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode().equals(t.getBusinessType())
                ).findFirst().orElse(null);

        BipFinPaymentDTO head = new BipFinPaymentDTO();
        List<BipFinPaymentDTO.Detail> detailList = new ArrayList<>(4);
        BipFinPaymentDTO.Detail detail = new BipFinPaymentDTO.Detail();

        // 门店的储值公司
        String storeOuCode = obtainStorageOuCodeByAcc(accountFlowDO.getAccountCode());
        String customerCode = accountRepoProc.getAccountHolderCodeByAccountCode(accountFlowDO.getAccountCode());
        String cbkAccount = null;
        if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowDO.getTransactionType())) {
            // 余额扣减
//            head.setOuCode(accountFlowLoan == null ? accountFlowDO.getToOuCode() : accountFlowLoan.getToOuCode());
            head.setOuCode(storeOuCode);
//            customerCode = accountFlowDO.getFromOuCode();
            cbkAccount = accountFlowDO.getFromAccountNo();

            BigDecimal amt = bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowDO.getTransactionType())) {
            // 余额增加
//            head.setOuCode(accountFlowLoan == null ? accountFlowDO.getFromOuCode() : accountFlowLoan.getFromOuCode());
            head.setOuCode(storeOuCode);
//            customerCode = accountFlowDO.getToOuCode();
            cbkAccount = accountFlowDO.getToAccountNo();

            BigDecimal amt = bipPushClient.formatMoney(accountFlowDO.getAmount() == null ? null : accountFlowDO.getAmount().multiply(new BigDecimal(-1)), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);
            detail.setMoney(amt);
            detail.setAmt(amt);
        }
        if (customerCode != null){
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        detail.setCustomerCode(customerCode);
        head.setCurrRate(BigDecimal.ONE);
        head.setCreateTime(accountFlowDO.getTransactionTime());
        head.setObjType("0");
        head.setTradeType("F3-Cxx-02");
        head.setSettleType("11");
        head.setCbkAccount(cbkAccount);
        head.setCurrCode("CNY");
        head.setCreatorRoot("ALZ");
        head.setCreator(accountFlowDO.getCreator());
        head.setDocNo(accountFlowDO.getFlowNo());

        detail.setPrepay(1);
        detail.setObjType(0);
        if (StrUtil.isNotBlank(accountFlowDO.getBusinessType())) {
            detail.setBusinessType(udcProvider.getValueMapByUdcCode(Application.NAME, "ACCOUNT_FLOW_BUSINESS_TYPE").get(accountFlowDO.getBusinessType()));
        }
        detail.setCurrCode("CNY");
        detail.setCurrRate("1");
        detailList.add(detail);
        head.setDetailList(detailList);

        return head;
    }

    private String supportToPayStorage(AccountFlowDO accountFlowDO) {
        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(accountFlowDO.getAccountType())) {
            // 只推储值流水
            return "流水账户类型不支持推送：" + accountFlowDO.getAccountType();
        }
        if (UdcEnum.DOC_CLS_AO.getValueCode().equals(accountFlowDO.getSourceDoc())) {
            // 排除调整单的
            return "流水来源单据不支持推送：" + accountFlowDO.getSourceDoc();
        }

        return null;
    }

    private String obtainStorageOuCodeByAcc(String accCode) {
        var ouCode = accountRepoProc.getAccountHolderCodeByAccountCode(accCode);
        if (StrUtil.isBlank(ouCode)) {
            return null;
        }

        var orgStore = orgStoreRpcService.findSimpleByCode(ouCode).computeData();
        return orgStore == null ? null : orgStore.getStoredOuCode();
    }

    private String obtainOrgStoreByAcc(String accCode) {
        return accountRepoProc.getAccountHolderCodeByAccountCode(accCode);
    }

    private BipFinReceiptDTO convertAdjustOrder(AdjustOrderDO adjustOrderDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        List<BipFinReceiptDTO.Detail> detailList = new ArrayList<>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();

        String customerCode = accountRepoProc.getAccountHolderCodeByAccountCode(adjustOrderDO.getAccCode());
        String ouCode = obtainStorageOuCodeByAcc(adjustOrderDO.getAccCode());
        var ou = queryOu(ouCode);
        Assert.notNull(ou, "储值账户公司不存在");
        head.setOuCode(ouCode);
        head.setDocDate(adjustOrderDO.getAuditTime());
        head.setObjType(0);

        if (customerCode != null){
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        head.setSettleType("11");
//        var receiveAccount = queryOrgOuBankAcc(ou.getId());
        var receiveAccount = adjustOrderDO.getStoredBankAcc();
        head.setReceiveAccount(receiveAccount);
        head.setCbkAccount(null);
        head.setCurrCode("CNY");
        head.setCurrRate("1");
        head.setReceiptType("D2");
        head.setCreatorRoot("ALZ");
        head.setCreator(adjustOrderDO.getCreator());
        head.setDocNo(adjustOrderDO.getDocNo());
        head.setRemark(adjustOrderDO.getRemark());

        detail.setPrepay(1);
        detail.setBusinessType(udcProvider.getValueMapByUdcCode(Application.NAME, UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getCode()).get(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode()));
        detail.setObjType(0);
        detail.setCustomerCode(customerCode);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount(receiveAccount);
        detail.setCurrRate("1");

        if (UdcEnum.ADJUST_TYPE_1.getValueCode().equals(adjustOrderDO.getAdjType())) {
            var amt = bipPushClient.formatMoney(adjustOrderDO.getTotalAmt(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);

            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.ADJUST_TYPE_2.getValueCode().equals(adjustOrderDO.getAdjType())) {
            var amt = bipPushClient.formatMoney(adjustOrderDO.getTotalAmt() == null ? null : adjustOrderDO.getTotalAmt().multiply(BigDecimal.valueOf(-1)), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);

            detail.setMoney(amt);
            detail.setAmt(amt);
        }

        detail.setRootDocNo(null);
        detailList.add(detail);

        head.setDetailList(detailList);

        return head;
    }

    private String supportToRecAdjustOrder(AdjustOrderDO adjustOrderDO) {
        if (ProcInstStatus.APPROVED != adjustOrderDO.getWorkflowProcInstStatus()) {
            return "调整单审批状态不满足：" + adjustOrderDO.getWorkflowProcInstStatus();
        }

        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(adjustOrderDO.getAccType())) {
            return "调整单账户类型不支持：" + adjustOrderDO.getAccType();
        }

        return null;
    }

    private BipFinReceiptDTO convertStorage(AccountFlowDO accountFlowDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        List<BipFinReceiptDTO.Detail> detailList = new ArrayList<>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();

        String ouCode = null;
        String customerCode = null;
        String cbkAccount = null;
        if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowDO.getTransactionType())) {
            // 余额扣减
            ouCode = accountFlowDO.getToOuCode();
            customerCode = obtainOrgStoreByAcc(accountFlowDO.getAccountCode());
            cbkAccount = accountFlowDO.getToAccountNo();

            var amt = bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);

            var toOu = queryOu(ouCode);
            Assert.notNull(toOu, "入账公司不存在");
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(toOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
            detail.setAmt(amt);
        } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowDO.getTransactionType())) {
            // 余额增加
            ouCode = accountFlowDO.getFromOuCode();
            customerCode = obtainOrgStoreByAcc(accountFlowDO.getAccountCode());;
            cbkAccount = accountFlowDO.getFromAccountNo();

            var amt = bipPushClient.formatMoney(accountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            if (amt != null) {
                amt = amt.multiply(new BigDecimal(-1));
            }
            head.setAmt(amt);
            head.setAmt1(amt);

            var fromOu = queryOu(ouCode);
            Assert.notNull(fromOu, "出账公司不存在");
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(fromOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
            detail.setAmt(amt);
        }
        if (customerCode != null){
            customerCode = customerCode.trim();
        }
        head.setOuCode(ouCode);
        head.setCustomerCode(customerCode);
        head.setDocDate(accountFlowDO.getTransactionTime());
        head.setObjType(0);
        head.setSettleType("11");
        head.setCurrCode("CNY");
        head.setReceiveAccount("");
        head.setCbkAccount(cbkAccount);
        head.setCurrRate("1");
        head.setCreatorRoot("ALZ");
        head.setCreator(accountFlowDO.getCreator());
        head.setDocNo(accountFlowDO.getFlowNo());
        head.setRemark(accountFlowDO.getRemark());

        detail.setPrepay(1);
        if (StrUtil.isNotBlank(accountFlowDO.getBusinessType())) {
            detail.setBusinessType(udcProvider.getValueMapByUdcCode(Application.NAME, "ACCOUNT_FLOW_BUSINESS_TYPE").get(accountFlowDO.getBusinessType()));
        }
        detail.setObjType(0);
        detail.setCustomerCode(customerCode);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount("");
        detail.setCurrRate("1");
        detail.setRootDocNo(accountFlowDO.getRootDocNo());
        detailList.add(detail);

        head.setDetailList(detailList);

        return head;
    }

    private String supportToRecStorage(AccountFlowDO accountFlowDO) {
        if (!UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(accountFlowDO.getAccountType())) {
            // 只推储值流水
            return "账户类型不支持：" + accountFlowDO.getAccountType();
        }
        if (UdcEnum.DOC_CLS_AO.getValueCode().equals(accountFlowDO.getSourceDoc())) {
            // 排除调整单的
            return "账户流水类别不支持：" + accountFlowDO.getSourceDoc();
        }

        return null;
    }

    private BipFinReceiptDTO convertSaoBei(CreditAccountFlowDO creditAccountFlowDO) {
        BipFinReceiptDTO head = new BipFinReceiptDTO();
        List<BipFinReceiptDTO.Detail> detailList = new ArrayList<>(4);
        BipFinReceiptDTO.Detail detail = new BipFinReceiptDTO.Detail();

        String ouCode = null;
        String customerCode = null;
        String cbkAccount = null;
        if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            // 账号扣减
            ouCode = creditAccountFlowDO.getToOuCode();
//            customerCode = creditAccountRepoProc.getObjectCodeByAccountCode(creditAccountFlowDO.getCreditAccountCode());
            customerCode = creditAccountFlowDO.getObjectCode();
            cbkAccount = creditAccountFlowDO.getToAccountNo();

            var amt = bipPushClient.formatMoney(creditAccountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            head.setAmt(amt);
            head.setAmt1(amt);

            var toOu = queryOu(ouCode);
            Assert.notNull(toOu, "入账公司不存在");
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(toOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
        } else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            // 账户增加
            ouCode = creditAccountFlowDO.getFromOuCode();
//            customerCode = creditAccountRepoProc.getObjectCodeByAccountCode(creditAccountFlowDO.getCreditAccountCode());
            customerCode = creditAccountFlowDO.getObjectCode();;
            cbkAccount = creditAccountFlowDO.getFromAccountNo();

            var amt = bipPushClient.formatMoney(creditAccountFlowDO.getAmount(), BipMoneyType.AMOUNT);
            if (amt != null) {
                amt = amt.multiply(new BigDecimal(-1));
            }
            head.setAmt(amt);
            head.setAmt1(amt);

            var fromOu = queryOu(ouCode);
            Assert.notNull(fromOu, "出账公司不存在");
            head.setReceiptType(UdcEnum.COM_OU_TYPE_10.getValueCode().equals(fromOu.getOuType()) ? "F2-Cxx-02" : "F2-Cxx-03");
            detail.setMoney(amt);
        }
        head.setOuCode(ouCode);
        if (customerCode != null){
            customerCode = customerCode.trim();
        }
        head.setCustomerCode(customerCode);
        head.setDocDate(creditAccountFlowDO.getTransactionTime());
        head.setObjType(0);
        head.setSettleType("10");
        head.setCurrCode("CNY");
        head.setReceiveAccount("");
        head.setCbkAccount(cbkAccount);
        head.setCurrRate("1");
        head.setCreatorRoot("ALZ");
        head.setCreator(creditAccountFlowDO.getCreator());
        head.setDocNo(creditAccountFlowDO.getFlowNo());
        head.setRemark(creditAccountFlowDO.getRemark());

        detail.setCustomerCode(customerCode);
        detail.setPrepay(1);
        if (StrUtil.isNotBlank(creditAccountFlowDO.getBusinessType())) {
            detail.setBusinessType(udcProvider.getValueMapByUdcCode(Application.NAME, "ACCOUNT_FLOW_BUSINESS_TYPE").get(creditAccountFlowDO.getBusinessType()));
        }
        detail.setObjType(0);
        detail.setCurrCode("CNY");
        detail.setReceiveAccount("");
        detail.setCurrRate("1");
        detail.setRootDocNo(creditAccountFlowDO.getRootDocNo());
        detailList.add(detail);

        head.setDetailList(detailList);

        return head;
    }

    private String supportToRecSaoBei(CreditAccountFlowDO creditAccountFlowDO) {
        if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            // 账户扣减
            if (CharSequenceUtil.isBlank(creditAccountFlowDO.getFromAccountNo())) {
                return "出账方账户为空, 不推送!";
            }
            if (CharSequenceUtil.isBlank(creditAccountFlowDO.getToAccountNo())) {
                return "入账方账户为空, 不推送!";
            }
            return null;
        }
        if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowDO.getTransactionType())) {
            // 账户增加
            if (CharSequenceUtil.isBlank(creditAccountFlowDO.getFromAccountNo())) {
                return "出账方账户为空, 不推送!";
            }
            if (CharSequenceUtil.isBlank(creditAccountFlowDO.getToAccountNo())) {
                return "入账方账户为空, 不推送!";
            }
            return null;
        }

        return "不支持推送的交易类型";
    }

    private String queryOrgOuBankAcc(Long ouId) {
        List<OrgOuBankRpcDTO> ouBankList = orgOuRpcService.findOuBank(ouId);
        if (CollUtil.isEmpty(ouBankList)) {
            return null;
        }

        return ouBankList.stream().filter(ouBank -> "IN".equals(ouBank.getAccType())).map(OrgOuBankRpcDTO::getBankAcc).findFirst().orElse(null);
    }

    private OrgOuRpcSimpleDTO queryOu(String ouCode) {
        if (CharSequenceUtil.isBlank(ouCode)) {
            return null;
        }

        var ouList = orgOuRpcService.findSimpleByOuCodes(List.of(ouCode));
        return CollUtil.isEmpty(ouList) ? null : ouList.get(0);
    }

    private OrgOuRpcSimpleDTO queryOu(Long ouId) {
        if (ouId == null) {
            return null;
        }

        var ouList = orgOuRpcService.findSimpleOuDto(List.of(ouId));
        return CollUtil.isEmpty(ouList) ? null : ouList.get(0);
    }

    /**
     * 尝试推送单据
     *
     * @param docId            单据ID
     * @param docNo            单据编号
     * @param inter            推送的接口
     * @param supportPush      判断是否支持推送
     * @param docGetter        单据获取
     * @param reqBodyConverter 转换为BIP的请求参数, 结果为集合，则分批推送
     * @param <T>
     */
    private <T> void tryPush(Long docId, String docNo, FinPushInter inter, BiFunction<Long, String, T> docGetter, Function<T, String> supportPush,
                             Function<T, Object> reqBodyConverter) {
        Assert.notNull(docId, "单据ID为空");
        Assert.notBlank(docNo, "单据编号为空");

        Supplier<Void> pusher = () -> {
            CompletableFuture.runAsync(() -> {
                logger.info("[{}]开始推送单据：{}, {}", inter.name(), docNo, docId);

                // 获取已推送记录
                var existsRecord = finPushResultRepoProc.getRecord(inter.getInterCode(), docId);
                if (existsRecord != null && UdcEnum.COM_PUSH_RESULT_SUCCESS.getValueCode().equals(existsRecord.getPushResult())) {
                    logger.info("[{}]单据已推送成功：{}, {}", inter.name(), docNo, docId);
                    return;
                }
                Long pushResultId = existsRecord == null ? null : existsRecord.getId();
                if (pushResultId == null) {
                    // 初始化推送记录
                    pushResultId = addPushResult(inter, docNo, docId);
                }

                // 判断是否需要推送和数据格式转换
                T data = docGetter.apply(docId, docNo);
                Object reqBody = null;
                try {
                    String noPushReason = null;
                    if (data == null) {
                        noPushReason = "单据不存在";
                    } else {
                        noPushReason = supportPush.apply(data);
                    }
                    if (noPushReason != null) {
                        logger.info("不支持推送的单据：{}, {}, {}", docNo, docId, noPushReason);
                        finPushResultRepoProc.updatePushNoop(pushResultId, noPushReason);
                        return;
                    }
                    reqBody = reqBodyConverter.apply(data);
                } catch (Throwable e) {
                    logger.error("推送BIP时发送异常：{}, {}", docNo, docId, e);
                    String errorMsg = ExceptionUtil.getRootCauseMessage(e);
                    finPushResultRepoProc.updatePushFail(pushResultId, errorMsg);
                    purPushRecordRepository.saveFailRecord(inter, docId, docNo, errorMsg);
                    purPushRecordRepository.savePushRecord(inter, docNo, docId, null, null, false, LocalDateTime.now(), null, errorMsg);
                    return;
                }

                // 开始推送
                try {
                    Long finalPushResultId = pushResultId;

                    // 如果是集合，则认为是拆单进行推送
                    if (reqBody instanceof Collection) {
                        AtomicInteger i = new AtomicInteger(1);
                        ((Collection<?>) reqBody).forEach(item -> {
                            logger.info("推送第{}单：", i.getAndIncrement());
                            bipPushClient.push(inter, docId, docNo, item, pushRecordId -> finPushResultRepoProc.updatePushRecordId(finalPushResultId, pushRecordId));
                        });
                    } else {
                        bipPushClient.push(inter, docId, docNo, reqBody, pushRecordId -> finPushResultRepoProc.updatePushRecordId(finalPushResultId, pushRecordId));
                    }
                    finPushResultRepoProc.updatePushSuccess(pushResultId);
                } catch (Throwable e) {
                    logger.error("推送BIP时发生异常：{}, {}", docNo, docId, e);
                    String expMsg = e instanceof BipException ? "[BIP响应错误]:" + ((BipException) e).getMessage() : ExceptionUtil.getRootCauseMessage(e);
                    finPushResultRepoProc.updatePushFail(pushResultId, expMsg);
                }
            }, taskExecutor);
            return null;
        };
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    logger.info("事务结束，准备推送：{}, {}", docNo, docId);
                    pusher.get();
                }
            });
        } else {
            logger.info("当前无事务, 准备推送：{}, {}", docNo, docId);
            pusher.get();
        }
    }

    private Long addPushResult(FinPushInter inter, String docNo, Long docId) {
        FinPushResultDO resultDO = new FinPushResultDO();
        resultDO.setTargetType(inter.getTarget().name());
        resultDO.setDocType(inter.getDocType().name());
        resultDO.setDocNo(docNo);
        resultDO.setDocId(docId);
        resultDO.setInterCode(inter.getInterCode());
        resultDO.setPushResult(UdcEnum.COM_PUSH_RESULT_PUSH.getValueCode());
        resultDO.setPushTimeFirst(LocalDateTime.now());
        resultDO.setPushTimeLast(resultDO.getPushTimeFirst());

        finPushResultRepoProc.save(resultDO);
        return resultDO.getId();
    }
}