/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flow;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowDealerParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowFixParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.facade.vo.push.FinPushResultVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.fin.application.service.flow.AccountFlowFjbService;
import com.elitesland.fin.application.service.flow.AccountFlowPjService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowTcService;
import com.elitesland.fin.application.service.flow.AccountFlowZcService;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.application.service.saobei.SaobeiAccountService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.AccountFlow.AccountFlowDomainService;
import com.elitesland.fin.domain.service.account.AccountDomainService;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.provider.bip.BipFinService;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.repo.push.FinPushResultRepoProc;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.fin.utils.SysUtils;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuBankAccRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgBankAccQueryRpcParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.google.common.collect.Lists;
import com.saobei.open.sdk.model.requst.allocate.SaobeiDoTransRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.redisson.RedissonRedLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

@Service
public class AccountFlowServiceImpl
implements AccountFlowService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowServiceImpl.class);
    @Autowired
    private AccountFlowRepo accountFlowRepo;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;
    @Autowired
    private AccountFlowZcService accountFlowZcService;
    @Autowired
    private AccountFlowPjService accountFlowPjService;
    @Autowired
    private AccountFlowFjbService accountFlowFjbService;
    @Autowired
    private AccountFlowTcService accountFlowTcService;
    @Autowired
    private AccountFlowCommonService accountFlowCommonService;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private AccountRepo accountRepo;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    @Autowired
    private AccountRuleConfigRepo accountRuleConfigRepo;
    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;
    @Autowired
    private AccountFlowService accountFlowService;
    @Autowired
    private AccountIocService accountIocService;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private AccountRuleConfigService accountRuleConfigService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private FinSalMqProcessor finSalMqProcessor;
    @Autowired
    private RedLockUtils redLockUtils;
    @Autowired
    private FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private MyRedisService myRedisService;
    @Autowired
    private AccountDomainService accountDomainService;
    @Autowired
    private AccountFlowDomainService accountFlowDomainService;
    @Autowired
    private SaobeiAccountService saobeiAccountService;
    @Autowired
    private OrgAddrRpcService orgAddrRpcService;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private FinPushResultRepoProc finPushResultRepoProc;
    private static final BigDecimal ONE_HUNDRED_BIGDECIMAL = new BigDecimal("100");
    @Autowired
    private AdjustOrderRepo adjustOrderRepo;

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> page(AccountFlowPageParam pageParam) {
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List accountFlowVOList = pagingVO.getRecords();
        List<String> companyCodes = accountFlowVOList.stream().map(AccountFlowVO::getFromOuCode).filter(Objects::nonNull).collect(Collectors.toList());
        companyCodes.addAll(accountFlowVOList.stream().map(AccountFlowVO::getToOuCode).filter(Objects::nonNull).collect(Collectors.toList()));
        companyCodes.addAll(accountFlowVOList.stream().map(AccountFlowVO::getCompanyCode).filter(Objects::nonNull).collect(Collectors.toList()));
        Map<String, String> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(companyCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));
        List accountRuleConfigDOList = this.accountRuleConfigRepo.findAll();
        Set<Long> ids = accountFlowVOList.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
        Map<Long, FinPushResultVO> bipPushResultMap = this.finPushResultRepoProc.queryByDocId(ids, FinPushInter.BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE);
        accountFlowVOList.stream().forEach(item -> {
            AccountRuleConfigDO accountRuleConfigDOResult;
            if (StringUtils.isNotBlank((CharSequence)item.getCompanyCode())) {
                item.setFromOuName((String)ouMap.get(item.getFromOuCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getTouCode())) {
                item.setToOuName((String)ouMap.get(item.getToOuCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getCompanyCode())) {
                item.setCompanyCodeName((String)ouMap.get(item.getCompanyCode()));
            }
            if ((accountRuleConfigDOResult = (AccountRuleConfigDO)accountRuleConfigDOList.stream().filter(accountRuleConfigDO -> StringUtils.equals((CharSequence)item.getRuleCode(), (CharSequence)accountRuleConfigDO.getRuleCode())).findFirst().orElse(null)) != null) {
                item.setRuleName(accountRuleConfigDOResult.getRuleName());
            }
            item.setBipPushResult((FinPushResultVO)bipPushResultMap.get(item.getId()));
            item.setOptType(SysUtils.getOptType(item.getSourceDocStatus()));
        });
        if (!CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            this.flexFieldUtilService.handleFlexFieldShowNameForVO("ACCOUNT_FLOW", pagingVO.getRecords());
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectBySourceAndNo(String dataSource, String sourceNo) {
        if (StringUtils.isEmpty((CharSequence)dataSource)) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)sourceNo)) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        AccountFlowPageParam accountFlowPageParam = new AccountFlowPageParam();
        accountFlowPageParam.setDataSource(dataSource);
        accountFlowPageParam.setSourceNoEq(sourceNo);
        List<AccountFlowVO> accountFlowVOList = this.accountFlowRepoProc.selectListByParam(accountFlowPageParam);
        if (CollectionUtils.isEmpty(accountFlowVOList)) {
            return Collections.emptyList();
        }
        return accountFlowVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getYearMonthStr())) {
            LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
            this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        }
        pageParam.setAccIoTypeList(Lists.newArrayList((Object[])new String[]{"ADD", "SUB"}));
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.dealerPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    public AccountFlowDealerVO dealerSelectAmt(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
        this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setUseAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setRecordAmt(BigDecimal.ZERO);
        pageParam.setAccIoType("ADD");
        List<AccountFlowVO> addAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(addAmtList)) {
            BigDecimal recordAmt = addAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setRecordAmt(recordAmt);
        }
        pageParam.setAccIoType("SUB");
        List<AccountFlowVO> subAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(subAmtList)) {
            BigDecimal useAmt = subAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setUseAmt(useAmt);
        }
        return accountFlowDealerVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowVO save(List<AccountFlowParam> paramList) {
        log.info("\u83b7\u53d6\u6d41\u6c34\u5165\u53c2{}", (Object)JSON.toJSONString(paramList));
        this.checkMandatoryFieldList(paramList);
        this.checkRepeatability(paramList);
        this.distinguishAccType(paramList);
        return new AccountFlowVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowDO saveAccountFlow(AccountFlowParam accountFlowParam) {
        this.checkMandatoryField(accountFlowParam);
        AccountFlowDO accountFlowDO = AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam);
        this.flexFieldUtilService.handFlexFieldValueFeference("ACCOUNT_FLOW", (Object)accountFlowDO);
        return (AccountFlowDO)((Object)this.accountFlowRepo.save((Object)accountFlowDO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fixAccountFlow(List<AccountFlowFixParam> paramList) {
        GeneralUserDetails userDetails = com.elitescloud.boot.auth.util.SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        SysUserDTO user = userDetails.getUser();
        for (AccountFlowFixParam accountFlowFixParam : paramList) {
            AccountFlowDO accountFlowDO = this.accountFlowRepoProc.getLatestFlowBeforeTime(accountFlowFixParam.getAccountCode(), accountFlowFixParam.getAccountType(), accountFlowFixParam.getTransactionTime());
            if (accountFlowDO == null) {
                throw new com.cloudt.apm.common.exception.BusinessException("\u672a\u627e\u5230\u4e0a\u4e00\u6761\u6d41\u6c34" + accountFlowFixParam.getAccountCode() + "," + accountFlowFixParam.getAccountType() + "," + accountFlowFixParam.getTransactionTime());
            }
            List<AccountDO> allByAccountCode = this.accountRepo.findAllByAccountCode(accountFlowDO.getAccountCode());
            if (CollectionUtils.isEmpty(allByAccountCode)) {
                throw new com.cloudt.apm.common.exception.BusinessException("\u672a\u627e\u5230\u8d26\u6237" + accountFlowDO.getAccountCode());
            }
            AccountDO account = allByAccountCode.stream().filter(accountDO -> accountDO.getAccountType().equals(accountFlowDO.getAccountType())).findFirst().orElseThrow(() -> new com.cloudt.apm.common.exception.BusinessException("\u672a\u627e\u5230\u8d26\u6237" + accountFlowDO.getAccountCode() + "," + accountFlowDO.getAccountType()));
            AdjustOrderDO adjustOrderDO = new AdjustOrderDO();
            adjustOrderDO.setRemark(accountFlowFixParam.getRemark());
            String generate = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
            adjustOrderDO.setDocNo(generate);
            adjustOrderDO.setState("COMPLETE");
            adjustOrderDO.setType("YETZ");
            adjustOrderDO.setRecAccTime(accountFlowFixParam.getTransactionTime());
            adjustOrderDO.setAccName(accountFlowDO.getAccountName());
            adjustOrderDO.setAccCode(accountFlowDO.getAccountCode());
            adjustOrderDO.setAccType(accountFlowFixParam.getAccountType());
            adjustOrderDO.setTotalAmt(accountFlowFixParam.getAmount());
            adjustOrderDO.setAuditUser(user.getLastName());
            adjustOrderDO.setAuditUserId(user.getId());
            adjustOrderDO.setAuditTime(accountFlowFixParam.getTransactionTime());
            adjustOrderDO.setAdjReason("2");
            adjustOrderDO.setRemark(accountFlowFixParam.getRemark());
            if (Objects.equals(accountFlowFixParam.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
                adjustOrderDO.setAdjType("2");
            } else if (Objects.equals(accountFlowFixParam.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
                adjustOrderDO.setAdjType("1");
            }
            adjustOrderDO.setAccountHolderName(account.getAccountHolderName());
            adjustOrderDO.setAccountHolderCode(account.getAccountHolderCode());
            AdjustOrderDO savedAdjustOrder = (AdjustOrderDO)((Object)this.adjustOrderRepo.save((Object)adjustOrderDO));
            AccountFlowDO newAccountFlowDO = new AccountFlowDO();
            BeanUtils.copyProperties((Object)((Object)accountFlowDO), (Object)((Object)newAccountFlowDO), (String[])new String[0]);
            String flowNo = this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList());
            newAccountFlowDO.setId(null);
            newAccountFlowDO.setFlowNo(flowNo);
            newAccountFlowDO.setTransactionTime(accountFlowFixParam.getTransactionTime());
            newAccountFlowDO.setAmount(accountFlowFixParam.getAmount());
            newAccountFlowDO.setTransactionType(accountFlowFixParam.getTransactionType());
            newAccountFlowDO.setRemark(accountFlowFixParam.getRemark());
            newAccountFlowDO.setCompanyCode(null);
            newAccountFlowDO.setSourceDoc("AO");
            newAccountFlowDO.setSourceNo(savedAdjustOrder.getDocNo());
            newAccountFlowDO.setSourceId(savedAdjustOrder.getId());
            newAccountFlowDO.setSourceDocStatus("AO_COMPLETE");
            newAccountFlowDO.setRuleCode("TZ001");
            newAccountFlowDO.setPriorityNo(8);
            newAccountFlowDO.setBusinessType(null);
            newAccountFlowDO.setTOuCode(null);
            newAccountFlowDO.setToOuCode(null);
            newAccountFlowDO.setFromOuCode(null);
            newAccountFlowDO.setRootDoc(null);
            newAccountFlowDO.setRootDocNo(null);
            newAccountFlowDO.setAuditUserId(user.getId());
            newAccountFlowDO.setAuditUserName(user.getLastName());
            newAccountFlowDO.setAuditDate(accountFlowFixParam.getTransactionTime());
            if (Objects.equals(accountFlowFixParam.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
                newAccountFlowDO.setAccountAmount(accountFlowDO.getAccountAmount().subtract(accountFlowFixParam.getAmount()));
                newAccountFlowDO.setAccountAvailableAmount(accountFlowDO.getAccountAvailableAmount().subtract(accountFlowFixParam.getAmount()));
            } else if (Objects.equals(accountFlowFixParam.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
                newAccountFlowDO.setAccountAmount(accountFlowDO.getAccountAmount().add(accountFlowFixParam.getAmount()));
                newAccountFlowDO.setAccountAvailableAmount(accountFlowDO.getAccountAvailableAmount().add(accountFlowFixParam.getAmount()));
            }
            this.accountFlowRepo.save((Object)newAccountFlowDO);
        }
    }

    @Override
    public AccountFlowDO saveAccountFlowWithOutTx(AccountFlowParam accountFlowParam) {
        this.checkMandatoryField(accountFlowParam);
        AccountFlowDO accountFlowDO = AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam);
        this.flexFieldUtilService.handFlexFieldValueFeference("ACCOUNT_FLOW", (Object)accountFlowDO);
        return (AccountFlowDO)((Object)this.accountFlowRepo.save((Object)accountFlowDO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAccountFlowList(List<AccountFlowParam> accountFlowParams) {
        accountFlowParams.stream().forEach(v -> {
            AccountFlowDO accountFlowDO = this.saveAccountFlowWithOutTx((AccountFlowParam)((Object)v));
            v.setId(accountFlowDO.getId());
        });
    }

    private void distinguishAccType(List<AccountFlowParam> paramList) {
        List<AccountFlowParam> accountFlowTcList;
        List<AccountFlowParam> accountFlowFjbList;
        List<AccountFlowParam> accountFlowPjList;
        List<AccountFlowParam> accountFlowZcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeZcAccType(param.getAccType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(accountFlowZcList)) {
            this.accountFlowZcService.saveZc(accountFlowZcList);
        }
        if (!CollectionUtils.isEmpty(accountFlowPjList = paramList.stream().filter(param -> this.accountFlowCommonService.judgePjAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowPjService.savePj(accountFlowPjList);
        }
        if (!CollectionUtils.isEmpty(accountFlowFjbList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeFjbAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowFjbService.saveFjb(accountFlowFjbList);
        }
        if (!CollectionUtils.isEmpty(accountFlowTcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeTcAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowTcService.saveTc(accountFlowTcList);
        }
    }

    @Override
    public void checkMandatoryFieldList(List<AccountFlowParam> paramList) {
        Assert.notEmpty(paramList, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        paramList.stream().forEach(accountFlowParam -> this.checkMandatoryField((AccountFlowParam)((Object)accountFlowParam)));
    }

    @Override
    public void checkMandatoryField(AccountFlowParam param) {
        if (StringUtils.isBlank((CharSequence)param.getAccountType())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceDoc())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u636e\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceNo())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getTransactionType())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getAmount())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u53d1\u751f\u91d1\u989d\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getTransactionTime())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountCode())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountName())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a!");
        }
    }

    @Override
    public void checkRepeatability(List<AccountFlowParam> paramList) {
        List dataSourceList = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dataSourceList) && dataSourceList.size() > 1) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b58\u5728\u591a\u79cd\u6570\u636e\u6765\u6e90!");
        }
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getAccType() + "-" + i.getDataSource() + "-" + i.getTransactionType()));
        for (String accountFlowKey : accountFlowListMap.keySet()) {
            List<AccountFlowParam> accountFlowList = accountFlowListMap.get(accountFlowKey);
            String[] keyParams = accountFlowKey.split("-");
            String dataSource = keyParams[1];
            if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
                List splitTypeList = accountFlowList.stream().map(AccountFlowParam::getSplitType).distinct().collect(Collectors.toList());
                if (Objects.equals(accountFlowList.size(), splitTypeList.size())) continue;
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8c03\u5242\u5355\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
            }
            if (CollectionUtils.isEmpty(accountFlowList) || accountFlowList.size() <= 1) continue;
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
        }
    }

    @Override
    public void checkMandatoryField02(AccountFlowPageParam pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getYearMonthStr())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccCode())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccType())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
    }

    @Override
    public AccountFlowDealerVO dealerSelectAccAmt(AccountFlowDealerParam param) {
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setCzAccAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setFlAccAmt(BigDecimal.ZERO);
        Optional<AccountFlowVO> czOptional = this.accountFlowCommonService.selectByAccCode(param.getCzAccCode());
        czOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setCzAccAmt(accountFlowVO.getAccAmt()));
        Optional<AccountFlowVO> flOptional = this.accountFlowCommonService.selectByAccCode(param.getFlAccCode());
        flOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setFlAccAmt(accountFlowVO.getAccAmt()));
        return accountFlowDealerVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(AccountFlowParam accountFlowParam) {
        this.checkApproveParam(accountFlowParam);
        this.approve(accountFlowParam, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode(), true);
    }

    @Override
    public void autoApprove(AccountFlowParam accountFlowParam) {
        this.updateAccountAmountAndApprove(accountFlowParam, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(AccountFlowParam accountFlowParam) {
        this.checkApproveParam(accountFlowParam);
        this.approve(accountFlowParam, UdcEnum.APPLY_STATUS_REJECTED.getValueCode(), false);
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.queryByAccountFlowQueryParam(accountFlowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    public void accountFlowCallBack(String doc, AccountFlowDO accountFlowDO, boolean isApprove) {
        if (UdcEnum.DOC_CLS_SVO.getValueCode().equals(doc) || UdcEnum.DOC_CLS_AO.getValueCode().equals(doc)) {
            return;
        }
    }

    private void checkApproveParam(AccountFlowParam accountFlowParam) {
        Assert.notNull((Object)((Object)accountFlowParam), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getAccountCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getTransactionType(), (String)"\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getAmount(), (String)"\u53d1\u751f\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void approve(AccountFlowParam accountFlowParam, String state, boolean isApprove) {
        Optional accountFlowDOOptional = this.accountFlowRepo.findById(accountFlowParam.getId());
        AccountFlowDO accountFlowDO = (AccountFlowDO)((Object)accountFlowDOOptional.get());
        Assert.equals((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode(), (Object)accountFlowDO.getOrderState(), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279", (Object[])new Object[0]);
        this.updateAccountAmountAndApprove(accountFlowParam, state);
    }

    private void updateAccountAmount(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountDO accountDO = this.accountRepoProc.findByAccountCode(accountFlowParam.getAccountCode());
            BigDecimal accountAmount = accountDO.getAccountAmount();
            BigDecimal accountOccupancyAmount = accountDO.getAccountOccupancyAmount();
            Assert.equals((Object)accountDO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountAmount = accountAmount.add(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountAmount = accountAmount.subtract(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountOccupancyAmount = accountOccupancyAmount.add(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountOccupancyAmount = accountOccupancyAmount.subtract(accountFlowParam.getAmount());
            }
            accountDO.setAccountAmount(accountAmount);
            accountDO.setAccountOccupancyAmount(accountOccupancyAmount);
            accountDO.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
            accountFlowParam.setAccountAmount(accountAmount);
            accountFlowParam.setAccountOccupancyAmount(accountOccupancyAmount);
            accountFlowParam.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.accountFlowRepoProc.updateAccountFlowAmount(accountFlowParam);
        }
    }

    private void updateAccountAmountFor_IO_TYPE_T(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountVO accountVOOld = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)accountVOOld.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            int res = this.accountRepo.updateAccountOccupancyAmountAndAccountAvailableAmountById(accountVOOld.getId(), accountFlowParam.getAmount());
            log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
            if (res < 1) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
            }
            AccountVO accountVO = this.accountRepoProc.get(accountVOOld.getId());
            if (accountVO == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(accountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(accountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(accountVO.getAccountAvailableAmount());
            SysUserDTO user = this.getUser();
            accountFlowParam.setOrderState(state);
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            this.accountFlowRepoProc.updateAccountFlowAmountById(accountFlowParam);
        }
    }

    private void updateAccountAmountOther(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountVO newAccountVO;
            AccountVO oldAccountVO = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)oldAccountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newAccountVO = this.accountRepoProc.get(oldAccountVO.getId())) == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            SysUserDTO user = this.getUser();
            accountFlowParam.setOrderState(state);
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            this.accountFlowRepoProc.updateAccountFlowAmountById(accountFlowParam);
        }
    }

    private void updateAccountAmountAndApprove(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountVO newAccountVO;
            AccountVO oldAccountVO = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)oldAccountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
            } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newAccountVO = this.accountRepoProc.get(oldAccountVO.getId())) == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            SysUserDTO user = this.getUser();
            accountFlowParam.setOrderState(state);
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            this.accountFlowRepoProc.updateAccountFlowAmountById(accountFlowParam);
        }
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    @Override
    public String generateAccountFlow(AccountFlowParam param) {
        log.info("\u751f\u6210\u8d26\u6237\u6d41\u6c34\uff0c\u63a5\u6536\u5230\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)((Object)param)));
        this.checkGenerateAccountFlowParam(param);
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.copyParam(param);
        this.buildAccountFlowParam(accountFlowParam);
        AccountDO accountDO = this.getAccountMsg(accountFlowParam);
        log.info("\u8d26\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)((Object)accountDO)));
        if (param.getIgnore() != null && param.getIgnore().booleanValue()) {
            log.info("\u5141\u8bb8\u5ffd\u7565\u5b58\u5728\u6d41\u6c34\u7684\u6821\u9a8c");
            boolean flowExist = this.checkIfSameFlow(accountDO, accountFlowParam);
            if (flowExist) {
                log.info("\u5b58\u5728\u6d41\u6c34,\u76f4\u63a5\u8fd4\u56de,\u8d26\u6237\u4fe1\u606f:{},\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)((Object)accountDO)), (Object)JSONUtil.toJsonStr((Object)((Object)accountFlowParam)));
                return "Flow9999";
            }
        } else if (StrUtil.isEmpty((CharSequence)param.getWorkflowProcInstId())) {
            this.checkIdempotent(accountDO, accountFlowParam);
        }
        List<AccountRuleConfigPageVO> accountRuleConfigPageVOList = this.getAccountRuleMsgWithRedis(accountDO, accountFlowParam);
        List<AccountIocDTO> accountIocDTOList = this.getAccountIocMsgWithRedis(accountRuleConfigPageVOList);
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().sorted(Comparator.comparing(AccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        RedissonRedLock redLock = null;
        try {
            String lockKey = "ACCOUNT_FLOW_GENERATE:" + accountDO.getAccountCode();
            log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u9501:{}", (Object)lockKey);
            redLock = this.redLockUtils.getRedLock(lockKey);
            boolean lockFlag = redLock.tryLock(3L, 300L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6\u9501\u5931\u8d25");
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u6d41\u6c34\u751f\u6210\u5e76\u53d1\u8fc7\u5927,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6\u9501\u6210\u529f");
            AccountVO accountVO = this.accountRepoProc.getVOByCode(accountDO.getAccountCode());
            AccountDO accountDO1 = AccountConvert.INSTANCE.VO2DO(accountVO);
            this.checkAccountAmount(accountRuleConfigPageVOList, accountDO1, accountFlowParam, accountIocDTOList);
            log.info("\u652f\u4ed8\u914d\u7f6e{}\uff0c\u6d41\u6c34\u53c2\u6570{}", (Object)JSONUtil.toJsonStr(accountRuleConfigPageVOList), (Object)JSONUtil.toJsonStr((Object)((Object)accountFlowParam)));
            List<AccountFlowParam> accountFlowParamList = this.buildAccountFlow(accountRuleConfigPageVOList, accountDO1, accountIocDTOList, accountFlowParam);
            log.info("\u8d26\u6237\u7c7b\u578b{}\uff0c\u6d41\u6c34\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)accountVO.getAccountType()), (Object)JSONUtil.toJsonStr(accountFlowParamList));
            boolean out_flag = FinConstant.FLOW_OPT_DOC_STATUS_OUT.contains(param.getSourceDocStatus());
            accountFlowParamList.stream().filter(p -> UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(p.getAccountType())).forEach(p -> {
                if (out_flag) {
                    p.setFromOuCode(p.getTOuCode());
                    p.setToOuCode(p.getOuCode());
                } else {
                    p.setFromOuCode(p.getOuCode());
                    p.setToOuCode(p.getTOuCode());
                }
                p.setCompanyCode(p.getTOuCode());
            });
            List<AccountFlowParam> storeAccountFlowParamList = accountFlowParamList.stream().filter(p -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(p.getAccountType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(storeAccountFlowParamList) && !"AO".equals(param.getSourceDoc())) {
                this.saoBeiTrans(storeAccountFlowParamList, out_flag);
            }
            ArrayList<AccountFlowParam> autoApproveAccountFlowParamList = new ArrayList<AccountFlowParam>();
            ArrayList<AccountFlowParam> notAutoApproveAccountFlowParamList = new ArrayList<AccountFlowParam>();
            accountFlowParamList.stream().forEach(item -> {
                if (item.isAutomaticReview()) {
                    autoApproveAccountFlowParamList.add((AccountFlowParam)((Object)item));
                } else {
                    notAutoApproveAccountFlowParamList.add((AccountFlowParam)((Object)item));
                }
            });
            if (!CollectionUtils.isEmpty(autoApproveAccountFlowParamList)) {
                this.accountFlowDomainService.updateAccountBalanceAndGenerateAccountFlow(autoApproveAccountFlowParamList);
            }
            if (!CollectionUtils.isEmpty(notAutoApproveAccountFlowParamList)) {
                this.accountFlowDomainService.saveAccountFlowList(notAutoApproveAccountFlowParamList);
            }
            for (AccountFlowParam v : accountFlowParamList) {
                ((BipFinService)SpringContextHolder.getBean(BipFinService.class)).pushReceiptOfStorageAccountFlow(v.getId());
            }
            String string = accountFlowParamList.get(0).getFlowNo();
            return string;
        }
        catch (InterruptedException e) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6redis\u9501\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        finally {
            redLock.unlock();
            log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
        }
    }

    private void saoBeiTrans(List<AccountFlowParam> accountFlowParamList, Boolean out_flag) {
        String storeOuCode = accountFlowParamList.get(0).getOuCode();
        List ouCodes = accountFlowParamList.stream().map(AccountFlowParam::getTOuCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        ApiResult storeApiResult = this.orgStoreRpcService.findSimpleByCode(storeOuCode);
        if (storeApiResult.isFailed() || storeApiResult.getData() == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97" + storeOuCode + "\u50a8\u503c\u516c\u53f8\u67e5\u8be2\u5931\u8d25");
        }
        OrgStoreBaseRpcDTO storeBaseRpcDTO = (OrgStoreBaseRpcDTO)storeApiResult.getData();
        if (StringUtils.isEmpty((CharSequence)storeBaseRpcDTO.getStoredOuCode())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97" + storeOuCode + "\u50a8\u503c\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String storeStoredOuCode = storeBaseRpcDTO.getStoredOuCode();
        ouCodes.add(storeStoredOuCode);
        OrgBankAccQueryRpcParam bankAccQueryParam = new OrgBankAccQueryRpcParam();
        bankAccQueryParam.setAccType(UdcEnum.ORG_BANK_TYPE_SAO_BEI.getValueCode());
        bankAccQueryParam.setStatus(UdcEnum.ORG_BANK_STATUS_ACTIVE.getValueCode());
        bankAccQueryParam.setOuCodes(ouCodes);
        List bankList = this.orgAddrRpcService.findOuBankByParam(bankAccQueryParam);
        Map<String, String> ouAccountMap = bankList.stream().collect(Collectors.toMap(OrgOuBankAccRpcDTO::getOuCode, OrgOuBankAccRpcDTO::getBankAcc));
        List noAccountOuCodes = ouCodes.stream().filter(ouCode -> !ouAccountMap.containsKey(ouCode) && !"CONTRACTOR".equals(storeBaseRpcDTO.getStoreType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(noAccountOuCodes)) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u672a\u7ed1\u5b9a\u626b\u5457\u8d26\u6237\uff1a" + String.join((CharSequence)",", noAccountOuCodes));
        }
        accountFlowParamList.forEach(flow -> {
            SaobeiDoTransRequest request = new SaobeiDoTransRequest();
            if (out_flag.booleanValue()) {
                request.setAccount_out((String)ouAccountMap.get(flow.getTOuCode()));
                request.setAccount_in((String)ouAccountMap.get(storeStoredOuCode));
                flow.setFromOuCode(flow.getTOuCode());
                flow.setToOuCode(storeStoredOuCode);
            } else {
                request.setAccount_out((String)ouAccountMap.get(storeStoredOuCode));
                request.setAccount_in((String)ouAccountMap.get(flow.getTOuCode()));
                flow.setFromOuCode(storeStoredOuCode);
                flow.setToOuCode(flow.getTOuCode());
            }
            flow.setCompanyCode(flow.getTOuCode());
            flow.setFromAccountNo(request.getAccount_out());
            flow.setToAccountNo(request.getAccount_in());
            if (flow.getFromAccountNo().equals(flow.getToAccountNo())) {
                flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_4.getValueCode());
            } else {
                flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_0.getValueCode());
            }
        });
    }

    private void accountFlowReview(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            if (item.isAutomaticReview()) {
                this.accountFlowService.approve((AccountFlowParam)((Object)item));
            }
        });
    }

    @Override
    public void updateAccountBalanceAndGenerateAccountFlow(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            AccountVO newAccountVO;
            AccountFlowParam accountFlowParam = item;
            AccountVO oldAccountVO = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)oldAccountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
            } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newAccountVO = this.accountRepoProc.get(oldAccountVO.getId())) == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            SysUserDTO user = this.getUser();
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            TransactionStatus transactionStatus1 = TransactionAspectSupport.currentTransactionStatus();
            AccountFlowDO accountFlowDO = this.accountFlowService.saveAccountFlowWithOutTx(accountFlowParam);
            TransactionStatus transactionStatus2 = TransactionAspectSupport.currentTransactionStatus();
            accountFlowParam.setId(accountFlowDO.getId());
        });
    }

    private List<AccountFlowParam> generateAccountFlow(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList, AccountDO accountDO, List<AccountIocDTO> accountIocDTOList, AccountFlowParam accountFlowParam) {
        List<AccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        ArrayList<AccountFlowParam> accountFlowParamList = new ArrayList<AccountFlowParam>();
        Integer amtRound = SysUtils.getAmtPlace();
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {
            AccountFlowParam param = this.buildAccountFlowParam(accountFlowParam, accountDO, accountIocDTOList, (AccountRuleConfigPageVO)accountRuleConfigPageVO, amtRound);
            AccountFlowDO accountFlowDO = this.accountFlowService.saveAccountFlow(param);
            param.setId(accountFlowDO.getId());
            param.setFlowNo(accountFlowDO.getFlowNo());
            accountFlowParamList.add(param);
        });
        return accountFlowParamList;
    }

    private List<AccountFlowParam> buildAccountFlow(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList, AccountDO accountDO, List<AccountIocDTO> accountIocDTOList, AccountFlowParam originalAccountFlowParam) {
        List<AccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        ArrayList<AccountFlowParam> accountFlowParamList = new ArrayList<AccountFlowParam>();
        Integer amtRound = SysUtils.getAmtPlace();
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {
            AccountFlowParam accountParam = this.buildAccountFlowParam(originalAccountFlowParam, accountDO, accountIocDTOList, (AccountRuleConfigPageVO)accountRuleConfigPageVO, amtRound);
            boolean addFlag = this.addAccountFlowParam((List<AccountFlowParam>)accountFlowParamList, (AccountRuleConfigPageVO)accountRuleConfigPageVO, originalAccountFlowParam, accountParam, amtRound);
            if (!addFlag) {
                accountFlowParamList.add(accountParam);
                accountParam.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
            }
        });
        return accountFlowParamList;
    }

    public boolean addAccountFlowParam(List<AccountFlowParam> accountFlowParamList, AccountRuleConfigPageVO accountRuleConfigPageVO, AccountFlowParam originalAccountFlowParam, AccountFlowParam accountParam, Integer amtRound) {
        AccountFlowParam param;
        boolean addFlag = false;
        if (originalAccountFlowParam.getItemFee() != null && originalAccountFlowParam.getItemFee().compareTo(BigDecimal.ZERO) > 0) {
            param = AccountFlowConvert.INSTANCE.copyParam(accountParam);
            param.setAmount(originalAccountFlowParam.getItemFee().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL, (int)amtRound, RoundingMode.HALF_UP));
            param.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode());
            param.setTOuCode(accountParam.getItemFeeOuCode());
            param.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
            accountFlowParamList.add(param);
            addFlag = true;
        }
        if (originalAccountFlowParam.getMarketingFee() != null && originalAccountFlowParam.getMarketingFee().compareTo(BigDecimal.ZERO) > 0) {
            param = AccountFlowConvert.INSTANCE.copyParam(accountParam);
            param.setAmount(originalAccountFlowParam.getMarketingFee().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL, (int)amtRound, RoundingMode.HALF_UP));
            param.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_MARKETING.getValueCode());
            param.setTOuCode(accountParam.getMarketingFeeOuCode());
            param.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
            accountFlowParamList.add(param);
            addFlag = true;
        }
        if (originalAccountFlowParam.getTechFee() != null && originalAccountFlowParam.getTechFee().compareTo(BigDecimal.ZERO) > 0) {
            param = AccountFlowConvert.INSTANCE.copyParam(accountParam);
            param.setAmount(originalAccountFlowParam.getTechFee().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL, (int)amtRound, RoundingMode.HALF_UP));
            param.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_TECH.getValueCode());
            param.setTOuCode(accountParam.getTechFeeOuCode());
            param.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
            accountFlowParamList.add(param);
            addFlag = true;
        }
        if (originalAccountFlowParam.getOperationFee() != null && originalAccountFlowParam.getOperationFee().compareTo(BigDecimal.ZERO) > 0) {
            param = AccountFlowConvert.INSTANCE.copyParam(accountParam);
            param.setAmount(originalAccountFlowParam.getOperationFee().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL, (int)amtRound, RoundingMode.HALF_UP));
            param.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_OPERATION.getValueCode());
            param.setTOuCode(accountParam.getOperationFeeOuCode());
            param.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
            accountFlowParamList.add(param);
            addFlag = true;
        }
        return addFlag;
    }

    @Override
    public Boolean checkAccountBalance(AccountFlowParam param) {
        log.info("\u8d22\u52a1\u6821\u9a8c\u8d26\u6237\u4f59\u989d\u63a5\u53e3\uff0c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)param)));
        this.checkGenerateAccountFlowParam(param);
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.copyParam(param);
        this.buildAccountFlowParam(accountFlowParam);
        AccountDO accountDO = this.getAccountMsg(accountFlowParam);
        this.checkIdempotent(accountDO, accountFlowParam);
        List<AccountRuleConfigPageVO> accountRuleConfigPageVOList = this.getAccountRuleMsg(accountDO, accountFlowParam);
        List<AccountIocDTO> accountIocDTOList = this.getAccountIocMsg(accountRuleConfigPageVOList);
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().sorted(Comparator.comparing(AccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        this.checkAccountAmount(accountRuleConfigPageVOList, accountDO, accountFlowParam, accountIocDTOList);
        return true;
    }

    private void buildAccountFlowParam(AccountFlowParam accountFlowParam) {
        accountFlowParam.setSourceDocType(accountFlowParam.getSourceDoc().concat("_").concat(accountFlowParam.getSourceDocType()));
        accountFlowParam.setSourceDocStatus(accountFlowParam.getSourceDoc().concat("_").concat(accountFlowParam.getSourceDocStatus()));
    }

    private void checkAccountAmount(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList, AccountDO accountDO, AccountFlowParam accountFlowParam, List<AccountIocDTO> accountIocDTOList) {
        accountRuleConfigPageVOList.stream().forEach(item -> {
            AccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(item.getIoCode())).findFirst().orElse(null);
            Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountIocDTO.getIoType())) {
                Assert.isTrue((accountDO.getAccountAvailableAmount().compareTo(accountFlowParam.getSourceDocAmount().multiply(item.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL)) >= 0 ? 1 : 0) != 0, (String)"\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
            }
        });
    }

    private void checkIdempotent(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountFlowQueryParam accountFlowQueryParam = new AccountFlowQueryParam();
        accountFlowQueryParam.setSourceId(accountFlowParam.getSourceId());
        accountFlowQueryParam.setSourceDoc(accountFlowParam.getSourceDoc());
        accountFlowQueryParam.setSourceDocStatus(accountFlowParam.getSourceDocStatus());
        accountFlowQueryParam.setSourceNo(accountFlowParam.getSourceNo());
        accountFlowQueryParam.setAccountType(accountDO.getAccountType());
        if (ObjUtil.equals((Object)accountFlowParam.getOverOneFlow(), (Object)Boolean.TRUE)) {
            accountFlowQueryParam.setAccountCode(accountFlowParam.getAccountCode());
        }
        Assert.isTrue((boolean)CollectionUtils.isEmpty(this.accountFlowService.queryByAccountFlowQueryParam(accountFlowQueryParam)), (String)"\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u8fc7\u6d41\u6c34", (Object[])new Object[0]);
    }

    private boolean checkIfSameFlow(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountFlowQueryParam accountFlowQueryParam = new AccountFlowQueryParam();
        accountFlowQueryParam.setSourceId(accountFlowParam.getSourceId());
        accountFlowQueryParam.setSourceDoc(accountFlowParam.getSourceDoc());
        accountFlowQueryParam.setSourceDocStatus(accountFlowParam.getSourceDocStatus());
        accountFlowQueryParam.setSourceNo(accountFlowParam.getSourceNo());
        accountFlowQueryParam.setAccountType(accountDO.getAccountType());
        if (ObjUtil.equals((Object)accountFlowParam.getOverOneFlow(), (Object)Boolean.TRUE)) {
            accountFlowQueryParam.setAccountCode(accountFlowParam.getAccountCode());
        }
        return CollUtil.isNotEmpty(this.accountFlowService.queryByAccountFlowQueryParam(accountFlowQueryParam));
    }

    private List<AccountIocDTO> getAccountIocMsg(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        HashSet<String> ioCodeSet = new HashSet<String>();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        AccountIocParam accountIocParam = new AccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountIocDTO> accountIocDTOList = this.accountIocService.queryByAccountIocParam(accountIocParam);
        Assert.notEmpty(accountIocDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u4e8b\u52a1\u7801\u5931\u8d25", (Object[])new Object[0]);
        return accountIocDTOList;
    }

    private List<AccountIocDTO> getAccountIocMsgWithRedis(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        List<AccountIocDTO> accountIocDTOList = this.myRedisService.getListDataFromRedis("YST_FIN_ACCOUNT_IOC", AccountIocDTO.class, "\u4e8b\u52a1\u7801\u914d\u7f6e", () -> {
            AccountIocParam accountIocParam = new AccountIocParam();
            accountIocParam.setSize(Integer.MAX_VALUE);
            accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
            return this.accountIocService.queryByAccountIocParam(accountIocParam);
        });
        HashSet ioCodeSet = new HashSet();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        if (!CollectionUtils.isEmpty(accountIocDTOList)) {
            accountIocDTOList = accountIocDTOList.stream().filter(v -> ioCodeSet.contains(v.getIoCode())).collect(Collectors.toList());
        }
        Assert.notEmpty(accountIocDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u4e8b\u52a1\u7801\u5931\u8d25", (Object[])new Object[0]);
        return accountIocDTOList;
    }

    public AccountFlowParam buildAccountFlowParam(AccountFlowParam accountFlowParam, AccountDO accountDO, List<AccountIocDTO> accountIocDTOList, AccountRuleConfigPageVO accountRuleConfigPageVO, Integer amtRound) {
        AccountFlowParam result = new AccountFlowParam();
        result.setCompanyCode(accountFlowParam.getOuCode());
        result.setOuCode(accountFlowParam.getOuCode());
        result.setTOuCode(accountFlowParam.getTOuCode());
        result.setSecFranchiseeCode(accountDO.getSecFranchiseeCode());
        AccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(accountRuleConfigPageVO.getIoCode())).findFirst().orElse(null);
        Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
        result.setTransactionType(accountIocDTO.getIoType());
        result.setAmount(accountFlowParam.getSourceDocAmount().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL, (int)amtRound, RoundingMode.HALF_UP));
        result.setTransactionTime(LocalDateTime.now());
        result.setAccountHolderName(accountDO.getAccountHolderName());
        result.setAccountType(accountDO.getAccountType());
        result.setAccountCode(accountDO.getAccountCode());
        result.setAccountName(accountDO.getAccountName());
        result.setSourceDoc(accountFlowParam.getSourceDoc());
        result.setSourceNo(accountFlowParam.getSourceNo());
        result.setSourceId(accountFlowParam.getSourceId());
        result.setRuleCode(accountRuleConfigPageVO.getRuleCode());
        result.setPriorityNo(accountRuleConfigPageVO.getPriorityNo());
        result.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        result.setSourceDocStatus(accountFlowParam.getSourceDocStatus());
        result.setAutomaticReview(accountRuleConfigPageVO.isAutomaticReview());
        result.setAccountAmount(accountDO.getAccountAmount());
        result.setAccountOccupancyAmount(accountDO.getAccountOccupancyAmount());
        result.setAccountAvailableAmount(accountDO.getAccountAvailableAmount());
        result.setExtensionInfo(accountFlowParam.getExtensionInfo());
        result.setItemFeeOuCode(accountFlowParam.getItemFeeOuCode());
        result.setMarketingFeeOuCode(accountFlowParam.getMarketingFeeOuCode());
        result.setTechFeeOuCode(accountFlowParam.getTechFeeOuCode());
        result.setOperationFeeOuCode(accountFlowParam.getOperationFeeOuCode());
        result.setRootDoc(accountFlowParam.getRootDoc());
        result.setRootDocNo(accountFlowParam.getRootDocNo());
        result.setRemark(accountFlowParam.getRemark());
        return result;
    }

    private List<AccountRuleConfigPageVO> getAccountRuleMsg(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountRuleConfigQueryParam accountRuleConfigQueryParam = new AccountRuleConfigQueryParam();
        accountRuleConfigQueryParam.setOptDoc(accountFlowParam.getSourceDoc());
        accountRuleConfigQueryParam.setOptDocType(accountFlowParam.getSourceDocType());
        accountRuleConfigQueryParam.setOptDocStatus(accountFlowParam.getSourceDocStatus());
        accountRuleConfigQueryParam.setOptAccountType(accountDO.getAccountType());
        accountRuleConfigQueryParam.setSpecificAccount(accountDO.getAccountCode());
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        PagingVO<AccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.accountRuleConfigService.searchPageWithOutName(accountRuleConfigQueryParam);
        Assert.notNull(accountRuleConfigPageVOPagingVO, (String)"\u67e5\u8be2\u8ba2\u5355\u80fd\u5339\u914d\u5230\u7684\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        Assert.notEmpty((Iterable)accountRuleConfigPageVOPagingVO.getRecords(), (String)"\u6ca1\u6709\u5339\u914d\u5230\u8d26\u6237\u89c4\u5219\u914d\u7f6e", (Object[])new Object[0]);
        return accountRuleConfigPageVOPagingVO.getRecords();
    }

    private List<AccountRuleConfigPageVO> getAccountRuleMsgWithRedis(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountRuleConfigQueryParam accountRuleConfigQueryParam = new AccountRuleConfigQueryParam();
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountRuleConfigPageVO> accountRuleConfigPageVOList = this.myRedisService.getListDataFromRedis("YST_FIN_ACCOUNT_RULE_CONFIG", AccountRuleConfigPageVO.class, "\u8d26\u6237\u89c4\u5219\u914d\u7f6e", () -> {
            accountRuleConfigQueryParam.setSize(Integer.MAX_VALUE);
            PagingVO<AccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.accountRuleConfigService.searchPageWithOutName(accountRuleConfigQueryParam);
            if (accountRuleConfigPageVOPagingVO == null || CollectionUtils.isEmpty((Collection)accountRuleConfigPageVOPagingVO.getRecords())) {
                return null;
            }
            return accountRuleConfigPageVOPagingVO.getRecords();
        });
        if (!CollectionUtils.isEmpty(accountRuleConfigPageVOList)) {
            accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().filter(v -> {
                if (StringUtils.isNotEmpty((CharSequence)accountFlowParam.getSourceDoc()) && !accountFlowParam.getSourceDoc().equals(v.getOptDoc())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)accountFlowParam.getSourceDocType()) && !accountFlowParam.getSourceDocType().equals(v.getOptDocType())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)accountFlowParam.getSourceDocStatus()) && !accountFlowParam.getSourceDocStatus().equals(v.getOptDocStatus())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountType()) && !accountDO.getAccountType().equals(v.getOptAccountType())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)accountDO.getAccountCode())) {
                    if (v.getSpecificAccount() == null) {
                        return true;
                    }
                    if (!accountDO.getAccountCode().equals(v.getSpecificAccount())) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        }
        Assert.notEmpty(accountRuleConfigPageVOList, (String)"\u6ca1\u6709\u5339\u914d\u5230\u8d26\u6237\u89c4\u5219\u914d\u7f6e", (Object[])new Object[0]);
        return accountRuleConfigPageVOList;
    }

    private AccountDO getAccountMsg(AccountFlowParam accountFlowParam) {
        return this.accountRepoProc.findByAccountCode(accountFlowParam.getAccountCode());
    }

    private void checkGenerateAccountFlowParam(AccountFlowParam accountFlowParam) {
        Assert.notNull((Object)((Object)accountFlowParam), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDoc(), (String)"\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDocType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDocStatus(), (String)"\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getSourceId(), (String)"\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getAccountCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectListByQueryParam(queryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam pageParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectRepairAfterPage(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam pageParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectRepairAfter(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> appPage(AccountFlowPageParam pageParam) {
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.appPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List accountFlowVOList = pagingVO.getRecords();
        return PagingVO.builder().total(pagingVO.getTotal()).records(accountFlowVOList).build();
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> appList(AccountFlowPageParam pageParam) {
        return this.accountFlowRepoProc.appList(pageParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        List accountFlowFilterList;
        List accountFlowDOList = this.accountFlowRepo.findAllById(ids);
        if (CollectionUtil.isNotEmpty((Collection)accountFlowDOList) && CollectionUtil.isNotEmpty(accountFlowFilterList = accountFlowDOList.stream().filter(accountFlowDO -> this.deleteCheckAmount(accountFlowDO.getAmount())).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            String checkResult = accountFlowFilterList.stream().map(vo -> "\u6d41\u6c34\u53f7:" + vo.getFlowNo()).collect(Collectors.joining(";", "\u53ea\u6709\u53d1\u751f\u91d1\u989d\u4e3a0\u7684\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new com.elitescloud.boot.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.accountFlowRepoProc.updateDeleteFlagBatch(1, ids);
    }

    private Boolean deleteCheckAmount(BigDecimal amount) {
        if (Objects.isNull(amount) || amount.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        return true;
    }
}

