/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoiceredraft;

import cn.hutool.core.lang.Assert;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.invoiceredraft.InvoiceRedraftConvert;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftQueryParam;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftSaveParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.service.invoiceredraft.InvoiceRedraftService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.saleinvd.SaleInvdService;
import com.elitesland.fin.application.service.unionpay.entity.enums.ProcDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import feign.RetryableException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class InvoiceRedraftServiceImpl
implements InvoiceRedraftService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRedraftServiceImpl.class);
    @Autowired
    private InvoiceRedraftRepo invoiceRedraftRepo;
    @Autowired
    private InvoiceRedraftRepoProc invoiceRedraftRepoProc;
    private final WorkflowService workflowService;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    private final SaleInvService saleInvService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final InvoiceRuleConfigDomainService invoiceRuleConfigDomainService;
    private final SeqNumProvider seqNumProvider;
    private final SaleInvdService saleInvdService;
    private final WorkflowRpcService workflowRpcService;
    private final FlexFieldUtilService flexFieldUtilService;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceRedraftPageVO> page(InvoiceRedraftQueryParam param) {
        PagingVO<InvoiceRedraftPageVO> invoiceRedraftPageVOPagingVO = this.invoiceRedraftRepoProc.queryPaging(param);
        this.flexFieldUtilService.handleFlexFieldShowNameForVO("INVOICE_REDRAFT", invoiceRedraftPageVOPagingVO.getRecords());
        return invoiceRedraftPageVOPagingVO;
    }

    @Override
    @SysCodeProc
    public InvoiceRedraftPageVO detail(Long masId) {
        Optional byId = this.invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            return null;
        }
        InvoiceRedraftPageVO pageVO = InvoiceRedraftConvert.INSTANCE.do2VO((InvoiceRedraftDO)((Object)byId.get()));
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("INVOICE_REDRAFT", (CustomFieldBaseModelVo)pageVO);
        return pageVO;
    }

    @Override
    @Transactional
    public Long saveOrUpdate(InvoiceRedraftSaveParam param) {
        this.validateSaveOrUpdateParam(param);
        return this.persistence(param);
    }

    @Override
    public void delById(Long masId) {
        this.invoiceRedraftRepo.deleteById(masId);
    }

    @Override
    @Transactional
    public String submit(Long masId) {
        Optional byId = this.invoiceRedraftRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u6362\u5f00\u5355\u636e\u4e0d\u5b58\u5728" + masId);
        }
        InvoiceRedraftDO invoiceRedraftDO = (InvoiceRedraftDO)((Object)byId.get());
        HashMap variables = new HashMap();
        ArrayList contractUpdateUserIds = new ArrayList();
        String id = "";
        try {
            if (this.workflowRpcService.checkIsEnableWorkFlow(ProcDefKey.INVOICE_REDRAFT.name()).booleanValue()) {
                WorkflowResult workflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)ProcDefKey.INVOICE_REDRAFT.name(), (String)("\u91cd\u65b0\u5f00\u7968(" + invoiceRedraftDO.getId() + ")\u5ba1\u6279"), (String)(invoiceRedraftDO.getOrigApplyNo() + "#" + invoiceRedraftDO.getId()), variables));
                if (!workflowResult.isSuccess()) {
                    throw new BusinessException(workflowResult.getMsg());
                }
                ProcessInfo processInfo = (ProcessInfo)workflowResult.getData();
                this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.workflowProcInstId, (Object)processInfo.getProcInstId()).set(this.qdo.workflowProcInstStatus, (Object)processInfo.getProcInstStatus()).set(this.qdo.workflowSubmitTime, (Object)LocalDateTime.now()).set((Path)this.qdo.docStatus, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())}).execute();
                id = processInfo.getProcInstId();
                SaleInvdParam saleInvdParam = new SaleInvdParam();
                saleInvdParam.setInvoiceNo(invoiceRedraftDO.getInvoiceNo());
                saleInvdParam.setInvoiceRedraftState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
                this.saleInvdService.update(saleInvdParam);
            }
        }
        catch (RetryableException e) {
            throw new BusinessException("\u91cd\u65b0\u5f00\u7968\u8c03\u7528\u5ba1\u6279\u6d41\u8d85\u65f6");
        }
        return id;
    }

    private void validateSaveOrUpdateParam(InvoiceRedraftSaveParam param) {
        Assert.notBlank((CharSequence)param.getInvoiceType(), (String)"\u53d1\u7968\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getInvoiceDeduction(), (String)"\u53d1\u7968\u662f\u5426\u62b5\u6263\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getRedraftReason(), (String)"\u91cd\u5f00\u7406\u7531\u5fc5\u586b", (Object[])new Object[0]);
    }

    private Long persistence(InvoiceRedraftSaveParam param) {
        if (ObjectUtils.isEmpty((Object)param.getId())) {
            return this.saveConfig(param);
        }
        return this.updateConfig(param);
    }

    private Long saveConfig(InvoiceRedraftSaveParam param) {
        this.checkExist(param);
        InvoiceRedraftDO invoiceRedraftDO = InvoiceRedraftConvert.INSTANCE.param2DO(param);
        invoiceRedraftDO.setOrigApplyNo(param.getOrigApplyNo());
        invoiceRedraftDO.setDocStatus(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        this.flexFieldUtilService.handFlexFieldValueFeference("INVOICE_REDRAFT", (Object)invoiceRedraftDO);
        this.invoiceRedraftRepo.save((Object)invoiceRedraftDO);
        return invoiceRedraftDO.getId();
    }

    private void checkExist(InvoiceRedraftSaveParam param) {
    }

    private Long updateConfig(InvoiceRedraftSaveParam param) {
        Optional byId = this.invoiceRedraftRepo.findById(param.getId());
        if (byId.isEmpty()) {
            throw new BusinessException("\u5f53\u524did\u5bf9\u5e94\u7684\u6362\u5f00\u7533\u8bf7\u4e0d\u5b58\u5728" + param.getId());
        }
        if (ProcInstStatus.APPROVED.equals((Object)((InvoiceRedraftDO)((Object)byId.get())).getWorkflowProcInstStatus()) || ProcInstStatus.APPROVING.equals((Object)((InvoiceRedraftDO)((Object)byId.get())).getWorkflowProcInstStatus())) {
            throw new BusinessException("\u5f53\u524d\u6362\u5f00\u7533\u8bf7\u5ba1\u6279\u6b63\u5728\u8fdb\u884c\u6216\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539" + param.getId());
        }
        InvoiceRedraftDO invoiceRedraftDO = InvoiceRedraftConvert.INSTANCE.param2DO(param);
        this.flexFieldUtilService.handFlexFieldValueFeference("INVOICE_REDRAFT", (Object)invoiceRedraftDO);
        this.invoiceRedraftRepoProc.update(invoiceRedraftDO);
        return param.getId();
    }

    public InvoiceRedraftServiceImpl(WorkflowService workflowService, JPAQueryFactory jpaQueryFactory, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvdDtlRepoProc saleInvdDtlRepoProc, SaleInvService saleInvService, SaleInvdDtlRepo saleInvdDtlRepo, InvoiceRuleConfigDomainService invoiceRuleConfigDomainService, SeqNumProvider seqNumProvider, SaleInvdService saleInvdService, WorkflowRpcService workflowRpcService, FlexFieldUtilService flexFieldUtilService) {
        this.workflowService = workflowService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.saleInvService = saleInvService;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.invoiceRuleConfigDomainService = invoiceRuleConfigDomainService;
        this.seqNumProvider = seqNumProvider;
        this.saleInvdService = saleInvdService;
        this.workflowRpcService = workflowRpcService;
        this.flexFieldUtilService = flexFieldUtilService;
    }
}

