package com.elitesland.fin.application.facade.param.account;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户表")
public class AccountParam extends BaseModelParam {

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

    @ApiModelProperty("开户主体类型")
    private String accountHolderType;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("账户性质")
    private String accountNature;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("默认账户")
    private boolean defaultAccount;


    //old
    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司类型")
    private String ouType;

    @ApiModelProperty("所属区域")
    private String area;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户名称")
    private String accNameCode;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accAvaAmt;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("区域id")
    private Long areaId;

    @ApiModelProperty("账户编码")
    private Set<String> accountCodes;

    @ApiModelProperty("开户主体名称")
    private Set<String> accountHolderNames;

}