package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDDTO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.*;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.*;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.*;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.repo.invoice.*;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.FinIamUtil;
import com.elitesland.order.param.*;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustRespDTO;
import com.elitesland.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.xxl.job.core.log.XxlJobLogger;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceAwaitServiceImpl implements InvoiceAwaitService {

    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;

    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final InvoiceAwaitDRepoProc invoiceAwaitDRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;

    private final RmiOrgOuRpcServiceService orgRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final TransactionTemplate transactionTemplate;
    private final InvoiceRuleConfigDomainService ruleConfigDomainService;
    private final SystemRpcService systemRpcService;
    private final InvoiceApplyRepoProc invoiceApplyRepoProc;
    private final RmiOrderRpcService rmiOrderRpcService;

    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final SysNumberGenerator sysNumberGenerator;
    private final SaleInvDomainService saleInvDomainService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final UdcProvider udcProvider;

    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;

    private final SalDoRpcService salDoRpcService;

    private final CrmCustRpcService crmCustRpcService;

    private final OrgOuRpcService orgOuRpcService;
    private final FlexFieldUtilService flexFieldUtilService;

    @Lazy
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {
        PagingVO<InvoiceAwaitDTO> pagingDto = invoiceAwaitRepoProc.queryInvoiceAwait(param);

        if(CollectionUtil.isEmpty(pagingDto.getRecords())){
            return PagingVO.builder();
        }

        List<Long> masIds = pagingDto.stream().map(InvoiceAwaitDTO::getId).collect(Collectors.toList());

        List<InvoiceAwaitDDO> dtlDos = invoiceAwaitDRepo.findAllByMasIdIn(masIds);
        Map<Long, List<InvoiceAwaitDDO>> map = dtlDos.stream().collect(Collectors.groupingBy(InvoiceAwaitDDO::getMasId));


        List<InvoiceRuleConfigQueryParam> paramList = new ArrayList<>();
        List<ApplyInvoiceParam> custParamList = new ArrayList<>();
        pagingDto.stream().forEach(dto -> {
            InvoiceRuleConfigQueryParam queryParam = new InvoiceRuleConfigQueryParam();
            queryParam.setOptDocCls(dto.getOptDocCls());
            queryParam.setOptDocType(dto.getOptDocType());
            queryParam.setOptDocStatus(dto.getOptDocStatus());
            paramList.add(queryParam);

            ApplyInvoiceParam custParam = new ApplyInvoiceParam();
            custParam.setCustCode(dto.getMainCustCode());
            custParamList.add(custParam);

        });

        // 查询开票设置
        List<InvoiceRuleConfigDTO> ruleConfigList = ruleConfigDomainService.getRuleConfigList(paramList);
        Map<String, InvoiceRuleConfigDTO> ruleMap = ruleConfigList.stream().collect(Collectors.toMap(rule -> rule.getOptDocCls() + "_" + rule.getOptDocType() + "_" + rule.getOptDocStatus(), t -> t, (t1, t2) -> t1));

        // 查询是否是通用客户
        List<InvoiceCustVO> invoiceCustVOS = new ArrayList<>();
        try {
            invoiceCustVOS = invQuery(custParamList);
        } catch (Exception e) {
            log.error("查询主客户信息失败,错误信息: {}", e.getMessage());
        }
        Map<String, InvoiceCustVO> custVOMap = invoiceCustVOS.stream().collect(Collectors.toMap(InvoiceCustVO::getCustCode, t -> t, (t1, t2) -> t1));

        pagingDto.stream().forEach(item -> {
            List<InvoiceAwaitDDO> ddos = map.get(item.getId());
            item.setCustId(ddos.get(0).getCustId());
            item.setCustCode(ddos.get(0).getCustCode());
            String custName = ddos.get(0).getCustName();
            if (ddos.size() > 1) {
                item.setCustName(custName + "等");
            } else {
                item.setCustName(custName);
            }

            // 开票设置设置为允许编辑并且是通用客商 则允许修改开票抬头客户
            item.setEditInvTitle(0);
            if (ruleMap.containsKey(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus())) {
                Integer editInvTitle = ruleMap.get(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus()).getEditInvTitle();
                item.setEditInvTitle(editInvTitle == null ? 0 : editInvTitle);
            }

            if (custVOMap.containsKey(item.getMainCustCode())) {
                item.setEs3(StrUtil.equals(custVOMap.get(item.getMainCustCode()).getEs3(), "1") ? "1" : "0");
            }
            if (StrUtil.equals(item.getEs3(), "1") && ObjectUtil.equals(item.getEditInvTitle(), 1)) {
                item.setEditInvTitle(1);
            } else {
                item.setEditInvTitle(0);
            }

        });

        PagingVO<InvoiceAwaitVO> invoiceAwaitVOPagingVO = InvoiceAwaitConvert.INSTANCE.pagingDto2Vo(pagingDto);
        if(CollectionUtil.isNotEmpty(invoiceAwaitVOPagingVO.getRecords())){
            flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.INVOICE_AWAIT,invoiceAwaitVOPagingVO.getRecords());
        }
        return invoiceAwaitVOPagingVO;
    }

    @Override
    @SysCodeProc
    public List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId) {
        List<InvoiceAwaitDDO> list = invoiceAwaitDRepo.findAllByMasId(masId);
        return InvoiceAwaitDConvert.INSTANCE.dos2Vos(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<InvoiceSaveVO> invoiceApply(InvoiceApplyParam param) {
        // 开票申请
        return abstractInvoiceSaveService.save(param);
    }

    @Override
    public List<InvoiceApplySaveParam> getInvoiceApplySaveParams(List<InvoiceAwaitRespVO> records) {
        // 查询开票设置
        Set<String> optDocClsSet = records.stream().map(InvoiceAwaitRespVO::getOptDocCls).collect(Collectors.toSet());
        List<InvoiceRuleConfigDTO> configDTOList = getInvoiceRuleConfigDTOS(optDocClsSet);

        // 申请单按照单据分类 获取开票设置
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = groupByDocCls(records, configDTOList);

        // 发票待申请数据根据不同单据名称转成销售发票申请数据
        List<InvoiceApplySaveParam> saveParams = new ArrayList<>();
        optDocClsMap.forEach((key, invoiceAwaitRespVOList) -> {
            InvoiceApplySaveParam saveParam = getInvoiceApplySaveParam(invoiceAwaitRespVOList);
            saveParams.add(saveParam);
        });
        return saveParams;
    }

    /**
     * 根据发票规则分类
     *
     * @param records
     * @return
     */
    @Override
    public Map<String, List<InvoiceAwaitRespVO>> groupByDocCls(List<InvoiceAwaitRespVO> records, List<InvoiceRuleConfigDTO> configDTOList) {
        // 按照来源单据分类 同一种来源单据开一张发票
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = records.stream().collect(Collectors.groupingBy(InvoiceAwaitRespVO::getOptDocCls));

        // 没有查询到配置 设置为不自动审核通过
        if (CollectionUtil.isEmpty(configDTOList)) {
            optDocClsMap.forEach((key, value) -> value.forEach(vo -> vo.setAutoReview(Boolean.FALSE)));
        } else {
            configDTOList.forEach(config -> {
                // 同一种单据分类 有一条配置是不自动审核的 设置为不自动审核通过
                if (ObjUtil.equals(config.getAutoReview(), 0)) {
                    List<InvoiceAwaitRespVO> voList = optDocClsMap.get(config.getOptDocCls());
                    voList.forEach(vo -> vo.setAutoReview(Boolean.FALSE));
                }
            });
        }
        return optDocClsMap;
    }

    // 根据单据获取发票设置
    private List<InvoiceRuleConfigDTO> getInvoiceRuleConfigDTOS(Set<String> optDocClsSet) {
        List<InvoiceRuleConfigQueryParam> queryParamList = new ArrayList<>();
        optDocClsSet.forEach(cls -> {
            InvoiceRuleConfigQueryParam configQueryParam = new InvoiceRuleConfigQueryParam();
            configQueryParam.setOptDocCls(cls);
            queryParamList.add(configQueryParam);
        });
        return ruleConfigDomainService.getRuleConfigList(queryParamList);
    }

    /**
     * 开票参数校验
     *
     * @param param
     */
    @Override
    public List<InvoiceAwaitRespVO> checkAndQueryInvoiceAwait(InvoiceApplyParam param) {
        Assert.notNull(param.getCustInvTitle(), "开票抬头不能为空");
        Assert.notNull(param.getCustTaxNo(), "税号不能为空");
        Assert.notEmpty(param.getIds(), "没有选择待开发票");
        Assert.notBlank(param.getInvType(), "没有选择发票类型");

        List<InvoiceAwaitRespVO> records = invoiceAwaitRepoProc.findByIds(param.getIds());
        Assert.notEmpty(records,"没有查询到待开票信息");

        Set<String> custCodeSet = records.stream().map(InvoiceAwaitRespVO::getMainCustCode).collect(Collectors.toSet());
        Assert.isTrue(custCodeSet.size() == 1, "所选待开发票所属主客户信息不唯一");

        List<InvoiceAwaitDO> awaitDOS = invoiceAwaitRepo.findAllById(param.getIds());
        awaitDOS.forEach(await -> Assert.isTrue(StrUtil.equalsAny(await.getInvoiceAwaitStatus(), UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode(), UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode()), "只能选择状态为待开票或者红冲完成的单据"));

        // 查询是否已开发票
//        List<Long> docIdList = records.stream().map(record -> record.getMasId()).collect(Collectors.toList());
//        InvoiceQueryParam invoiceQueryParam = new InvoiceQueryParam();
//        invoiceQueryParam.setSourceDocId(docIdList);
//        List<InvoiceApplyRpcDTO> dtos = invoiceApplyRepoProc.queryIdBySource(invoiceQueryParam);
//        Assert.isTrue(CollectionUtil.isEmpty(dtos), "单据已开票，不能重复操作");


        records = records.stream().peek(record -> {
            record.setInvoiceType(param.getInvType());
        }).toList();
        return records;
    }

    public void setInvoice(InvoiceApplySaveParam saveParam, ApplySaveParam invoice) {
        // 加盟商 - 税号
        saveParam.setCustTaxNo(invoice.getCustTaxNo());
        // 加盟商 - 开票抬头
        saveParam.setCustInvTitle(invoice.getCustInvTitle());
        // 加盟商 - 开票地址
        saveParam.setCustAdd(invoice.getAddress());
        // 加盟商 - 开户银行
        saveParam.setCustBank(invoice.getCustBank());
        // 加盟商 - 银行账号
        saveParam.setCustBankAcc(invoice.getCustBankAcc());
        // 加盟商 - 电话
        saveParam.setCustTel(invoice.getCustTel());
        // 发票类型
        saveParam.setInvType(invoice.getInvType());
    }

    private InvoiceApplySaveParam getInvoiceApplySaveParam(List<InvoiceAwaitRespVO> records) {
        InvoiceAwaitRespVO record = records.get(0);

        InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();

        saveParam.setInvoiceId(record.getMasId());
        saveParam.setSourceSysNo(record.getOptDocNo());
        saveParam.setOptDocId(record.getOptDocId());

        // 销售公司
        setSaleCompanyInfo(record, saveParam);
        // 设置客户发票抬头信息
        setCustInfo(record, saveParam);
        // 汇率
        saveParam.setExchangeRate(record.getCurrRate());
        // 开票人
        saveParam.setInvUser(FinIamUtil.currentUserName());
        // 收款人
        saveParam.setRecUser(FinIamUtil.currentUserName());
        // 复核人
        saveParam.setRevUser(FinIamUtil.currentUserName());

        // 相同商品合并开票（默认：是）
        saveParam.setInvMerge("1");
        // 开票申请金额
        BigDecimal total = records.stream().map(InvoiceAwaitRespVO::getInvAmt).filter(ObjectUtil::isNotNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        saveParam.setTotalAmt(total);
        // 发票类型
        saveParam.setInvType(record.getInvoiceType());
        // 来源单据
        saveParam.setCreateMode(record.getOptDocCls());

        saveParam.setPkGroup(record.getPkGroup());
        saveParam.setSettlementType(record.getSettlementType());
        saveParam.setOpenInvType(record.getOpenInvType());

        // 生成发号器
        String applyNo = systemRpcService.sysNumberRuleGenerateCode(FinConstant.FIN, FinConstant.XXFP, new ArrayList<>());
        saveParam.setApplyNo(applyNo);
        record.setInvoiceApplyNo(applyNo);

        // 设置发票详情
        List<InvoiceDetailSaveParam> details = getInvoiceDetails(records);
        saveParam.setDetails(details);

        // 开票信息
        saveParam.setCustInvTitle(record.getInvTitle());
        saveParam.setCustTaxNo(record.getTaxerNo());
        saveParam.setInvType(record.getInvType());
        saveParam.setCustBank(record.getInvBankName());
        saveParam.setCustBankAcc(record.getInvBankAcc());
        saveParam.setCustTel(record.getInvTel());
        saveParam.setCustAdd(record.getInvAddress());
        saveParam.setInvTitleType(record.getInvTitleType());
        saveParam.setInvPicName(record.getInvPicName());
        saveParam.setInvPicPhone(record.getInvPicPhone());
        saveParam.setInvEmail(record.getInvEmail());
        saveParam.setRecApplyTime(record.getRecApplyTime());
        return saveParam;
    }

    // 设置发票详情
    @NotNull
    private List<InvoiceDetailSaveParam> getInvoiceDetails(List<InvoiceAwaitRespVO> records) {
        List<InvoiceDetailSaveParam> details = new ArrayList<>();
        for (int i = 0; i < records.size(); i++) {
            InvoiceAwaitRespVO row = records.get(i);
            InvoiceDetailSaveParam detail = InvoiceAwaitDConvert.INSTANCE.awaitVo2InvoiceParam(row);
            detail.setInvoiceAwaitId(row.getMasId());
            // 行号
            detail.setLineNo(i + 1);
            // 收发货单id
            detail.setSourceId(row.getRelateDocDid());
            // 明细来源编号=收发货单号
            detail.setSourceNo(row.getRelateDocNo());
            // 发货时间
            detail.setSourceTime(row.getRelateDocTime());
            // 来源行号
            detail.setSourceLine(row.getLineNo());
            // 来源单据行ID
            detail.setSourceLineId(row.getId());
            // 发票行性质（传空字符串即可，为默认通用单）
            detail.setInvNature("默认通用单");
            // 商品信息
            detail.setItemCode(row.getItemCode());
            detail.setItemName(row.getItemName());
            // 税收分类编码
            detail.setTaxCode(row.getTaxType());
            // 应税货物或劳务、服务名称
            detail.setTaxName(row.getServiceName());
            detail.setItemType(row.getItemSpec());
            // 单位
            detail.setUom(row.getUom());
            detail.setUomName(row.getUomName());
            // 数量
            detail.setQty(row.getQty());
            // 含税单价
            detail.setPrice(row.getOriginAmt());
            // 含税金额
            detail.setTotalAmt(row.getAmt());
            // 税率
            detail.setTaxRate(row.getTaxRate());
            // 不含税金额 = 含税/(税率 + 1)
            detail.setExclTaxAmt(row.getNetAmt());
            // 税额 = 含税 - 未税
            detail.setTaxAmt(row.getTax());
            detail.setSourceNo(row.getRelateDocNo());
            detail.setDocNo(row.getRelateDocNo());
            detail.setCustId(row.getDtlCustId());
            detail.setCustName(row.getDtlCustName());
            detail.setCustCode(row.getDtlCustCode());

            detail.setRootDocId(row.getRootDocId());
            detail.setRootDocNo(row.getRootDocNo());
            detail.setRootDocTime(row.getRootDocTime());
            detail.setRootDocDId(row.getRootDocDId());

            details.add(detail);
        }
        return details;
    }

    // 设置主客户信息
    private void setCustInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {
        saveParam.setCustId(record.getCustId());
        saveParam.setCustCode(record.getCustCode());
        saveParam.setCustName(record.getCustName());
        ApplyInvoiceParam param = new ApplyInvoiceParam();
        param.setCustCode(record.getMainCustCode());
        List<InvoiceCustVO> custVOS = invQuery(List.of(param));
        if (CollectionUtil.isNotEmpty(custVOS)) {
            InvoiceCustVO invoiceCustVO = custVOS.get(0);
            saveParam.setCustInvTitle(invoiceCustVO.getInvTitle());
            saveParam.setCustTaxNo(invoiceCustVO.getTaxNo());
            saveParam.setCustAdd(invoiceCustVO.getInvAddress());
            saveParam.setCustTel(invoiceCustVO.getInvTel());
            saveParam.setCustBankAcc(invoiceCustVO.getInvBankAcc());
            saveParam.setCustBank(invoiceCustVO.getInvBankName());
            saveParam.setCustName(invoiceCustVO.getCustName());
        }
    }

    // 设置销售公司信息
    private void setSaleCompanyInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {

        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(List.of(record.getOuId()));
        orgOuRpcDtoParam.setOuCodes(List.of(record.getOuCode()));
        List<OrgOuRpcDTO> ouRpcDTOS = orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Assert.notEmpty(ouRpcDTOS, "销售公司信息为空,公司编码:{}", record.getOuCode());
        OrgOuRpcDTO ouRpcDTO = ouRpcDTOS.get(0);
        saveParam.setAutoReview(record.getAutoReview());
        saveParam.setOuId(record.getOuId());
        saveParam.setOuCode(record.getOuCode());
        saveParam.setOuName(record.getOuName());
        saveParam.setSourceSysNo(record.getOptDocNo());
        saveParam.setMainCustCode(record.getMainCustCode());
        saveParam.setMainCustId(record.getMainCustId());
        saveParam.setMainCustName(record.getMainCustName());
        // 销售公司发票抬头信息 - 税号
        saveParam.setSaleTaxNo(ouRpcDTO.getTaxRegNo());
        // 销售公司 - 开票抬头
        saveParam.setSaleInvTitle(ouRpcDTO.getInvTitle());
        // 销售公司 - 开票地址
        saveParam.setSaleAdd(ouRpcDTO.getInvAddress());
        // 销售公司 - 开户银行
        saveParam.setSaleBank(ouRpcDTO.getInvBankName());
        // 销售公司 - 银行账号
        saveParam.setSaleBankAcc(ouRpcDTO.getInvBankAcc());
        // 销售公司 - 电话
        saveParam.setSaleTel(ouRpcDTO.getInvPicPhone());

        // 币种
        saveParam.setCurrCode(ouRpcDTO.getOuCurr());
        SysCurrencyRespDTO currByCode = systemRpcService.findCurrByCode(ouRpcDTO.getOuCurr());
        saveParam.setCurrName(currByCode.getCurrName());
        saveParam.setLocalCurrCode(ouRpcDTO.getOuCurr());
        saveParam.setLocalCurrName(currByCode.getCurrName());
    }

    public InvoiceApplyDTO saveAndSubmitInvoice(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        // 开票状态 UDC[yst-supp:APPLY_STATUS]
        if (ObjUtil.notEqual(param.getAutoReview(), Boolean.FALSE)) {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        // 业务字段校验
        saleInv.check();
        saleInv.checkDtl();
        log.info("[YST-FIN] saleInv: {}", saleInv);
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        SaleInvDO execute = transactionTemplate.execute(transactionStatus -> {
            try{
                // 保存表头
                SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
                log.info("[YST-FIN] convertDO: {}", convertDO);
                flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.SALE_INV, convertDO);
                SaleInvDO save = saleInvRepo.save(convertDO);
                // 保存明细
                saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
                List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
                List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
                log.info("[YST-FIN] convert details: {}", details);
                details.forEach(row -> {
                    row.setMasId(save.getId());
                    saleInvDtlRepo.save(row);
                });
                return save;
            } catch(Exception e){
                log.error("待开发票生成销售发票出错:{}", e);
                //回滚
                transactionStatus.setRollbackOnly();
                //throw e;//抛出异常，不往下执行
                throw new BusinessException(ApiCode.FAIL, "待开发票生成销售发票保存时出错");
            }
        });
        Set<Long> awaitId = param.getDetails().stream().map(item -> item.getInvoiceAwaitId()).filter(Objects::nonNull).collect(Collectors.toSet());

        // 不是自动审批的就走审批流
        if (ObjUtil.equals(param.getAutoReview(), Boolean.FALSE)) {
            workFlow(execute);
        } else {
            // 开票设置 设置的审批通过 同步NC
            sendMessage(execute);
        }

        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(execute.getId());
        result.setApplyNo(execute.getApplyNo());
        result.setInvoiceAwaitIds(awaitId);

        return result;
    }

    private void sendMessage(SaleInvDO saleInvDO) {
        // 发送消息给WMS
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDO.getId());
        messageDTO.setCode(saleInvDO.getApplyNo());
        messageDTO.setInterfaceType(FinConstant.ZT_TO_NC_SALINV);
        messageDTO.setDomainCode(FinConstant.FIN);
        try {
            messageQueueTemplate.publishMessage(Application.NAME, "yst-fin", messageDTO);
        } catch (Exception e) {
            log.error("发送mq消息，同步销售开票信息到NC失败,同步内容{}, 失败原因：{}", messageDTO, e.getMessage());
            throw new BusinessException("同步销售开票信息到NC失败");
        }

    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        // 开启工作流
        /************************************************************************
         *                              工作流开始                                *
         ************************************************************************/

        if (saleInvDO.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            /**
             * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
             * 工作流规则:
             *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
             *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
             */
            String procInstName = "开票申请(" + applyNo + ")审批";
            String businessKey = saleInvDO.getId() + "";
            ProcessInfo processInfo = workflowRpcService.startProcess(
                    WorkFlowDefKey.FIN_SALE_INV.name(),
                    procInstName,
                    businessKey,
                    new HashMap<>());
            // 修改业务审批数据
            saleInvDomainService.updateWorkInfo(processInfo,saleInvDO.getId());
            log.info("待开发票申请走工作流,申请销售发票单号 {}, 工作流返回 {}",applyNo,processInfo);
            /************************************************************************
             *                              工作流结束                                *
             ************************************************************************/
        }
    }

    @Override
    public List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam) {
        Assert.notEmpty(applyInvoiceParam, "客户编码为空!");
        List<String> collect = applyInvoiceParam.stream().map(param -> param.getCustCode()).collect(Collectors.toList());
        List<LmSaveCustRespVO> invCust = rmiSaleRpcService.findInvCust(collect);
        return InvoiceAwaitConvert.INSTANCE.custVos2Dtos(invCust);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<InvoiceAwaitDTO> invoiceAwaitOrder(String param) {
        // 根据开票设置，如果配置了销售对账单生成代开开票，则查询对账单并生成代开发票单据
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocCls(UdcEnum.DOC_CLS_SACCK.getValueCode());
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if(CollectionUtil.isEmpty(ruleConfigDTOList)){
            log.info("未配置开票设置，无需生成代开发票");
            XxlJobLogger.log("未配置开票设置，无需生成代开发票");
            return null;
        }

        // 1.获取付款单
        SalReconciliatQueryDTO dto = buildSaleRecParam(param);
        List<SaleReconciliatDTO> saleReconciliatDTOS;
        try {
            log.info("查询对账单参数：{}", dto);
            saleReconciliatDTOS = rmiOrderRpcService.querySalReconciliat(dto);
            log.info("对账单查询到的数据结果：{} ", JSONUtil.toJsonStr(saleReconciliatDTOS));
        } catch (Exception e) {
            log.error("调用对账单接口出错,请求参数:{}, 报错信息：{}  ", dto, e.getMessage());
            return null;
        }

        if (CollectionUtil.isEmpty(saleReconciliatDTOS)) {
            return null;
        }
        // 过滤没有明细的数据
        List<SaleReconciliatDTO> collect = saleReconciliatDTOS.stream().filter(item -> CollectionUtil.isNotEmpty(item.getSaleReconciliatDtlDTOList())).collect(Collectors.toList());

        // 数据转换
        List<InvoiceAwaitDTO> dtos = buildSalRecToInvoiceAwaitOrder(collect);

        List<Long> list = new ArrayList<>();

        // 保存数据
        log.info("保存待开票申请：{}", JSONUtil.toJsonStr(dtos));

        List<InvoiceAwaitDO> invoiceAwaitDOList = new ArrayList<>();
        dtos.forEach(item -> {
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
            InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do(item);
            awaitDO.setDocNo(docNo);
            flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.INVOICE_AWAIT, awaitDO);
            InvoiceAwaitDO save = invoiceAwaitRepo.save(awaitDO);
            List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
            dtlList.forEach(dtl -> {
                InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do(dtl);
                dtlDo.setMasId(save.getId());
                invoiceAwaitDRepo.save(dtlDo);
                list.add(dtl.getOptDocDtlId());
            });
            invoiceAwaitDOList.add(save);
        });

        // 更新对账单明细表传输状态
        updateTransState(list);

        // 事务提交后保存开票申请
        TransactionSynchronizationManager.registerSynchronization(
                new TransactionSynchronization() {
                    @Override
                    public void afterCommit() {
                        // 生成开票申请单
                        invoiceAwaitDOList.forEach(save -> {
                            InvoiceApplyParam applyParam = new InvoiceApplyParam();
                            applyParam.setCustInvTitle(save.getInvTitle());
                            applyParam.setCustTaxNo(save.getTaxerNo());
                            applyParam.setInvType(save.getInvType());
                            applyParam.setCustBank(save.getInvBankName());
                            applyParam.setCustBankAcc(save.getInvBankAcc());
                            applyParam.setCustTel(save.getInvTel());
                            applyParam.setCustAdd(save.getInvAddress());
                            applyParam.setInvTitleType(save.getInvTitleType());
                            applyParam.setInvPicName(save.getInvPicName());
                            applyParam.setInvPicPhone(save.getInvPicPhone());
                            applyParam.setInvEmail(save.getInvEmail());

                            applyParam.setIds(List.of(save.getId()));
                            log.info("生成待开票申请：{}", JSONUtil.toJsonStr(applyParam));
                            abstractInvoiceSaveService.save(applyParam);
                        });
                    }
                }
        );



        return dtos;
    }

    private void updateTransState(List<Long> list) {
        List<Long> collect = list.stream().filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            SalReconciliatQueryDTO updateDto = new SalReconciliatQueryDTO();
            updateDto.setDtlIds(list);
            try {
                rmiOrderRpcService.updateTransState(updateDto);
            } catch (Exception e) {
                log.error("更新对账单明细传输状态失败，参数: {}，失败信息: {}，", updateDto, e.getMessage());
            }
        }
    }

    // 对账单生成待开发票列表
    private List<InvoiceAwaitDTO> buildSalRecToInvoiceAwaitOrder(List<SaleReconciliatDTO> saleReconciliatDTOS) {

        List<InvoiceAwaitDTO> invoiceAwaitDTOS = new ArrayList<>();
        saleReconciliatDTOS.stream().forEach(saleRec -> {
            if (!invoiceAwaitRepo.existsByOptDocId(saleRec.getId())) {
                InvoiceAwaitDTO invoiceAwaitDTO = InvoiceAwaitConvert.INSTANCE.sale2AwaitDto(saleRec);

                // 设置明细
                List<InvoiceAwaitDDTO> dtlList = buildSalRecDtl2InvoiceAwaitDtl(saleRec.getSaleReconciliatDtlDTOList());
                invoiceAwaitDTO.setInvoiceAwaitDDTOList(dtlList);
                BigDecimal totalInvAmt = dtlList.stream().filter(item -> ObjectUtil.isNotNull(item.getInvAmt())).map(item -> item.getInvAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoiceAwaitDTO.setAmt(totalInvAmt);
                invoiceAwaitDTO.setId(null);
                invoiceAwaitDTO.setOptDocId(saleRec.getId());
                invoiceAwaitDTO.setOptDocNo(saleRec.getDocNo());
                invoiceAwaitDTO.setOptDocCls(UdcEnum.DOC_CLS_SACCK.getValueCode());
                invoiceAwaitDTO.setOptDocType(UdcEnum.DOC_TYPE_SACCK.getValueCode());
                invoiceAwaitDTO.setOptDocStatus(UdcEnum.DOC_STATUS_SACCK_CONFIRM.getValueCode());
                invoiceAwaitDTO.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode());
                invoiceAwaitDTO.setCustCode(dtlList.get(0).getCustCode());
                invoiceAwaitDTO.setCustId(dtlList.get(0).getCustId());
                invoiceAwaitDTO.setCustName(dtlList.get(0).getCustName());
                invoiceAwaitDTO.setRecApplyTime(saleRec.getCreateTime());
                invoiceAwaitDTOS.add(invoiceAwaitDTO);
            }
        });

        return invoiceAwaitDTOS;
    }

    private List<InvoiceAwaitDDTO> buildSalRecDtl2InvoiceAwaitDtl(List<SaleReconciliatDtlDTO> saleRecList) {
        List<InvoiceAwaitDDTO> ddtos = new ArrayList<>();
        saleRecList.stream().forEach(dtl -> {
            InvoiceAwaitDDTO invoiceAwaitDDTO = InvoiceAwaitDConvert.INSTANCE.sale2awaitDo(dtl);
            invoiceAwaitDDTO.setId(null);
            invoiceAwaitDDTO.setMasId(null);

            if (dtl.getLineNo() != null) {
                invoiceAwaitDDTO.setLineNo(new BigDecimal(dtl.getLineNo()));
            }
            invoiceAwaitDDTO.setTaxType(dtl.getTaxCategoryCode());
            invoiceAwaitDDTO.setQty(dtl.getSoaQty());
            invoiceAwaitDDTO.setDiscountAmt( dtl.getInvDiscountAmt());
            invoiceAwaitDDTO.setNetAmt(dtl.getSoaNetAmt());
            invoiceAwaitDDTO.setTax(dtl.getSoaTaxAmt());
            invoiceAwaitDDTO.setAmt(dtl.getSoaAmt());
            invoiceAwaitDDTO.setOriginAmt(dtl.getDiscountPrice());
            invoiceAwaitDDTO.setOptDocDtlId(dtl.getId());
            if (ObjectUtil.isNotNull(dtl.getMainPrice()) && !ObjUtil.equals(dtl.getMainPrice(), BigDecimal.ZERO)) {
                invoiceAwaitDDTO.setItemDiscount(NumberUtil.div(dtl.getDiscountPrice(), dtl.getMainPrice()));
            }
            ddtos.add(invoiceAwaitDDTO);
        });

        return ddtos;
    }

    private SalReconciliatQueryDTO buildSaleRecParam(String param) {
        SalReconciliatQueryDTO dto = new SalReconciliatQueryDTO();
        dto.setInvState(UdcEnum.INV_STATE_WAIT.getValueCode());
        dto.setState("CONFIRM");
        return dto;
    }


    /**
     *
     * @param param
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvedState(SaleInvStatusParam param) {

        List<InvoiceAwaitDTO> awaitDTOList = invoiceAwaitRepoProc.findByApplyNo(param.getApplyNo());

        List<Long> optDcoIdList = awaitDTOList.stream().map(InvoiceAwaitDTO::getOptDocId).distinct().collect(Collectors.toList());

        invoiceAwaitRepoProc.updateInvState(param);

        SaleReconciliatDTO dto = new SaleReconciliatDTO();
        dto.setIds(optDcoIdList);
        dto.setState(param.getInvState());
        log.info("更新对账单开票状态,传参: {}", dto);
        rmiOrderRpcService.updateInvedState(dto);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRedState(SaleInvStatusParam param) {
        if (StrUtil.equals(param.getInvState(), UdcEnum.RED_STATE_SUCCESS.getValueCode())) {
            param.setInvState(UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode());
        }
        updateInvedState(param);
    }


    /**
     * 根据来源单号批量逻辑删除
     *
     * @param optDocNos 来源单号
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagByOptDocNoBatch(List<String> optDocNos) {
        log.info("根据来源单号批量逻辑删除的入参：{}" + JSON.toJSONString(optDocNos));

        if (CollectionUtil.isNotEmpty(optDocNos)){
            List<Long> invoiceAwaitIds = invoiceAwaitRepoProc.selectInvoiceAwaitIdByOptDoc(optDocNos,Collections.EMPTY_LIST);
            if (CollectionUtil.isNotEmpty(invoiceAwaitIds)){
                invoiceAwaitRepoProc.updateDeleteFlagByIdBatch(1,invoiceAwaitIds);
                invoiceAwaitDRepoProc.updateDeleteFlagByMasIdBatch(1,invoiceAwaitIds);
            }

        }
    }

    /**
     * 根据来源单据主键id批量逻辑删除
     *
     * @param optDocIds 来源单据主键id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagByOptDocIdBatch(List<Long> optDocIds){
        log.info("根据来源单据主键id批量逻辑删除的入参：{}" + JSON.toJSONString(optDocIds));

        if (CollectionUtil.isNotEmpty(optDocIds)){
            List<Long> invoiceAwaitIds = invoiceAwaitRepoProc.selectInvoiceAwaitIdByOptDoc(Collections.EMPTY_LIST,optDocIds);
            if (CollectionUtil.isNotEmpty(invoiceAwaitIds)){
                invoiceAwaitRepoProc.updateDeleteFlagByIdBatch(1,invoiceAwaitIds);
                invoiceAwaitDRepoProc.updateDeleteFlagByMasIdBatch(1,invoiceAwaitIds);
            }
        }
    }

    /**
     * 销售发货单/销售退货收货单生成待开申请发票列表
     * @param param
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void invoiceAwaitOrderBySalDo(String param) {
        // 根据开票设置，如果配置了销售对账单生成代开开票，则查询销售发货单并生成代开发票单据
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocClss(Arrays.asList(UdcEnum.DOC_CLS_DO.getValueCode(),UdcEnum.DOC_CLS_RSO.getValueCode()));
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if(CollectionUtil.isEmpty(ruleConfigDTOList)){
            log.info("未配置开票设置，无需生成代开发票");
            XxlJobLogger.log("未配置开票设置，无需生成代开发票");
            return ;
        }

        List<String> optDocTypes = ruleConfigDTOList.stream().map(InvoiceRuleConfigDTO::getOptDocType).collect(Collectors.toList());

        // 查询根据发货单已经生成的代开发票数据
        List<InvoiceAwaitDO> invoiceAwaitDOList = invoiceAwaitRepo.getAllByOptDocTypeIn(optDocTypes);
        List<String> salDoDocNos = new ArrayList<>();
        if(CollUtil.isNotEmpty(invoiceAwaitDOList)){
            salDoDocNos = invoiceAwaitDOList.stream().map(InvoiceAwaitDO::getOptDocNo).collect(Collectors.toList());
        }

        try {
            List<String> docTypes = optDocTypes.stream().map(e -> {
                String docType = e.replace("DO_", "");
                docType = docType.replace("RSO_", "");
                return docType;
            }).collect(Collectors.toList());
            // 查询已经签收状态的发货单，并且未生成代开发票的单子
            SalDoQueryReqDTO salDoQueryReqDTO = new SalDoQueryReqDTO();
            salDoQueryReqDTO.setInDocStatus(Arrays.asList(UdcEnum.SAL_DO_DOC_STATUS.getValueCode()));
            // DO_SO类型将拉取所有的销售发货单类型。排除退货单类型
            if(optDocTypes.contains(UdcEnum.INVOICE_CONFIG_SACCK_SAL_DO.getValueCode())){
                salDoQueryReqDTO.setNotInDocType(Arrays.asList("RJ","RW"));
            }else{
                salDoQueryReqDTO.setInDocType(docTypes);
            }
            salDoQueryReqDTO.setNotInDocNoList(salDoDocNos);

            log.info("查询要生成的发货单入参，{}", JSONUtil.toJsonStr(salDoQueryReqDTO));
            ApiResult<List<SalDoQueryRespDTO>> listApiResult = salDoRpcService.querySalDoList(salDoQueryReqDTO);
            log.info("查询要生成的发货单结果，{}", JSONUtil.toJsonStr(listApiResult));
            if (listApiResult.isFailed() || CollUtil.isEmpty(listApiResult.getData())){
                log.info("为查询到已签收的发货单，无需生成代开发票");
                XxlJobLogger.log("为查询到已签收的发货单，无需生成代开发票");
                return ;
            }

            // 封装生成代开发票的参数
            List<InvoiceAwaitDTO> dtos = buildInvoiceAwaitParam(listApiResult.getData());
            log.info("封装生成代开发票的参数,{}",JSONUtil.toJsonStr(dtos));
            List<Long> list = new ArrayList<>();
            // 保存数据
            dtos.stream().forEach(item -> {
                String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
                InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do(item);
                awaitDO.setDocNo(docNo);
                flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.INVOICE_AWAIT, awaitDO);
                InvoiceAwaitDO save = invoiceAwaitRepo.save(awaitDO);
                List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
                dtlList.stream().forEach(dtl -> {
                    InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do(dtl);
                    dtlDo.setMasId(save.getId());
                    invoiceAwaitDRepo.save(dtlDo);
                    list.add(dtl.getOptDocDtlId());
                });

                // 生成开票申请单
                InvoiceApplyParam applyParam = new InvoiceApplyParam();
                applyParam.setCustInvTitle(save.getInvTitle());
                applyParam.setCustTaxNo(save.getTaxerNo());
                applyParam.setInvType(save.getInvType());
                applyParam.setCustBank(save.getInvBankName());
                applyParam.setCustBankAcc(save.getInvBankAcc());
                applyParam.setCustTel(save.getInvTel());
                applyParam.setCustAdd(save.getInvAddress());
                applyParam.setInvTitleType(save.getInvTitleType());
                applyParam.setInvPicName(save.getInvPicName());
                applyParam.setInvPicPhone(save.getInvPicPhone());
                applyParam.setInvEmail(save.getInvEmail());

                applyParam.setIds(List.of(save.getId()));

                log.info("生成开票申请单：{}", JSONUtil.toJsonStr(applyParam));
                invoiceApply(applyParam);
            });

        }catch (Exception e){
            log.error("查询发货单数据失败," + e.getMessage());
            XxlJobLogger.log(e.getMessage());
        }
    }

    /**
     * 封装生成代开发票的参数
     * @param list 发货单信息
     * @return
     */
    private List<InvoiceAwaitDTO> buildInvoiceAwaitParam(List<SalDoQueryRespDTO> list) {
        List<InvoiceAwaitDTO> result = new ArrayList<>();

        List<String> custCodes = list.stream().map(SalDoQueryRespDTO::getPreCustCode).distinct().collect(Collectors.toList());
        CrmCustRpcDtoParam custRpcDtoParam = new CrmCustRpcDtoParam();
        custRpcDtoParam.setCustCodes(custCodes);
        log.info("批量查询客户信息入参,{}",custCodes);
        ApiResult<List<CrmCustRespDTO>> custByParam = crmCustRpcService.getCustByParam(custRpcDtoParam);
        log.info("批量查询客户信息结果,{}",JSONUtil.toJsonStr(custByParam));
        if(custByParam.isFailed() || CollUtil.isEmpty(custByParam.getData())){
            throw new BusinessException("批量查询客户信息异常");
        }
        Map<String, CrmCustRespDTO> custInfoMap = custByParam.getData().stream().collect(Collectors.toMap(k -> k.getCustCode(), v -> v));

        List<Long> ouIds = list.stream().map(SalDoQueryRespDTO::getOuId).distinct().collect(Collectors.toList());
        OrgOuRpcDtoParam ouRpcDtoParam = new OrgOuRpcDtoParam();
        ouRpcDtoParam.setOuIds(ouIds);
        log.info("批量查询公司信息入参,{}",custCodes);
        List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(ouRpcDtoParam);
        log.info("批量查询公司信息结果,{}",JSONUtil.toJsonStr(ouDtoByParam));

        if(CollUtil.isEmpty(ouDtoByParam)){
            throw new BusinessException("批量查询公司信息异常");
        }
        Map<Long, OrgOuRpcDTO> ouRpcDTOMap = ouDtoByParam.stream().collect(Collectors.toMap(k -> k.getId(), v -> v));


        for (SalDoQueryRespDTO salDoQueryRespDTO : list) {
            InvoiceAwaitDTO invoiceAwaitDTO = InvoiceAwaitConvert.INSTANCE.salDo2AwaitDto(salDoQueryRespDTO);

            if(CollUtil.isNotEmpty(salDoQueryRespDTO.getSalDoDQueryRespDTOList())){
                List<InvoiceAwaitDDTO> dtlList = buildInvoiceAwaitDParam(salDoQueryRespDTO);
                invoiceAwaitDTO.setInvoiceAwaitDDTOList(dtlList);
                // 设置明细
                BigDecimal totalInvAmt = dtlList.stream().filter(item -> ObjectUtil.isNotNull(item.getInvAmt())).map(item -> item.getInvAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoiceAwaitDTO.setAmt(totalInvAmt);
                invoiceAwaitDTO.setId(null);
                invoiceAwaitDTO.setOptDocId(salDoQueryRespDTO.getId());
                invoiceAwaitDTO.setOptDocNo(salDoQueryRespDTO.getDocNo());
                invoiceAwaitDTO.setOptDocCls(salDoQueryRespDTO.getDocNo().startsWith("RDO")?UdcEnum.DOC_CLS_RDO.getValueCode():UdcEnum.DOC_CLS_DO.getValueCode());
                invoiceAwaitDTO.setOptDocType(salDoQueryRespDTO.getRelateDocType().equals("RW")?UdcEnum.INVOICE_CONFIG_SACCK_SAL_RDO_RW.getValueCode():(salDoQueryRespDTO.getRelateDocType().equals("RJ")?UdcEnum.INVOICE_CONFIG_SACCK_SAL_RDO_RJ.getValueCode():UdcEnum.INVOICE_CONFIG_SACCK_SAL_DO.getValueCode()));
                invoiceAwaitDTO.setOptDocStatus(UdcEnum.SAL_DO_DOC_STATUS.getValueCode());
                invoiceAwaitDTO.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode());
                invoiceAwaitDTO.setMainCustCode(salDoQueryRespDTO.getPreCustCode());
                invoiceAwaitDTO.setMainCustId(custInfoMap.containsKey(salDoQueryRespDTO.getPreCustCode())?custInfoMap.get(salDoQueryRespDTO.getPreCustCode()).getId():0L);
                invoiceAwaitDTO.setMainCustName(salDoQueryRespDTO.getPreCustName());
                invoiceAwaitDTO.setCurrRate(BigDecimal.ONE);
                invoiceAwaitDTO.setCurrCode("CNY");
                invoiceAwaitDTO.setOuCode(ouRpcDTOMap.containsKey(salDoQueryRespDTO.getOuId())?ouRpcDTOMap.get(salDoQueryRespDTO.getOuId()).getOuCode():"");
                invoiceAwaitDTO.setOuName(ouRpcDTOMap.containsKey(salDoQueryRespDTO.getOuId())?ouRpcDTOMap.get(salDoQueryRespDTO.getOuId()).getOuName():"");
                result.add(invoiceAwaitDTO);
            }
        }
        return result;
    }

    /**
     * 封装生成代开发票明细的参数
     * @param salDoQueryRespDTO 发货单数据
     * @return
     */
    private List<InvoiceAwaitDDTO> buildInvoiceAwaitDParam(SalDoQueryRespDTO salDoQueryRespDTO) {
        List<SalDoDQueryRespDTO> list = salDoQueryRespDTO.getSalDoDQueryRespDTOList();
        List<InvoiceAwaitDDTO> ddtos = new ArrayList<>();
        list.stream().forEach(dtl -> {
            InvoiceAwaitDDTO invoiceAwaitDDTO = InvoiceAwaitDConvert.INSTANCE.salDod2awaitDo(dtl);
            invoiceAwaitDDTO.setId(null);
            invoiceAwaitDDTO.setMasId(null);
            invoiceAwaitDDTO.setCustId(salDoQueryRespDTO.getCustId());
            invoiceAwaitDDTO.setCustCode(salDoQueryRespDTO.getCustCode());
            invoiceAwaitDDTO.setCustName(salDoQueryRespDTO.getCustName());
            invoiceAwaitDDTO.setShipTime(salDoQueryRespDTO.getDocTime());
            invoiceAwaitDDTO.setConfirmTime(salDoQueryRespDTO.getConfirmTime());
            invoiceAwaitDDTO.setSoDate(salDoQueryRespDTO.getSoTime());
            invoiceAwaitDDTO.setDiscountAmt( dtl.getFlDeductionAmt());
            invoiceAwaitDDTO.setTax(dtl.getTaxAmt());
            invoiceAwaitDDTO.setGiftsFlag(BigDecimal.ZERO.compareTo(dtl.getPrice()) == 0?"是":"否");
            invoiceAwaitDDTO.setOriginAmt(dtl.getPrice());
            invoiceAwaitDDTO.setMainPrice(dtl.getBasePrice());
            invoiceAwaitDDTO.setOptDocDtlId(dtl.getId());
            invoiceAwaitDDTO.setInvDiscountAmt(dtl.getFlDeductionAmt());
            invoiceAwaitDDTO.setInvAmt(dtl.getAmt().subtract(dtl.getFlDeductionAmt()));
            invoiceAwaitDDTO.setInvNetAmt(invoiceAwaitDDTO.getInvAmt().divide(BigDecimal.ONE.add(dtl.getTaxRate()),4, RoundingMode.HALF_UP));
            invoiceAwaitDDTO.setInvTaxAmt(invoiceAwaitDDTO.getInvAmt().subtract(invoiceAwaitDDTO.getInvNetAmt()));

            ddtos.add(invoiceAwaitDDTO);
        });

        return ddtos;
    }

}
