package com.elitesland.fin.infr.repo.apverrec;

import com.elitesland.fin.domain.entity.apverrec.QApVerRecDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;

/**
 * @author zhiyu.he
 * @date 2022/4/25 11:35
 */
@Component
@RequiredArgsConstructor
public class ApVerRecRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QApVerRecDO qApVerRecDO = QApVerRecDO.apVerRecDO;

    public Long logicDelByIds(Collection<Long> ids, String username, Long userId){
        return jpaQueryFactory.update(qApVerRecDO).set(qApVerRecDO.deleteFlag,1)
                .set(qApVerRecDO.cancelDate, LocalDateTime.now())
                .set(qApVerRecDO.cancelUser,username)
                .set(qApVerRecDO.cancelUserId,userId)
                .where(qApVerRecDO.id.in(ids).and(qApVerRecDO.deleteFlag.eq(0))).execute();
    }

}
