package com.elitesland.fin.infr.repo.paymentperiod;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeOuDO;
import com.elitesland.fin.domain.entity.paymentperiod.QAgingRangeOuDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AgingRangeOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAgingRangeOuDO qAgingRangeOuDO = QAgingRangeOuDO.agingRangeOuDO;

    public PagingVO<AgingRangeOuDTO> page(AgingRangeOuPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangeOuDTO> query = select(AgingRangeOuDTO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qAgingRangeOuDO);
        return PagingVO.<AgingRangeOuDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public List<AgingRangeOuVO> selectListByParam(AgingRangeOuPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AgingRangeOuVO> query = select(AgingRangeOuVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }


    private List<Predicate> where(AgingRangeOuPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();


        if (Objects.nonNull(pageParam.getOuId())){
            predicates.add(qAgingRangeOuDO.ouId.eq(pageParam.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getOuIdList())) {
            predicates.add(qAgingRangeOuDO.ouId.in(pageParam.getOuIdList()));
        }
        if (!StringUtils.isEmpty(pageParam.getOuCode())) {
            predicates.add(qAgingRangeOuDO.ouCode.eq(pageParam.getOuCode()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getOuCodeList())) {
            predicates.add(qAgingRangeOuDO.ouCode.in(pageParam.getOuCodeList()));
        }
        if (!StringUtils.isEmpty(pageParam.getOuName())) {
            predicates.add(qAgingRangeOuDO.ouName.eq(pageParam.getOuName()));
        }
        if (!StringUtils.isEmpty(pageParam.getOuType())) {
            predicates.add(qAgingRangeOuDO.ouType.eq(pageParam.getOuType()));
        }
        if (!StringUtils.isEmpty(pageParam.getOuKeyword())) {
            predicates.add(qAgingRangeOuDO.ouCode.like("%" + pageParam.getOuKeyword() + "%").or(qAgingRangeOuDO.ouName.like("%" + pageParam.getOuKeyword() + "%")));
        }

        if (Objects.nonNull(pageParam.getId())){
            predicates.add(qAgingRangeOuDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qAgingRangeOuDO.id.in(pageParam.getIdList()));
        }
        if (Objects.nonNull(pageParam.getMasId())){
            predicates.add(qAgingRangeOuDO.masId.eq(pageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIdList())) {
            predicates.add(qAgingRangeOuDO.masId.in(pageParam.getMasIdList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAgingRangeOuDO.id,
                qAgingRangeOuDO.masId,
                qAgingRangeOuDO.ouId,
                qAgingRangeOuDO.ouName,
                qAgingRangeOuDO.ouCode,
                qAgingRangeOuDO.ouType,
                qAgingRangeOuDO.remark,
                qAgingRangeOuDO.createTime,
                qAgingRangeOuDO.createUserId,
                qAgingRangeOuDO.creator,
                qAgingRangeOuDO.modifyTime,
                qAgingRangeOuDO.modifyUserId,
                qAgingRangeOuDO.updater,
                qAgingRangeOuDO.deleteFlag
        )).from(qAgingRangeOuDO);
    }

    public void updateDeleteFlagBatchByMasId(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qAgingRangeOuDO)
                .set(qAgingRangeOuDO.deleteFlag, deleteFlag)
                .where(qAgingRangeOuDO.masId.in(masIds))
                .execute();
    }

    public Long updateDeleteFlagBatchById(Integer deleteFlag, List<Long> ids) {
        long execute = jpaQueryFactory.update(qAgingRangeOuDO)
                .set(qAgingRangeOuDO.deleteFlag, deleteFlag)
                .where(qAgingRangeOuDO.id.in(ids))
                .execute();
        return execute;
    }

    public Boolean existByApTypeIdOuId(AgingRangeOuDO agingRangeOuDO) {
        long res = jpaQueryFactory.select(qAgingRangeOuDO.id)
                .from(qAgingRangeOuDO)
                .where(qAgingRangeOuDO.deleteFlag.eq(0))
                .where(qAgingRangeOuDO.masId.eq(agingRangeOuDO.getMasId()))
                .where(qAgingRangeOuDO.ouId.eq(agingRangeOuDO.getOuId()))
                .fetchCount();
        return res > 0;

    }

}
