package com.elitesland.fin.application.facade.vo.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-05 22:20
 */
@Data
public class ArOrderExVo extends ArOrderVO implements Serializable {

    @ApiModelProperty("订单客户")
    @Column(name = "order_customer", columnDefinition = "varchar(32)  comment '订单客户'")
    private String orderCustomer;

    @ApiModelProperty("应收单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '应收单主表关联id'")
    private Long relateId;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("开票日期")
    @Column(name = "inv_date", columnDefinition = "datetime(6)  comment '开票日期'")
    private LocalDateTime invDate;

    @ApiModelProperty(value = "发票类型")
    @SysCode(sys = "yst-oldcityfood-interact", mod = "IVN_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("起算日期")
    @Column(name = "start_date", columnDefinition = "datetime(6)  comment '起算日期'")
    private LocalDateTime startDate;

    @ApiModelProperty("红冲标志")
    @Column(name = "red_flush_sign", columnDefinition = "tinyint(1)  comment '红冲标志'")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    @Column(name = "third_payment_assistance", columnDefinition = "varchar(32)  comment '第三方支付辅助'")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    @Column(name = "consumer_card_ssistance", columnDefinition = "varchar(32)  comment '消费卡辅助'")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    @Column(name = "credit_card_assistance", columnDefinition = "varchar(32)  comment '信用卡辅助'")
    private String creditCardAssistance;

    @ApiModelProperty("应收明细扩展数据")
    private List<ArOrderDtlExVo> items;

    @ApiModelProperty(value = "第三方应收单号")
    private String sourceNo;

    @ApiModelProperty(value = "审批状态")
    private String approveState;

    @ApiModelProperty("客户名称")
    private String customName;

    @ApiModelProperty("申请核销中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("业务员名称")
    private String businessName;

    @ApiModelProperty("扩展表ID")
    private Long extId;
}
