/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.fin.application.facade.dto.mq.InvoiceOpeningProcessMqMessageDTO;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceOpeningProcessListener
implements MessageQueueListener<InvoiceOpeningProcessMqMessageDTO> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceOpeningProcessListener.class);
    private final RedLockUtils redLockUtils;
    private final InvoiceService invoiceService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"invoice_opening_process"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(@NotBlank String s, @NotNull InvoiceOpeningProcessMqMessageDTO messageDTO) {
        log.info("\u5f00\u7968\u4e2d\u53d1\u7968\u5904\u7406\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        RedissonRedLock redLock = null;
        try {
            redLock = this.redLockUtils.getRedLock("invoice_opening_process" + messageDTO.getBusinessKey());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u53d1\u7968\u5df2\u5728\u5904\u7406\u4e2d,\u83b7\u53d6\u9501\u5931\u8d25");
                return;
            }
            final Long id = messageDTO.getId();
            Optional byId = this.saleInvdDtlRepo.findById(id);
            if (byId.isEmpty()) {
                log.error("\u672a\u627e\u5230\u5f00\u7968\u4e2d\u53d1\u7968");
                return;
            }
            SaleInvdDtlDO saleInvdDtlDO = (SaleInvdDtlDO)byId.get();
            if (!saleInvdDtlDO.getInvState().equals(UdcEnum.INV_STATE_ING.getValueCode())) {
                log.error("\u53d1\u7968\u4e0d\u5904\u4e8e\u5f00\u7968\u4e2d\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            this.invoiceService.rePush((List<Long>)new ArrayList<Long>(){
                {
                    this.add(id);
                }
            });
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38,\u53d1\u7968\u6d41\u6c34\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u5f00\u7968\u4e2d\u53d1\u7968\u786e\u8ba4\u5b8c\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
    }

    public InvoiceOpeningProcessListener(RedLockUtils redLockUtils, InvoiceService invoiceService, SaleInvdDtlRepo saleInvdDtlRepo) {
        this.redLockUtils = redLockUtils;
        this.invoiceService = invoiceService;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
    }
}

