/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.artype;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.fin.domain.entity.artype.ArType;
import com.elitesland.fin.domain.entity.artype.ArTypeDO;
import com.elitesland.fin.domain.entity.artype.ArTypeDtl;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDtlDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import com.elitesland.fin.infr.repo.artype.ArTypeOuRepoProc;
import com.elitesland.fin.infr.repo.artype.ArTypeRepo;
import com.elitesland.fin.infr.repo.artype.ArTypeRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArTypeDomainServiceImpl
implements ArTypeDomainService {
    private final ArTypeRepo arTypeRepo;
    private final ArTypeRepoProc arTypeRepoProc;
    private final ArTypeOuRepoProc arTypeOuRepoProc;
    private final ArTypeDtlDomainService arTypeDtlDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArType arType) {
        arType.checkNotNull();
        arType.setDefaultValue();
        this.checkArType(arType);
        Boolean isExistName = this.arTypeRepoProc.existsName(arType.getArTypeName());
        if (isExistName.booleanValue()) {
            throw new BusinessException("\u5e94\u6536\u5355\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Boolean isExistCode = this.arTypeRepoProc.existsCode(arType.getArTypeCode());
        if (isExistCode.booleanValue()) {
            throw new BusinessException("\u5e94\u6536\u5355\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Boolean isFir = this.arTypeRepoProc.isFir();
        if (isFir.booleanValue()) {
            arType.setDefaultFlag(true);
        }
        ArTypeDO res = (ArTypeDO)this.arTypeRepo.save(ArTypeConvert.INSTANCE.convert(arType));
        Long masId = res.getId();
        if (Objects.nonNull(arType.getId())) {
            this.arTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(arType.getId()));
        }
        if (CollectionUtil.isNotEmpty(arType.getDtlList())) {
            List<ArTypeDtl> arTypeDtlList = arType.getDtlList();
            arTypeDtlList.forEach(arTypeDtl -> arTypeDtl.setMasId(masId));
            this.arTypeDtlDomainService.save(arTypeDtlList);
        }
        return masId;
    }

    private void checkArType(ArType arType) {
        List<ArTypeDtl> dtlList = arType.getDtlList();
        if (CollectionUtil.isEmpty(dtlList)) {
            return;
        }
        List<String> sourceDocList = dtlList.stream().map(ArTypeDtl::getSourceDoc).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> sourceDocTypeList = dtlList.stream().map(ArTypeDtl::getSourceDocType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> sourceDocStatusList = dtlList.stream().map(ArTypeDtl::getSourceDocStatus).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArTypeDtlPageParam arTypeDtlPageParam = new ArTypeDtlPageParam();
        arTypeDtlPageParam.setSourceDocList(sourceDocList);
        arTypeDtlPageParam.setSourceDocTypeList(sourceDocTypeList);
        arTypeDtlPageParam.setSourceDocStatusList(sourceDocStatusList);
        List<ArTypeDtlDTO> arTypeDtlDTOList = this.arTypeDtlDomainService.selectListByParam(arTypeDtlPageParam);
        if (CollectionUtil.isEmpty(arTypeDtlDTOList)) {
            return;
        }
        Map<String, List<ArTypeDtlDTO>> arTypeDtlListMap = arTypeDtlDTOList.stream().collect(Collectors.groupingBy(i -> this.arSpliceGroupKey(i.getSourceDoc(), i.getSourceDocType(), i.getSourceDocStatus())));
        List<Long> masIdList = arTypeDtlDTOList.stream().map(ArTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArTypeDTO> arTypeDTOList = this.arTypeRepoProc.findByIds(masIdList);
        dtlList.forEach(arTypeDtl -> {
            String spliceGroupKey = this.arSpliceGroupKey(arTypeDtl.getSourceDoc(), arTypeDtl.getSourceDocType(), arTypeDtl.getSourceDocStatus());
            List spliceGroupList = (List)arTypeDtlListMap.get(spliceGroupKey);
            if (CollectionUtil.isNotEmpty((Collection)spliceGroupList)) {
                List spliceGroupMasIdList = spliceGroupList.stream().map(ArTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Optional<ArTypeDTO> arTypeDTOOptional = arTypeDTOList.stream().filter(arTypeDTO -> spliceGroupMasIdList.contains(arTypeDTO.getId()) && !Objects.equals(arTypeDTO.getId(), arType.getId())).findFirst();
                if (arTypeDTOOptional.isPresent()) {
                    throw new BusinessException("\u6765\u6e90\u5355\u636e(" + arTypeDtl.getSourceDoc() + ")-\u6765\u6e90\u5355\u636e\u7c7b\u578b(" + arTypeDtl.getSourceDocType() + ")-\u6765\u6e90\u5355\u636e\u72b6\u6001(" + arTypeDtl.getSourceDocStatus() + ")\u4e0e\u5e94\u6536\u5355\u7c7b\u578b\u914d\u7f6e(" + arTypeDTOOptional.get().getArTypeCode() + ")\u91cd\u590d");
                }
            }
        });
    }

    private String arSpliceGroupKey(String sourceDoc, String sourceDocType, String sourceDocStatus) {
        String spliceGroupKey = sourceDoc + "-" + sourceDocType + "-" + sourceDocStatus;
        return spliceGroupKey;
    }

    @Override
    @SysCodeProc
    public ArTypeDTO get(Long id) {
        ArTypeDTO res = this.arTypeRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArTypeDTO> page(ArTypePageParam arTypePageParam) {
        List<Long> artypeIds = new ArrayList<Long>();
        if (null != arTypePageParam.getOuId()) {
            artypeIds = this.arTypeOuRepoProc.queryByOuId(arTypePageParam.getOuId());
        }
        PagingVO<ArTypeDTO> res = this.arTypeRepoProc.page(arTypePageParam, artypeIds);
        return res;
    }

    @Override
    @SysCodeProc
    public List<ArTypeDTO> findByIds(List<Long> ids) {
        List<ArTypeDTO> res = this.arTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateEnableFlag(List<Long> ids, boolean enable) {
        this.arTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDef(Long id) {
        this.arTypeRepoProc.updateDef();
        Long res = this.arTypeRepoProc.updateDefById(id);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArTypeDTO arTypeDTO = this.arTypeRepoProc.findById(id);
        if (arTypeDTO.getEnableFlag().booleanValue() || arTypeDTO.getDefaultFlag().booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e\u548c\u975e\u9ed8\u8ba4\u7684\u6570\u636e");
        }
        Long res = this.arTypeRepoProc.del(id);
        return res;
    }

    @Override
    @SysCodeProc
    public List<ArTypeDTO> getList() {
        List<ArTypeDTO> res = this.arTypeRepoProc.getList();
        return res;
    }

    @Override
    @SysCodeProc
    public ArTypeDTO getDef() {
        ArTypeDTO res = this.arTypeRepoProc.getDef();
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ArType arType) {
        arType.checkNotNull();
        this.checkArType(arType);
        Assert.notNull((Object)arType.getDefaultFlag(), (String)"defaultFlag is null", (Object[])new Object[0]);
        Assert.notNull((Object)arType.getAutoAudit(), (String)"autoAudit is null", (Object[])new Object[0]);
        Assert.notNull((Object)arType.getEnableFlag(), (String)"enableFlag is null", (Object[])new Object[0]);
        ArTypeDO res = (ArTypeDO)this.arTypeRepo.save(ArTypeConvert.INSTANCE.convert(arType));
        Long masId = res.getId();
        if (Objects.nonNull(arType.getId())) {
            this.arTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(arType.getId()));
        }
        if (CollectionUtil.isNotEmpty(arType.getDtlList())) {
            List<ArTypeDtl> arTypeDtlList = arType.getDtlList();
            arTypeDtlList.forEach(arTypeDtl -> arTypeDtl.setMasId(masId));
            this.arTypeDtlDomainService.save(arTypeDtlList);
        }
        return masId;
    }

    @Override
    public Boolean queryIsAuto(Long id) {
        return this.arTypeRepoProc.queryIsAutoAudit(id);
    }

    @Override
    @SysCodeProc
    public List<ArTypeDTO> arOrderAutoSelectMatchByParam(ArTypePageParam arTypePageParam) {
        return this.arTypeRepoProc.arOrderAutoSelectMatchByParam(arTypePageParam);
    }

    @Override
    @SysCodeProc
    public List<ArTypeDTO> selectMatchByParam(ArTypePageParam arTypePageParam) {
        return this.arTypeRepoProc.selectMatchByParam(arTypePageParam);
    }

    public ArTypeDomainServiceImpl(ArTypeRepo arTypeRepo, ArTypeRepoProc arTypeRepoProc, ArTypeOuRepoProc arTypeOuRepoProc, ArTypeDtlDomainService arTypeDtlDomainService) {
        this.arTypeRepo = arTypeRepo;
        this.arTypeRepoProc = arTypeRepoProc;
        this.arTypeOuRepoProc = arTypeOuRepoProc;
        this.arTypeDtlDomainService = arTypeDtlDomainService;
    }
}

