package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/6
 */
@Entity
@Table(name = "fin_payment_voucher")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_voucher", comment = "支付凭证表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "支付凭证表", description = "支付凭证表")
@Where(clause = "delete_flag = 0")
public class PaymentVoucherDO extends BaseModel implements Serializable {
    /**
     * 主表ID
     */
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;
    /**
     * 付款账户
     */
    @Column(name = "payment_account", columnDefinition = "varchar(255) comment '付款账户'")
    private String paymentAccount;
    /**
     * 付款账号
     */
    @Column(name = "payment_account_number", columnDefinition = "varchar(64) comment '付款账号'")
    private String paymentAccountNumber;
    /**
     * 付款金额
     */
    @Column(name = "payment_amt", columnDefinition = "decimal(20,6) comment '付款金额'")
    private BigDecimal paymentAmt;
    /**
     * 支付凭证编码
     */
    @Column(name = "voucher_file_code", columnDefinition = "varchar(255) comment '支付凭证编码'")
    private String voucherFileCode;

    @Column(name = "uni_bank_no", columnDefinition = "varchar(125) comment '联行号'")
    private String uniBankNo;
}
