package com.elitesland.fin.infr.factory.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author zhiyu.he
 * @date 2022/3/17 9:07
 */
@RequiredArgsConstructor
@Component
public class PayOrderFactory {
    private final PayOrderRepoProc payOrderRepoProc;

    private final PayOrderDtlRepoProc payOrderDtlRepoProc;

    public PagingVO<PayOrderDTO> payOrderPage(PayOrderPageParam param) {
        if (!StringUtils.isEmpty(param.getSourceNoDtl()) ||  CollectionUtil.isNotEmpty(param.getDtlSourceNoList())) {
            //查询出所有付款单ID
            List<Long> dtlMasIds = org.apache.commons.lang3.StringUtils.isBlank(param.getSourceNoDtl()) ? new ArrayList<>() :
                    payOrderDtlRepoProc.queryBySourceNo(param.getSourceNoDtl()).stream().distinct().collect(Collectors.toList());
            List<Long> masIdList = payOrderDtlRepoProc.queryBySourceNoList(param.getDtlSourceNoList());
            List<Long> masIdAllList = Stream.of(dtlMasIds, masIdList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());

            //如果为空直接返回空
            if (CollUtil.isEmpty(masIdAllList)) {
                return new PagingVO<>(0,new ArrayList<>());
            } else {
                //不为空加上主键ID作为查询条件
                return payOrderRepoProc.page(param, masIdAllList);
            }
        } else {
            //为空走普通查询
            return payOrderRepoProc.page(param, null);
        }
    }
    public PagingVO<PayOrderDTO> writeoffPage(PayOrderPageParam param) {
        //查询出所有付款单ID
        List<Long> ids = payOrderDtlRepoProc.queryUnverBySourceNo(param).stream().distinct().collect(Collectors.toList());
        //如果为空直接返回空
        if (CollUtil.isEmpty(ids)) {
            return new PagingVO<>(0,new ArrayList<>());
        } else {
            //不为空加上主键ID作为查询条件
            return payOrderRepoProc.page(param, ids);
        }
    }
}
