/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.invoice.await;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDDTO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.provider.invoice.await.InvoiceAwaitSaveServiceFactory;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.service.invoice.InvoiceAwaitRpcService;
import com.elitesland.order.param.SalReconciliatQueryDTO;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/pay"})
public class InvoiceAwaitRpcServiceImpl
implements InvoiceAwaitRpcService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitRpcServiceImpl.class);
    private final InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final SystemRpcService systemRpcService;
    private final InvoiceAwaitService invoiceAwaitService;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;
    private final RmiOrderRpcService rmiOrderRpcService;
    private final SysNumberGenerator sysNumberGenerator;
    private final FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(final InvoiceAwaitSaveParam param) {
        List<SaleReconciliatDTO> saleReconciliatDTOS;
        log.info("\u5f00\u59cb\u7ec4\u88c5\u5f85\u5f00\u7968\u6570\u636e\uff0c\u63a5\u6536\u5230\u7684\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)param));
        ApiResult<Long> result = this.checkSaveParam(param);
        if (ObjectUtil.isNotNull(result)) {
            log.info("\u7ec4\u88c5\u5f85\u5f00\u7968\u6570\u636e\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a{}", (Object)JSON.toJSONString(result));
            return result;
        }
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocCls(param.getOptDocCls());
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = this.invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if (CollectionUtil.isEmpty(ruleConfigDTOList)) {
            log.info("\u672a\u914d\u7f6e\u5f00\u7968\u8bbe\u7f6e\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u5f00\u53d1\u7968");
            return null;
        }
        SalReconciliatQueryDTO dto = new SalReconciliatQueryDTO();
        dto.setDocNos((List)new ArrayList<String>(){
            {
                this.add(param.getOptDocNo());
            }
        });
        dto.setInvState(UdcEnum.INV_STATE_WAIT.getValueCode());
        dto.setState("CONFIRM");
        try {
            log.info("\u67e5\u8be2\u5bf9\u8d26\u5355\u53c2\u6570\uff1a{}", (Object)dto);
            saleReconciliatDTOS = this.rmiOrderRpcService.querySalReconciliat(dto);
            log.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u5230\u7684\u6570\u636e\u7ed3\u679c\uff1a{} ", (Object)JSONUtil.toJsonStr(saleReconciliatDTOS));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5bf9\u8d26\u5355\u63a5\u53e3\u51fa\u9519,\u8bf7\u6c42\u53c2\u6570:{}, \u62a5\u9519\u4fe1\u606f\uff1a{}  ", (Object)dto, (Object)e.getMessage());
            return null;
        }
        if (CollectionUtil.isEmpty(saleReconciliatDTOS)) {
            return null;
        }
        List<SaleReconciliatDTO> collect = saleReconciliatDTOS.stream().filter(item -> CollectionUtil.isNotEmpty((Collection)item.getSaleReconciliatDtlDTOList())).toList();
        List<InvoiceAwaitDTO> dtos = this.invoiceAwaitService.buildSalRecToInvoiceAwaitOrder(collect);
        ArrayList list = new ArrayList();
        log.info("\u4fdd\u5b58\u5f85\u5f00\u7968\u7533\u8bf7\uff1a{}", (Object)JSONUtil.toJsonStr(dtos));
        ArrayList invoiceAwaitDOList = new ArrayList();
        dtos.forEach(item -> {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
            InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do((InvoiceAwaitDTO)item);
            awaitDO.setDocNo(docNo);
            this.flexFieldUtilService.handFlexFieldValueFeference("INVOICE_AWAIT", (Object)awaitDO);
            InvoiceAwaitDO save = (InvoiceAwaitDO)this.invoiceAwaitRepo.save(awaitDO);
            List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
            dtlList.forEach(dtl -> {
                InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do((InvoiceAwaitDDTO)dtl);
                dtlDo.setMasId(save.getId());
                this.invoiceAwaitDRepo.save(dtlDo);
                list.add(dtl.getOptDocDtlId());
            });
            invoiceAwaitDOList.add(save);
        });
        List<Long> collect2 = list.stream().filter(ObjectUtil::isNotNull).toList();
        if (CollectionUtils.isNotEmpty(collect2)) {
            SalReconciliatQueryDTO updateDto = new SalReconciliatQueryDTO();
            updateDto.setDtlIds(list);
            try {
                this.rmiOrderRpcService.updateTransState(updateDto);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5bf9\u8d26\u5355\u660e\u7ec6\u4f20\u8f93\u72b6\u6001\u5931\u8d25\uff0c\u53c2\u6570: {}\uff0c\u5931\u8d25\u4fe1\u606f: {}\uff0c", (Object)updateDto, (Object)e.getMessage());
            }
        }
        invoiceAwaitDOList.forEach(save -> {
            InvoiceApplyParam applyParam = new InvoiceApplyParam();
            applyParam.setCustInvTitle(save.getInvTitle());
            applyParam.setCustTaxNo(save.getTaxerNo());
            applyParam.setInvType(save.getInvType());
            applyParam.setCustBank(save.getInvBankName());
            applyParam.setCustBankAcc(save.getInvBankAcc());
            applyParam.setCustTel(save.getInvTel());
            applyParam.setCustAdd(save.getInvAddress());
            applyParam.setInvTitleType(save.getInvTitleType());
            applyParam.setInvPicName(save.getInvPicName());
            applyParam.setInvPicPhone(save.getInvPicPhone());
            applyParam.setInvEmail(save.getInvEmail());
            applyParam.setIds(List.of(save.getId()));
            log.info("\u751f\u6210\u5f85\u5f00\u7968\u7533\u8bf7\uff1a{}", (Object)JSONUtil.toJsonStr((Object)applyParam));
            this.abstractInvoiceSaveService.save(applyParam);
        });
        return ApiResult.ok();
    }

    private ApiResult<Long> checkSaveParam(InvoiceAwaitSaveParam param) {
        if (Strings.isEmpty((CharSequence)param.getOptDocType())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isEmpty((CharSequence)param.getOptDocNo())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isEmpty((CharSequence)param.getOptDocStatus())) {
            return ApiResult.fail((String)"\u53ef\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.invoiceAwaitRepo.existsByOptDocNoAndOptDocType(param.getOptDocNo(), param.getOptDocType())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u5df2\u7ecf\u7533\u8bf7\u5f00\u8fc7\u53d1\u7968");
        }
        return null;
    }

    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {
        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        invoiceAwaitDO.setDocNo(this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<String>()));
        Long masId = ((InvoiceAwaitDO)this.invoiceAwaitRepo.save(invoiceAwaitDO)).getId();
        this.saveRecordsD(param, masId);
        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();
        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        this.invoiceAwaitDRepo.deleteByMasId(masId);
        this.invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOptDocNoBatch(List<String> optDocNos) {
        log.info("\u6839\u636e\u6765\u6e90\u5355\u53f7\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684Rpc\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocNos));
        if (CollectionUtil.isNotEmpty(optDocNos)) {
            this.invoiceAwaitService.updateDeleteFlagByOptDocNoBatch(optDocNos);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOptDocIdBatch(List<Long> optDocIds) {
        log.info("\u6839\u636e\u6765\u6e90\u5355\u636e\u4e3b\u952eid\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684Rpc\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocIds));
        if (CollectionUtil.isNotEmpty(optDocIds)) {
            this.invoiceAwaitService.updateDeleteFlagByOptDocIdBatch(optDocIds);
        }
    }

    public InvoiceAwaitRpcServiceImpl(InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory, InvoiceAwaitRepo invoiceAwaitRepo, InvoiceAwaitDRepo invoiceAwaitDRepo, SystemRpcService systemRpcService, InvoiceAwaitService invoiceAwaitService, InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc, RmiOrderRpcService rmiOrderRpcService, SysNumberGenerator sysNumberGenerator, FlexFieldUtilService flexFieldUtilService) {
        this.invoiceAwaitSaveServiceFactory = invoiceAwaitSaveServiceFactory;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.systemRpcService = systemRpcService;
        this.invoiceAwaitService = invoiceAwaitService;
        this.invoiceRuleConfigRepoProc = invoiceRuleConfigRepoProc;
        this.rmiOrderRpcService = rmiOrderRpcService;
        this.sysNumberGenerator = sysNumberGenerator;
        this.flexFieldUtilService = flexFieldUtilService;
    }
}

