package com.elitesland.fin.application.web.unionpay;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.service.unionpay.OfflinePayService;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author gyj
 * @Date 2023/7/18
 */
@Slf4j
@Api(tags = "tims线下支付接口")
@RestController
@RequestMapping(value = "/offlinepay")
@AllArgsConstructor
public class OfflinePayController {

    private final OfflinePayService offlinePayService;

    @PostMapping("/offlinePay")
    @ApiModelProperty("线下支付")
    public ApiResult<Long> offlinePay(@RequestBody SendPayReq payReq){
        if (ObjectUtils.isEmpty(payReq.getRemitterAmt())){
            log.warn("账户储值金额有误:{}",payReq.getRemitterAmt());
            return ApiResult.fail("账户储值金额有误");
        }

        return ApiResult.ok(offlinePayService.offlinePay(payReq));
    }


}
