package com.elitesland.fin.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@Component
@ConfigurationProperties(prefix = "saobei")
public class SaoBeiProperties {

    public static final String CONFIG_PREFIX = "saobei";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 租户编码
     */
    private String tenantCode;

    /**
     * 签名key
     */
    private String accessToken;

    /**
     * 版本号
     */
    private String payVer;

    /**
     * 环境
     */
    private String env;

    /**
     * 账户中心地址
     */
    private String centerServerUrl;

    /**
     * 账户中心路径
     */
    private String centerPath;

    /**
     * 机构号
     */
    private String instNo;

    /**
     * 品牌编码
     */
    private String brandNo;

    /**
     * 机构令牌（key
     */
    private String instkey;

    /**
     * mch地址
     */
    private String mchServerUrl;

    /**
     * 余额查询路径
     */
    private String accountBalancePath;

    /**
     * 余额分账
     */
    private String accountTransPath;

    /**
     * 创建账户
     */
    private String createAccountPath;

    /**
     * 分账关系
     */
    private String addAccountInPath;

    /**
     * 账户认证
     */
    private String accountAuthenticationPath;

    /**
     * 账户信息查询
     */
    private String queryAccountPath;

    /**
     * 查询分账关系
     */
    private String accountInQueryPath;

    private String queryTradesByDatePath;

    private String transNotifyUrl;

    private String updateAccountUrl;

    private String queryOrderPath;

    private String apiVer;

    /**
     * 场景编码
     */
    private String sceneNo;

}
