package com.elitesland.fin.domain.entity.saleinv;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Entity
@Table(name="sale_inv_dtl")
@org.hibernate.annotations.Table(appliesTo = "sale_inv_dtl", comment = "销售发票明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SaleInvDtlDO extends BaseModel implements Serializable {


    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "tax_name", columnDefinition = "varchar(32) comment '应税货物或劳务、服务名称'")
    private String taxName;

    @Column(name = "tax_code", columnDefinition = "varchar(32) comment '税收分类编码'")
    private String taxCode;

    @Column(name = "inv_nature", columnDefinition = "varchar(32) comment '发票行性质'")
    private String invNature;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '发/收货单号'")
    private String docNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "source_time", columnDefinition = "bigint(20) comment '来源单时间'")
    private Long sourceTime;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "source_line_id", columnDefinition = "bigint(20) comment '来源行号ID'")
    private Long sourceLineId;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_name", columnDefinition = "varchar(32) comment '商品名称'")
    private String itemName;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '规格型号'")
    private String itemType;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(32) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "inv_type", columnDefinition = "varchar(32) comment '发票类型'")
    private String invType;

    @Column(name = "inv_kind", columnDefinition = "varchar(32) comment '红/蓝票'")
    private String invKind;

    @Column(name = "exam_type", columnDefinition = "varchar(32) comment '查验状态'")
    private String examType;

    @ApiModelProperty("渠道类型")
    @Column(name = "so_source", columnDefinition = "varchar(32) comment '渠道类型'")
    private String soSource;

//    @Column(name = "uom2", columnDefinition = "varchar(32) comment '辅单位'")
//    private String uom2;
//
//    @Column(name = "uom2_name", columnDefinition = "varchar(32) comment '辅单位名称'")
//    private String uom2Name;
//
//    @Column(name = "qty2", columnDefinition = "decimal(16,4) comment '辅数量'")
//    private BigDecimal qty2;
//
//    @Column(name = "es5", columnDefinition = "decimal(18,8) comment '主未税单价'")
//    private BigDecimal es5;
//
//    @Column(name = "price2", columnDefinition = "decimal(18,8) comment '辅含税单价'")
//    private BigDecimal price2;
//
//    @Column(name = "es7", columnDefinition = "decimal(18,8) comment '辅未税单价'")
//    private BigDecimal es7;
//
//    @Column(name = "discount_amt", columnDefinition = "decimal(18,8) comment '折扣额'")
//    private BigDecimal discountAmt;
//
//    @Column(name = "es9", columnDefinition = "decimal(18,8) comment '整单折扣'")
//    private BigDecimal es9;
//
//    @ApiModelProperty("单品折扣")
//    @Column(name = "es10", columnDefinition = "decimal(18,8) comment '单品折扣'")
//    private BigDecimal es10;
//
//    @ApiModelProperty("发票折扣")
//    @Column(name = "es11", columnDefinition = "decimal(18,8) comment '发票折扣'")
//    private BigDecimal es11;
//
//    @Column(name = "es12", columnDefinition = "decimal(18,8) comment '票扣前金额'")
//    private BigDecimal es12;
//
//    @Column(name = "es13", columnDefinition = "decimal(18,8) comment '票扣金额'")
//    private BigDecimal es13;
//
//    @Column(name = "es14", columnDefinition = "varchar(32) comment '赠品'")
//    private String es14;
//
//    @Column(name = "es15", columnDefinition = "varchar(32) comment '客户编码'")
//    private String es15;
//
//    @Column(name = "es16", columnDefinition = "varchar(32) comment '客户编码'")
//    private String es16;
//
//    @Column(name = "es17", columnDefinition = "varchar(32) comment '扣税类别'")
//    private String es17;
//
//    @Column(name = "es18", columnDefinition = "varchar(32) comment 'NC销售订单号'")
//    private String es18;
//
//    @Column(name = "es19", columnDefinition = "varchar(32) comment '销售渠道类型'")
//    private String es19;

    @ApiModelProperty("返利冲抵金额")
    @Column(name = "fl_deduction_amt", columnDefinition = "DECIMAL(20,8) comment '返利冲抵金额'")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    @Column(name = "inv_discount_amt", columnDefinition = "DECIMAL(20,8) comment '票扣含税金额'")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    @Column(name = "discount_amt", columnDefinition = "DECIMAL(20,8) comment '折扣额'")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    @Column(name = "inv_amt", columnDefinition = "DECIMAL(20,8) comment '可开票含税金额'")
    private BigDecimal invAmt;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户姓名'")
    private String custName;

    @ApiModelProperty("是否赠品")
    @Column(name = "gifts_flag", columnDefinition = "varchar(32) comment '是否赠品'")
    private String giftsFlag;

    @ApiModelProperty("发票折扣率")
    @Column(name = "inv_discount", columnDefinition = "decimal(18,8) comment '发票折扣率'")
    private BigDecimal invDiscount;

    @ApiModelProperty("业务员员工名字")
    @Column(name = "agent_name", columnDefinition = "varchar(32) comment '业务员员工名字'")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    @Column(name = "agent_emp_id", columnDefinition = "bigint(20) comment '业务员员工ID'")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    @Column(name = "recv_contact_name", columnDefinition = "varchar(32) comment '收货联系人'")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    @Column(name = "recv_contact_tel", columnDefinition = "varchar(32) comment '收货联系电话'")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    @Column(name = "recv_detailaddr", columnDefinition = "varchar(128) comment '收货详细地址'")
    private String recvDetailaddr;

    @ApiModelProperty("待开发票id")
    @Column(name = "invoice_await_id", columnDefinition = "bigint(20) comment '待开发票id'")
    private Long invoiceAwaitId;

    @Column(name = "inv_no", columnDefinition = "varchar(32) comment '发票号码'")
    private String invNo;

    @Column(name = "root_doc_cls", columnDefinition = "varchar(64) default null  comment '根单据类别。[UDC]COM:DOC_CLS'")
    private String rootDocCls;

    @Column(name = "root_doc_type", columnDefinition = "varchar(64) default null  comment '根单据类型'")
    private String rootDocType;

    @Column(name = "root_doc_id", columnDefinition = "bigint(20) default 0 comment '根单据ID'")
    private Long rootDocId;
    @Column(name = "root_doc_no", columnDefinition = "varchar(64) default null  comment '根单据编号'")
    private String rootDocNo;
    @Column(name = "root_doc_time", columnDefinition = "datetime default null  comment '根单据下单时间'")
    private LocalDateTime rootDocTime;
    @Column(name = "root_doc_did", columnDefinition = "bigint(20) default 0 comment '来源单据明细ID'")
    private Long rootDocDId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaleInvDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SaleInvDtlDO entity = (SaleInvDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
