package com.elitesland.fin.domain.param.payorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 16:57
 */
@Data
public class PayOrderParam implements Serializable {
    private static final long serialVersionUID = -4592366059683720269L;
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("业务日期开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty("业务日期结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty("付款单号")
    private List<String> payOrderNoList;

}
