package com.elitesland.fin.domain.service.creditaccount;

import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

@Slf4j
@Service
@AllArgsConstructor
public class CreditAccountDomainServiceImpl implements CreditAccountDomainService{
    private final CreditAccountRepo creditAccountRepo;
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(long id, BigDecimal creditAccountOccupancy) {
        return creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(id,creditAccountOccupancy);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount) {
        return creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(id,amount);

    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount) {
        return creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(id,amount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount) {
        return creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(id,amount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount) {
        return creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(id,amount);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public int updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(Long id, BigDecimal amount) {
        return creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(id,amount);
    }
}
