package com.elitesland.fin.infinity.aisino.vo.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 蓝票开票申请响应类
 * 用于接收航信蓝票开票申请接口的返回结果
 */
@Data
public class BlueInvoiceApplyRespVO {
    /**
     * 响应代码
     * "0000" 表示订单推送成功
     */
    @JSONField(name = "CODE")
    private String CODE;

    /**
     * 响应数据
     */
    @JSONField(name = "DATA")
    private Data DATA;

    /**
     * 返回消息
     * 描述接口调用的结果信息
     */
    @JSONField(name = "RETURNMESSAGE")
    private String RETURNMESSAGE;

    /**
     * 响应数据内部类
     */
    @lombok.Data
    public static class Data {

        /**
         * 发票请求流水号
         * 唯一标识一次发票开具请求
         */
        @JSONField(name = "FPQQLSH")
        private String FPQQLSH;

        /**
         * 开票状态
         * "0"-开票中, "1"-开票成功, "2"-开票失败
         */
        @JSONField(name = "KPZT")
        private String KPZT;

        /**
         * 开票状态消息
         * 对开票状态的文字描述
         */
        @JSONField(name = "KPZT_MSG")
        private String KPZT_MSG;

        /**
         * 发票号码
         * 开票成功后返回的实际发票号码
         */
        @JSONField(name = "FPHM")
        private String FPHM;

        /**
         * 开票日期
         * 开票成功后返回的开票时间
         */
        @JSONField(name = "KPRQ")
        private String KPRQ;

        /**
         * 发票URL
         * 开票成功后返回的发票PDF下载链接
         */
        @JSONField(name = "FPURL")
        private String FPURL;
    }
}
