package com.elitesland.fin.infr.repo.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderDtlDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:38
 */
@Component
@AllArgsConstructor
public class ArOrderRepoProc {

    private static final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;
    private static final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;

    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<ArOrderDTO> unverPage(ArOrderPageParam arOrderPageParam, List<Long> ids) {
        arOrderPageParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        var predicates = pageWhere(arOrderPageParam);
        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add(qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        // 来源单号明细搜索
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getIds())) {
            predicates.add(qArOrderDO.id.in(arOrderPageParam.getIds()));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(qArOrderDO.id.in(ids));
        }
        JPAQuery<ArOrderDTO> query = select(ArOrderDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        //数据权限
        BusinessSecurityUtil.where(query, ArOrderDO.class);
        arOrderPageParam.setPaging(query);
        arOrderPageParam.fillOrders(query, qArOrderDO);
        return PagingVO.<ArOrderDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam, List<Long> ids) {
        var predicates = pageWhere(arOrderPageParam);
        if (CollUtil.isNotEmpty(arOrderPageParam.getInOutCustList())) {
            predicates.add(qArOrderDO.inOutCust.in(arOrderPageParam.getInOutCustList()));
        }
        // 来源单号明细搜索
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getIds())) {
            predicates.add(qArOrderDO.id.in(arOrderPageParam.getIds()));
        } else if (StringUtils.isNotBlank(arOrderPageParam.getSourceNoDtl()) || CollectionUtil.isNotEmpty(arOrderPageParam.getDtlSourceNoList())) {
            if (CollUtil.isNotEmpty(ids)) {
                predicates.add(qArOrderDO.id.in(ids));
            } else {
                return new PagingVO<>(0, new ArrayList<>());
            }
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(arOrderPageParam.getConditions(), ArOrderDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
        JPAQuery<ArOrderDTO> query = select(ArOrderDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        //数据权限
        BusinessSecurityUtil.where(query, ArOrderDO.class);
        arOrderPageParam.setPaging(query);
        arOrderPageParam.fillOrders(query, qArOrderDO);
        return PagingVO.<ArOrderDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public PagingVO<ArExportEntity> exportDefault(ArOrderPageParam arOrderPageParam) {
        var predicates = pageWhere(arOrderPageParam);
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getIds())) {
            predicates.add(qArOrderDO.id.in(arOrderPageParam.getIds()));
        } else if(StringUtils.isNotBlank(arOrderPageParam.getSourceNoDtl())) {
            predicates.add(qArOrderDtlDO.sourceNo.eq(arOrderPageParam.getSourceNoDtl()));
        }
        var query =  jpaQueryFactory.select(Projections.bean(
                ArExportEntity.class,
                qArOrderDO.id,
                qArOrderDO.sourceNo,
                qArOrderDO.arOrderNo,
                qArOrderDO.ouCode,
                qArOrderDO.ouName,
                qArOrderDO.createMode,
                qArOrderDO.arTypeName,
                qArOrderDO.arTypeCode,
                qArOrderDO.orderState,
                qArOrderDO.totalAmt,
                qArOrderDO.exclTaxAmt,
                qArOrderDO.taxAmt,
                qArOrderDO.totalCurAmt,
                qArOrderDO.exclTaxCurAmt,
                qArOrderDO.taxCurAmt,
                qArOrderDO.currCode,
                qArOrderDO.currName,
                qArOrderDO.localCurrCode,
                qArOrderDO.localCurrName,
                qArOrderDO.auditUser,
                qArOrderDO.auditDate,
                qArOrderDO.exchangeRate,
                qArOrderDO.taxFlag,
                qArOrderDO.initFlag,
                qArOrderDO.auditRejection,
                qArOrderDO.custCode,
                qArOrderDO.custName,
                qArOrderDO.buCode,
                qArOrderDO.buName,
                qArOrderDO.buType,
                qArOrderDO.verState,
                qArOrderDO.verAmt,
                qArOrderDO.totalAmt.subtract(qArOrderDO.verAmt).as("unVerAmt"),
                qArOrderDO.remark,
                qArOrderDO.orgCode,
                qArOrderDO.orgName,
                qArOrderDO.saleUser,
                qArOrderDO.creator,
                qArOrderDO.createTime,
                qArOrderDO.updater,
                qArOrderDO.modifyTime,
                qArOrderDO.docType,
                qArOrderDO.docType2,
                qArOrderDO.docCls,
                qArOrderDO.submitTime,
                qArOrderDO.approvedTime,
                qArOrderDO.settlementType,
                qArOrderDO.proposedStatus,
                qArOrderDO.redState,
                qArOrderDO.redSourceNo,
                qArOrderDtlDO.sourceNo.as("detailSourceNo"),
                qArOrderDtlDO.sourceLine.as("detailSourceLine"),
                qArOrderDtlDO.itemCode,
                qArOrderDtlDO.itemName,
                qArOrderDtlDO.itemType,
                qArOrderDtlDO.smallCateCode,
                qArOrderDtlDO.smallCateName,
                qArOrderDtlDO.uom,
                qArOrderDtlDO.uomName,
                qArOrderDtlDO.qty.as("detailQty"),
                qArOrderDtlDO.exclTaxPrice.as("detailExclTaxPrice"),
                qArOrderDtlDO.price.as("detailPrice"),
                qArOrderDtlDO.taxRate.as("detailTaxRate"),
                qArOrderDtlDO.totalAmt.as("detailTotalAmt"),
                qArOrderDtlDO.exclTaxAmt.as("detailExclTaxAmt"),
                qArOrderDtlDO.taxAmt.as("detailTaxAmt"),
                qArOrderDtlDO.totalCurAmt.as("detailTotalCurAmt"),
                qArOrderDtlDO.exclTaxCurAmt.as("detailExclTaxCurAmt"),
                qArOrderDtlDO.taxCurAmt.as("detailTaxCurAmt"),
                qArOrderDtlDO.buName.as("detailBuName"),
                qArOrderDtlDO.expensesType,
                qArOrderDtlDO.remark.as("detailRemark")
        ))
        .from(qArOrderDO)
        .leftJoin(qArOrderDtlDO)
        .on(qArOrderDO.id.eq(qArOrderDtlDO.masId))
        .where(ExpressionUtils.allOf(predicates));
        //数据权限
        BusinessSecurityUtil.where(query, ArOrderDO.class);
        arOrderPageParam.setPaging(query);
        arOrderPageParam.fillOrders(query, qArOrderDO);
        return PagingVO.<ArExportEntity>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> pageWhere(ArOrderPageParam arOrderPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        checkParam(arOrderPageParam, predicates);
        // 来源单据
        if (Objects.nonNull(arOrderPageParam.getEs2())){
            predicates.add(qArOrderDO.es2.like("%" + arOrderPageParam.getEs2() + "%"));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCreateMode())) {
            predicates.add(qArOrderDO.createMode.eq(arOrderPageParam.getCreateMode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getCreateModeList())){
            predicates.add(qArOrderDO.createMode.in(arOrderPageParam.getCreateModeList()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedState())){
            predicates.add(qArOrderDO.redState.eq(arOrderPageParam.getRedState()));
        }
        if (Objects.nonNull(arOrderPageParam.getRedSourceNo())){
            predicates.add(qArOrderDO.redSourceNo.like("%" + arOrderPageParam.getRedSourceNo() + "%"));
        }
        // 是否期初
        if (null != arOrderPageParam.getInitFlag()) {
            predicates.add(qArOrderDO.initFlag.eq(arOrderPageParam.getInitFlag()));
        }
        if(arOrderPageParam.getProposedStatus()!=null){
            predicates.add(qArOrderDO.proposedStatus.eq(arOrderPageParam.getProposedStatus()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getProtocolCode())) {
            predicates.add(qArOrderDO.protocolCode.eq(arOrderPageParam.getProtocolCode()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getProtocolCodeList())) {
            predicates.add(qArOrderDO.protocolCode.in(arOrderPageParam.getProtocolCodeList()));
        }
        if (CollectionUtil.isNotEmpty(arOrderPageParam.getRelevanceOuCodeList())) {
            predicates.add(qArOrderDO.relevanceOuCode.in(arOrderPageParam.getRelevanceOuCodeList()));
        }

        // 销售组织
        buildPredicates(arOrderPageParam, predicates);

        predicates.add(qArOrderDO.deleteFlag.eq(0));
        return predicates;
    }

    private void buildPredicates(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(arOrderPageParam.getOrgCode())) {
            predicates.add(qArOrderDO.orgCode.eq(arOrderPageParam.getOrgCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOrgCodeList())){
            predicates.add(qArOrderDO.orgCode.in(arOrderPageParam.getOrgCodeList()));
        }
        if (null != arOrderPageParam.getOrgId()) {
            predicates.add(qArOrderDO.orgId.eq(arOrderPageParam.getOrgId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOrgIdList())){
            predicates.add(qArOrderDO.orgId.in(arOrderPageParam.getOrgIdList()));
        }
        // 客户
        if (null != arOrderPageParam.getCustId()) {
            predicates.add(qArOrderDO.custId.eq(arOrderPageParam.getCustId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getCustIdList())){
            predicates.add(qArOrderDO.custId.in(arOrderPageParam.getCustIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCustName())) {
            predicates.add(qArOrderDO.custName.like("%" + arOrderPageParam.getCustName() + "%"));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCustCode())) {
            predicates.add(qArOrderDO.custCode.eq(arOrderPageParam.getCustCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getCustCodeList())){
            predicates.add(qArOrderDO.custCode.in(arOrderPageParam.getCustCodeList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrCode())) {
            predicates.add(qArOrderDO.currCode.eq(arOrderPageParam.getCurrCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())){
            predicates.add(qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        // 销售业务员
        if (StringUtils.isNotBlank(arOrderPageParam.getSaleUser())) {
            predicates.add(qArOrderDO.saleUser.like("%" + arOrderPageParam.getSaleUser() + "%"));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getSaleUserList())){
            predicates.add(qArOrderDO.saleUser.in(arOrderPageParam.getSaleUserList()));
        }
        // 销售部门
        if (null != arOrderPageParam.getBuId()) {
            predicates.add(qArOrderDO.buId.eq(arOrderPageParam.getBuId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getBuIdList())){
            predicates.add(qArOrderDO.buId.in(arOrderPageParam.getBuIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getBuCode())) {
            predicates.add(qArOrderDO.buCode.eq(arOrderPageParam.getBuCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getBuCodeList())){
            predicates.add(qArOrderDO.buCode.in(arOrderPageParam.getBuCodeList()));
        }
        // 审核日期
        if (null != arOrderPageParam.getAuditDateStart() && null != arOrderPageParam.getAuditDateEnd()) {
            predicates.add(qArOrderDO.auditDate.between(arOrderPageParam.getAuditDateStart(), arOrderPageParam.getAuditDateEnd()));
        }
        if (ObjectUtil.isNotNull(arOrderPageParam.getOuId())) {
            predicates.add(qArOrderDO.ouId.eq(arOrderPageParam.getOuId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())){
            predicates.add(qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getOuCode())) {
            predicates.add(qArOrderDO.ouCode.eq(arOrderPageParam.getOuCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOuCodeList())){
            predicates.add(qArOrderDO.ouCode.in(arOrderPageParam.getOuCodeList()));
        }
    }

    private void checkParam(ArOrderPageParam arOrderPageParam, List<Predicate> predicates) {
        // 公司
        if (null != arOrderPageParam.getOuId()) {
            predicates.add(qArOrderDO.ouId.eq(arOrderPageParam.getOuId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOuIdList())){
            predicates.add(qArOrderDO.ouId.in(arOrderPageParam.getOuIdList()));
        }
        // 币种
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrCode())) {
            predicates.add(qArOrderDO.currCode.eq(arOrderPageParam.getCurrCode()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getCurrCodeList())){
            predicates.add(qArOrderDO.currCode.in(arOrderPageParam.getCurrCodeList()));
        }
        if (StringUtils.isNotBlank(arOrderPageParam.getCurrName())) {
            predicates.add(qArOrderDO.currName.eq(arOrderPageParam.getCurrName()));
        }
        // 业务日期
        if (null != arOrderPageParam.getBuDateStart() && null != arOrderPageParam.getBuDateEnd()) {
            predicates.add(qArOrderDO.buDate.between(arOrderPageParam.getBuDateStart(), arOrderPageParam.getBuDateEnd()));
        }
        // 来源系统单号
        if (StringUtils.isNotBlank(arOrderPageParam.getSourceNo())) {
            predicates.add(qArOrderDO.sourceNo.like('%' + arOrderPageParam.getSourceNo() + '%'));
        }

        // 应收单类型
        if (null != arOrderPageParam.getArTypeId()) {
            predicates.add(qArOrderDO.arTypeId.eq(arOrderPageParam.getArTypeId()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getArTypeIdList())){
            predicates.add(qArOrderDO.arTypeId.in(arOrderPageParam.getArTypeIdList()));
        }
        // 单据状态
        if (StringUtils.isNotBlank(arOrderPageParam.getOrderState())) {
            predicates.add(qArOrderDO.orderState.eq(arOrderPageParam.getOrderState()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getOrderStateList())){
            predicates.add(qArOrderDO.orderState.in(arOrderPageParam.getOrderStateList()));
        }
        // 核销状态
        if (StringUtils.isNotBlank(arOrderPageParam.getVerState())) {
            predicates.add(qArOrderDO.verState.eq(arOrderPageParam.getVerState()));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getVerStateList())){
            predicates.add(qArOrderDO.verState.in(arOrderPageParam.getVerStateList()));
        }
        // 应付单号
        if (StringUtils.isNotBlank(arOrderPageParam.getArOrderNo())) {
            predicates.add(qArOrderDO.arOrderNo.like('%' + arOrderPageParam.getArOrderNo() + '%'));
        }
        if(CollectionUtils.isNotEmpty(arOrderPageParam.getArOrderNoList())){
            predicates.add(qArOrderDO.arOrderNo.in(arOrderPageParam.getArOrderNoList()));
        }
        // 含税金额
        if (null != arOrderPageParam.getTotalAmtStart()) {
            predicates.add(qArOrderDO.totalAmt.goe(arOrderPageParam.getTotalAmtStart()));
        }
        if (null != arOrderPageParam.getTotalAmtEnd()) {
            predicates.add(qArOrderDO.totalAmt.loe(arOrderPageParam.getTotalAmtEnd()));
        }
        // 经办人
        if (StringUtils.isNotBlank(arOrderPageParam.getOperator())) {
            predicates.add(qArOrderDO.operator.like('%' + arOrderPageParam.getOperator() + '%'));
        }
        // 创建人
        if (StringUtils.isNotBlank(arOrderPageParam.getCreator())) {
            predicates.add(qArOrderDO.creator.like('%' + arOrderPageParam.getCreator() + '%'));
        }
        // 审核人
        if (StringUtils.isNotBlank(arOrderPageParam.getAuditUser())) {
            predicates.add(qArOrderDO.auditUser.like('%' + arOrderPageParam.getAuditUser() + '%'));
        }
    }

    public List<ArOrderDTO> queryByIds(List<Long> ids) {
        return select(ArOrderDTO.class)
                .where(qArOrderDO.id.in(ids))
                .fetch();
    }

    public List<ArOrderDTO> queryByVerStatus(List<String> verStatus) {
        return select(ArOrderDTO.class).where(qArOrderDO.verState.in(verStatus)).fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArOrderDO.id,
                qArOrderDO.sourceNo,
                qArOrderDO.ouCode,
                qArOrderDO.ouId,
                qArOrderDO.ouName,
                qArOrderDO.arTypeId,
                qArOrderDO.arTypeName,
                qArOrderDO.arTypeCode,
                qArOrderDO.currCode,
                qArOrderDO.currName,
                qArOrderDO.operator,
                qArOrderDO.operUserId,
                qArOrderDO.buType,
                qArOrderDO.totalAmt,
                qArOrderDO.totalCurAmt,
                qArOrderDO.buDate,
                qArOrderDO.auditUserId,
                qArOrderDO.auditUser,
                qArOrderDO.auditDate,
                qArOrderDO.orderState,
                qArOrderDO.exchangeRate,
                qArOrderDO.initFlag,
                qArOrderDO.taxFlag,
                qArOrderDO.buId,
                qArOrderDO.buCode,
                qArOrderDO.buName,
                qArOrderDO.createTime,
                qArOrderDO.updater,
                qArOrderDO.modifyTime,
                qArOrderDO.exclTaxAmt,
                qArOrderDO.taxAmt,
                qArOrderDO.taxCurAmt,
                qArOrderDO.arOrderNo,
                qArOrderDO.creator,
                qArOrderDO.createMode,
                qArOrderDO.remark,
                qArOrderDO.localCurrCode,
                qArOrderDO.localCurrName,
                qArOrderDO.exclTaxCurAmt,
                qArOrderDO.verState,
                qArOrderDO.verAmt,
                qArOrderDO.orgId,
                qArOrderDO.orgCode,
                qArOrderDO.orgName,
                qArOrderDO.saleUserId,
                qArOrderDO.saleUser,
                qArOrderDO.custName,
                qArOrderDO.custId,
                qArOrderDO.custCode,
                qArOrderDO.auditDataVersion,
                qArOrderDO.procInstId,
                qArOrderDO.procInstStatus,
                qArOrderDO.docType,
                qArOrderDO.docType2,
                qArOrderDO.docCls,
                qArOrderDO.approvedTime,
                qArOrderDO.submitTime,
                qArOrderDO.settlementType,
                qArOrderDO.proposedStatus,
                qArOrderDO.redSourceNo,
                qArOrderDO.redSourceId,
                qArOrderDO.redState,
                qArOrderDO.es1,
                qArOrderDO.es2,
                qArOrderDO.es3,
                qArOrderDO.es4,
                qArOrderDO.es5,
                qArOrderDO.es6,
                qArOrderDO.inOutCust,
                qArOrderDO.extensionInfo,
                qArOrderDO.protocolCode,
                qArOrderDO.relevanceOuCode
        )).from(qArOrderDO);
    }

    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = select(ArOrderDTO.class)
                .where(qArOrderDO.id.eq(id))
                .fetchOne();
        return arOrderDTO;
    }

    public List<ArOrderDTO> get(List<Long> ids) {
        return select(ArOrderDTO.class)
                .where(qArOrderDO.id.in(ids))
                .fetch();
    }

    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        long res = jpaQueryFactory.update(qArOrderDO)
                .set(qArOrderDO.auditDate, LocalDateTime.now())
                .set(qArOrderDO.auditRejection, content)
                .set(qArOrderDO.auditUser, user.getUsername())
                .set(qArOrderDO.auditUserId, user.getId())
                .where(qArOrderDO.id.in(ids))
                .execute();
        return res;
    }

    public Boolean queryByArTypeId(Long id) {
        return jpaQueryFactory.select(qArOrderDO.id)
                .from(qArOrderDO)
                .where(qArOrderDO.arTypeId.eq(id))
                .fetchCount() > 0;
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.delete(qArOrderDO)
                .where(qArOrderDO.id.in(ids))
                .execute();
        return res;
    }

    public ArVerDTO queryVerAmtById(Long id) {
        return jpaQueryFactory.select(Projections.bean(ArVerDTO.class,
                qArOrderDO.id,
                qArOrderDO.totalAmt,
                qArOrderDO.verAmt,
                qArOrderDO.auditDataVersion)).from(qArOrderDO).where(qArOrderDO.id.eq(id)).fetchOne();
    }

    public long updateVerAmt(ArVerDTO arVerDTO) {
        return jpaQueryFactory.update(qArOrderDO).set(qArOrderDO.verState, arVerDTO.getVerState())
                .set(qArOrderDO.verAmt, arVerDTO.getVerAmt())
                .set(qArOrderDO.auditDataVersion, arVerDTO.getAuditDataVersion() + 1)
                .where(qArOrderDO.id.eq(arVerDTO.getId())
                        .and(qArOrderDO.totalAmt.goe(arVerDTO.getVerAmt()))
                        .and(qArOrderDO.auditDataVersion.eq(arVerDTO.getAuditDataVersion())))
                .execute();
    }

    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        List<Predicate> predicates = new ArrayList<>();
        // 公司
        if (null != arOrderParam.getOuId()) {
            predicates.add(qArOrderDO.ouId.eq(arOrderParam.getOuId()));
        }
        if (arOrderParam.getCustId() != null) {
            predicates.add(qArOrderDO.custId.eq(arOrderParam.getCustId()));
        }
        // 币种
        if (CharSequenceUtil.isNotBlank(arOrderParam.getCurrCode())) {
            predicates.add(qArOrderDO.currCode.eq(arOrderParam.getCurrCode()));
        }
        // 业务日期
        if (null != arOrderParam.getBuDateStart() && null != arOrderParam.getBuDateEnd()) {
            predicates.add(qArOrderDO.buDate.between(arOrderParam.getBuDateStart(), arOrderParam.getBuDateEnd()));
        }
        if (StrUtil.isNotBlank(arOrderParam.getOuCode())) {
            predicates.add(qArOrderDO.ouCode.eq(arOrderParam.getOuCode()));
        }
        if (StrUtil.isNotBlank(arOrderParam.getCustCode())) {
            predicates.add(qArOrderDO.custCode.eq(arOrderParam.getCustCode()));
        }
        predicates.add(qArOrderDO.orderState.eq(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        List<ArOrderDTO> fetch = select(ArOrderDTO.class).where(ExpressionUtils.allOf(predicates)).fetch();
        return fetch;
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDO)
                .set(qArOrderDO.procInstStatus, ProcInstStatus.APPROVING)
                .set(qArOrderDO.procInstId, processInfo.getProcInstId())
                .set(qArOrderDO.submitTime, LocalDateTime.now())
                .where(qArOrderDO.id.eq(id));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qArOrderDO.procInstStatus, ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDO).setNull(qArOrderDO.redState)
            .where(qArOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDO).set(qArOrderDO.redState, flag)
            .where(qArOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }
    public long countOverduePeriodPay(String custCode, String ouCode){
        ArOrderPageParam arOrderPageParam = new ArOrderPageParam();
        arOrderPageParam.setCustCode(custCode);
        if (StringUtils.isNotBlank(ouCode)) {
            arOrderPageParam.setOuCode(ouCode);
        }
        var predicates = pageWhere(arOrderPageParam);
        predicates.add(qArOrderDtlDO.es24.isNotNull());
        predicates.add(qArOrderDtlDO.es24.before(LocalDateTime.now().minusDays(1).withHour(23).withMinute(59).withSecond(59)));
        var query =  jpaQueryFactory.select(Projections.bean(
                        qArOrderDtlDO.id
                ))
                .from(qArOrderDO)
                .leftJoin(qArOrderDtlDO)
                .on(qArOrderDO.id.eq(qArOrderDtlDO.masId))
                .where(ExpressionUtils.allOf(predicates));
        return query.fetchCount();
    }

    public List<ArOrderDTO> selectInOutCustByArOrderNo(List<String> arOrderNoList) {
        if (CollectionUtil.isEmpty(arOrderNoList)){
            return Collections.EMPTY_LIST;
        }
        List<ArOrderDTO> arOrderDTOList = jpaQueryFactory.select(
                Projections.bean(ArOrderDTO.class,
                        qArOrderDO.arOrderNo,
                        qArOrderDO.inOutCust,
                        qArOrderDO.relevanceOuCode))
                .from(qArOrderDO)
                .where(qArOrderDO.arOrderNo.in(arOrderNoList))
                .fetch();

        return arOrderDTOList;
    }


    public void updateSourceNo(String sourceNo, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDO)
                .set(qArOrderDO.sourceNo, sourceNo)
                .where(qArOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }

    public void updateVerState(String verState, Long id) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderDO)
                .set(qArOrderDO.verState, verState)
                .where(qArOrderDO.id.eq(id));
        jpaUpdateClause.execute();
    }

    public List<ArOrderDO> findBySourceNo(String sourceNo) {
        return jpaQueryFactory.selectFrom(qArOrderDO).where(qArOrderDO.sourceNo.eq(sourceNo)).fetch();
    }

    public List<ArOrderDO> findBySourceNoList(List<String> sourceNoList) {
        return jpaQueryFactory.selectFrom(qArOrderDO).where(qArOrderDO.sourceNo.in(sourceNoList)).fetch();
    }

}
