/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.limitadjustorder;

import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.workflow.limitadjustorder.LimitAdjustOrderProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.limitadjustorder.LimitAdjustOrderDO;
import com.elitesland.fin.entity.limitadjustorder.QLimitAdjustOrderDO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LimitAdjustOrderProcessServiceImpl
implements LimitAdjustOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(LimitAdjustOrderProcessServiceImpl.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final CreditAccountFlowService creditAccountFlowService;
    private final OperationLogMqMessageService operationLogMqMessageService;
    QLimitAdjustOrderDO qLimitAdjustOrderDo = QLimitAdjustOrderDO.limitAdjustOrderDO;
    public static String FIRST_TASK_DEF_KEY = "createrSubmit";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(String businessKey, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        LimitAdjustOrderDO limitAdjustOrderDO = this.getLimitAdjustOrderDO(businessKey);
        log.info("\u5f00\u59cb\u8d22\u52a1\u8c03\u6574\u5355\u5de5\u4f5c\u6d41\u56de\u8c03\uff0c\u6d41\u7a0b\u72b6\u6001\u4e3a:" + procInstStatus.getDesc());
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qLimitAdjustOrderDo).set(this.qLimitAdjustOrderDo.workflowProcInstStatus, (Object)procInstStatus).set((Path)this.qLimitAdjustOrderDo.auditUser, (Object)commentInfo.getUserName()).set(this.qLimitAdjustOrderDo.auditTime, (Object)commentInfo.getTime()).where(new Predicate[]{this.qLimitAdjustOrderDo.id.eq((Object)limitAdjustOrderDO.getId())});
        OperationLogDTO dto = switch (procInstStatus) {
            case ProcInstStatus.NOTSUBMIT -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_WITHDRAWAL, OperationTypeEnum.APPROVE_WITHDRAWAL.getDescription());
            }
            case ProcInstStatus.INTERRUPT -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.setNull((Path)this.qLimitAdjustOrderDo.workflowProcInstId);
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_WITHDRAWAL, OperationTypeEnum.APPROVE_WITHDRAWAL.getDescription());
            }
            case ProcInstStatus.INVALID -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).setNull((Path)this.qLimitAdjustOrderDo.workflowProcInstId);
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_CANCELLATION, OperationTypeEnum.APPROVE_CANCELLATION.getDescription());
            }
            case ProcInstStatus.REJECTED -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.auditRejectReason, (Object)commentInfo.getComment());
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_REJECT, OperationTypeEnum.APPROVE_REJECT.getDescription());
            }
            case ProcInstStatus.APPROVING -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(this.qLimitAdjustOrderDo.workflowSubmitTime, (Object)LocalDateTime.now());
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_SUBMIT, OperationTypeEnum.APPROVE_SUBMIT.getDescription());
            }
            case ProcInstStatus.APPROVED -> {
                jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set(this.qLimitAdjustOrderDo.workflowEndTime, (Object)commentInfo.getTime());
                yield this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_OK, OperationTypeEnum.APPROVE_OK.getDescription());
            }
            default -> this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_LimitAdjust:\u4fe1\u7528\u989d\u5ea6\u8c03\u6574\u5355", limitAdjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_OK, "\u6d41\u7a0b\u72b6\u6001:" + procInstStatus.getDesc());
        };
        CreditAccountFlowParam creditAccountFlowParam = null;
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED) && LocalDateTime.now().isAfter(limitAdjustOrderDO.getEffectiveTime())) {
            jpaUpdateClause.set((Path)this.qLimitAdjustOrderDo.docState, (Object)UdcEnum.APPLY_STATUS_ACTIVE.getValueCode()).execute();
            creditAccountFlowParam = this.buildCreditAccountFlowParam(limitAdjustOrderDO, UdcEnum.APPLY_STATUS_ACTIVE.getValueCode());
        }
        if (creditAccountFlowParam != null) {
            this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
        }
        jpaUpdateClause.execute();
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
    }

    private CreditAccountFlowParam buildCreditAccountFlowParam(LimitAdjustOrderDO limitAdjustOrderDO, String sourceDocStatus) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceNo(limitAdjustOrderDO.getDocNo());
        creditAccountFlowParam.setSourceId(limitAdjustOrderDO.getId());
        creditAccountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_AO.getValueCode());
        creditAccountFlowParam.setSourceDocType(limitAdjustOrderDO.getAdjustType());
        creditAccountFlowParam.setSourceDocStatus(sourceDocStatus);
        creditAccountFlowParam.setSourceDocAmount(limitAdjustOrderDO.getAdjustLimit());
        creditAccountFlowParam.setCreditAccountCode(limitAdjustOrderDO.getCreditAccountCode());
        return creditAccountFlowParam;
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        return null;
    }

    private LimitAdjustOrderDO getLimitAdjustOrderDO(String businessKey) {
        String docNo = businessKey.split("#")[0].trim();
        LimitAdjustOrderDO limitAdjustOrderDO = (LimitAdjustOrderDO)((Object)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qLimitAdjustOrderDo).where((Predicate)this.qLimitAdjustOrderDo.docNo.eq((Object)docNo))).fetchOne());
        if (limitAdjustOrderDO == null) {
            throw new RuntimeException("\u989d\u5ea6\u8c03\u6574\u5355(\u7f16\u7801:" + docNo + ")\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5ba1\u6279");
        }
        return limitAdjustOrderDO;
    }

    public LimitAdjustOrderProcessServiceImpl(JPAQueryFactory jpaQueryFactory, CreditAccountFlowService creditAccountFlowService, OperationLogMqMessageService operationLogMqMessageService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.creditAccountFlowService = creditAccountFlowService;
        this.operationLogMqMessageService = operationLogMqMessageService;
    }
}

