package com.elitesland.fin.application.facade.dto.writeoff;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;
/**
 * 应付付款核销申请单
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Data
public class FinApPayVerApplyDTO implements Serializable {
private static final long serialVersionUID =8933956207876455913L;

	/**
	 * 核销申请单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "核销申请单号")
	@Column(name = "apply_doc_no", nullable = true, length = 64)
	private String applyDocNo;

	/**
	 * 单据状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "单据状态")
	@Column(name = "state", nullable = true, length = 16)
	private String state;

	/**
	 * 核销状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "核销状态")
	@Column(name = "ver_state", nullable = true, length = 16)
	private String verState;

	/**
	 * verAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "verAmt")
	@Column(name = "ver_amt", nullable = true, length = 20)
	private Double verAmt;

	/**
	 * 申请日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "申请日期")
	@Column(name = "apply_date", nullable = true)
	private LocalDateTime applyDate;

	/**
	 * 申请人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "申请人ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "apply_user_id", nullable = true)
	private Long applyUserId;

	/**
	 * 申请人编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "申请人编码")
	@Column(name = "apply_user_code", nullable = true, length = 32)
	private String applyUserCode;

	/**
	 * 申请人名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "申请人名称")
	@Column(name = "apply_user_name", nullable = true, length = 32)
	private String applyUserName;

	/**
	 * 审批日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批日期")
	@Column(name = "approval_date", nullable = true)
	private LocalDateTime approvalDate;

	/**
	 * 审批人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "approval_user_id", nullable = true)
	private Long approvalUserId;

	/**
	 * 审批人编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批人编码")
	@Column(name = "approval_user_code", nullable = true, length = 32)
	private String approvalUserCode;

	/**
	 * 审批人名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批人名称")
	@Column(name = "approval_user_name", nullable = true, length = 32)
	private String approvalUserName;

	/**
	 * 审批意见
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批意见")
	@Column(name = "approval_remark", nullable = true, length = 64)
	private String approvalRemark;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;

	/**
	 * 表头标识符
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "表头标识符")
	@Column(name = "head_flag", nullable = true, length = 1)
	private Boolean headFlag;

	/**
	 * 推送nc失败原因
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "推送nc失败原因")
	@Column(name = "erp_log", nullable = true, length = 1000)
	private String erpLog;


	@ApiModelProperty("核销方案ID")

	private Long schemeId;

	@ApiModelProperty("核销方式")

	private String verMode;

}
