package com.elitesland.fin.application.facade.vo.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Data
public class AgingRangeComPagingVO  extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -2907774811850626534L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("账龄区间编码")
    private String agingRangeCode;

    @ApiModelProperty("账龄区间名称")
    private String agingRangeName;

    @ApiModelProperty("时间单位类型")
    @SysCode(sys = "yst-fin", mod = "AGING_RANGE_TIME_UNIT_TYPE")
    private String timeUnitType;
    @ApiModelProperty("时间单位类型名称")
    private String timeUnitTypeName;

    @ApiModelProperty("单位天数")
    private String unitDays;
    @ApiModelProperty("单位天数名称")
    private String unitDaysName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("状态名称")
    private String statusName;

}
