package com.elitesland.fin.application.service.saobei;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.saobei.param.*;
import com.elitesland.fin.application.facade.param.saobei.vo.*;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.config.SaoBeiConstant;
import com.elitesland.fin.config.SaoBeiProperties;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.saobei.open.sdk.model.requst.allocate.*;
import com.saobei.open.sdk.model.response.allocate.*;
import com.saobei.open.sdk.util.ApiUtil;
import com.saobei.open.sdk.util.HttpClientUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;

@Service
@Slf4j
@RequiredArgsConstructor
public class SaobeiAccountServiceImpl implements SaobeiAccountService {

    private final SaoBeiProperties saoBeiProperties;

    private final AccountFlowRepo accountFlowRepo;

    private final CreditAccountFlowRepo creditAccountFlowRepo;

    @Override
    public SaobeiAccountInAddResponse addAccountIn(String accountNoOut, String accountNoIn, Integer allocateScale) throws Exception {
        SaobeiAccountInParamVO accountInAddRequest = new SaobeiAccountInParamVO();
        accountInAddRequest.setInst_no(saoBeiProperties.getInstNo());
        accountInAddRequest.setApi_ver(saoBeiProperties.getApiVer());
        accountInAddRequest.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        accountInAddRequest.setAccount_no_out(accountNoOut);
        accountInAddRequest.setContract_type("1");
        accountInAddRequest.setRelation_type("1");
        SaobeiAccountRuleParamVO saobeiAccountRuleParamVO = new SaobeiAccountRuleParamVO();
        saobeiAccountRuleParamVO.setAccount_no_in(accountNoIn);
        saobeiAccountRuleParamVO.setAllocate_scale(allocateScale);
        accountInAddRequest.setAccount_rule(JSON.toJSONString(saobeiAccountRuleParamVO));
        JSONObject obj = ApiUtil.convertRequest(accountInAddRequest, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗添加分账关系报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAddAccountInPath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗添加分账关系返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiAccountInAddResponse.class);
        if (response == null) {
            throw new BusinessException("扫呗添加分账关系响应为空");
        }
        return response;
    }

    @Override
    public SaobeiAccountAuthenticationResponse accountAuthentication(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        paramVO.setInst_no(saoBeiProperties.getInstNo());
        paramVO.setApi_ver(saoBeiProperties.getApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(paramVO, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗CBK账户鉴权报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAccountAuthenticationPath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗CBK账户鉴权返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiAccountAuthenticationResponse.class);
        if (response == null) {
            throw new BusinessException("扫呗CBK账户鉴权响应为空");
        }
        return response;
    }

    @Override
    public SaobeiAccountQueryResponse queryAccount(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        String responseStr = saoBeiQueryAccount(paramVO);
        var response = JSON.parseObject(responseStr, SaobeiAccountQueryResponse.class);
        if (response == null) {
            throw new BusinessException("扫呗CBK账户查询响应为空");
        }
        return response;
    }

    @Override
    public SaobeiAccountDetailVO queryAccountDetail(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        String responseStr = saoBeiQueryAccount(paramVO);
        var response = JSON.parseObject(responseStr, SaobeiAccountDetailVO.class);
        if (response == null) {
            throw new BusinessException("扫呗CBK账户查询响应为空");
        }
        return response;
    }

    private String saoBeiQueryAccount(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        paramVO.setInst_no(saoBeiProperties.getInstNo());
        paramVO.setApi_ver(saoBeiProperties.getApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(paramVO, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗CBK账户信息查询报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getQueryAccountPath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗CBK账户信息返回报文: {}", responseStr);
        return responseStr;
    }

    @Override
    public SaobeiAccountInQueryResponse queryAccountIn(SaobeiAccountInQueryRequest paramVO) throws Exception {
        paramVO.setInst_no(saoBeiProperties.getInstNo());
        paramVO.setApi_ver(saoBeiProperties.getApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(paramVO, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗分账关系查询报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAccountInQueryPath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗分账关系查询返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiAccountInQueryResponse.class);
        if (response == null) {
            throw new BusinessException("扫呗分账关系查询响应为空");
        }
        return response;
    }

    @Override
    public SaobeiTradeRespVO queryTradesByDate(SaobeiTradeParamVO paramVO) throws Exception {
        paramVO.setInst_no(saoBeiProperties.getInstNo());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        paramVO.setApi_ver(saoBeiProperties.getApiVer());
        JSONObject obj = ApiUtil.convertRequest(paramVO, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("请求分账数据列表查询报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getQueryTradesByDatePath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗分账数据列表查询返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiTradeRespVO.class);
        if (SaoBeiConstant.SUCCESS_CODE.equals(response.getReturn_code()) && SaoBeiConstant.SUCCESS_CODE.equals(response.getResult_code())) {
            return response;
        }
        throw new BusinessException("查询分帐数据失败:" + response.getReturn_msg());
    }

    @Override
    public SaobeiAccountUpdateResponse updateAccount(SaobeiAccountUpdateRequest request) throws Exception {
        request.setApi_ver(saoBeiProperties.getApiVer());
        request.setInst_no(saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(request, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗更新结算信息报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getUpdateAccountUrl(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗更新结算信息返回报文: {}", responseStr);
        return JSON.parseObject(responseStr, SaobeiAccountUpdateResponse.class);
    }

    @Override
    public String centerlink(String accountNo) throws Exception {
        SaobeiCenterlinkParamVO saobeiCenterlinkParamVO = new SaobeiCenterlinkParamVO();
        saobeiCenterlinkParamVO.setAccount_no(accountNo);
        saobeiCenterlinkParamVO.setInst_no(saoBeiProperties.getInstNo());
        saobeiCenterlinkParamVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        saobeiCenterlinkParamVO.setApi_ver(saoBeiProperties.getApiVer());
        JSONObject obj = ApiUtil.convertRequest(saobeiCenterlinkParamVO, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("请求扫呗会员中心报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getCenterServerUrl() + saoBeiProperties.getCenterPath(), jsonString, 8000, "application/json", "utf-8");
        log.info("扫呗会员中心返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiCenterlinkRespVO.class);
        if (SaoBeiConstant.SUCCESS_CODE.equals(response.getReturn_code())) {
            // 由于无法确定正确的getter方法，返回成功状态
            return response.getAccount_center_url();
        }
        String errorMsg = response.getReturn_msg();
        log.error("扫呗会员中心调用失败，原因：{}", errorMsg);
        throw new BusinessException(errorMsg);
    }

    @Override
    public String getBalance(String accountNo) throws Exception {
        SaobeiQueryBalanceRequest saobeiQueryBalanceRequest = new SaobeiQueryBalanceRequest();
        saobeiQueryBalanceRequest.setAccount_no(accountNo);
        saobeiQueryBalanceRequest.setInst_no(saoBeiProperties.getInstNo());
        saobeiQueryBalanceRequest.setApi_ver("102");
        saobeiQueryBalanceRequest.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(saobeiQueryBalanceRequest, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗查询CBK账户余额报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAccountBalancePath(), jsonString, 2000, "application/json", "utf-8");
        log.info("扫呗查询CBK账户余额返回报文: {}", responseStr);
        var response = JSON.parseObject(responseStr, SaobeiBalanceDetailVO.class);
        if (response == null) {
            throw new BusinessException("查询CBK账户余额响应为空");
        }
        if (SaoBeiConstant.SUCCESS_CODE.equals(response.getReturn_code())) {
            // 由于无法确定正确的getter方法，返回成功状态
            String available = response.getAvailable_bal() == null ? "0.00" : response.getAvailable_bal();
            String recharge = response.getRecharge_dedicated_amt() == null ? "0.00" : response.getRecharge_dedicated_amt();
            return new BigDecimal(available).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP)
                    .add(new BigDecimal(recharge).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP))
                    .toString();
        }
        String errorMsg = response.getReturn_msg();
        log.error("扫呗查询CBK账户余额调用失败，原因：{}", errorMsg);
        return "0.00";
    }

    @Override
    public SaobeiDoTransResponse dotrans(SaobeiDoTransRequest request) throws Exception {
        request.setApi_ver(saoBeiProperties.getApiVer());
        request.setInst_no(saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest(request, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗CBK余额分账报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAccountTransPath(), jsonString, 2000, "application/json", "utf-8");
        log.info("扫呗CBK余额分账返回报文: {}", responseStr);
        return JSON.parseObject(responseStr, SaobeiDoTransResponse.class);
    }

    @Override
    public SaobeiTransRespVO doAlltrans(SaobeiDoTransRequestParam request) throws Exception {
        request.setApi_ver(saoBeiProperties.getApiVer());
        request.setInst_no(saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        if (Strings.isNotBlank(saoBeiProperties.getSceneNo())) {
            request.setScene_no(saoBeiProperties.getSceneNo());
        }
        JSONObject obj = ApiUtil.convertRequest(request, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("扫呗CBK余额分账报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getAccountTransPath(), jsonString, 2000, "application/json", "utf-8");
        log.info("扫呗CBK余额分账返回报文: {}", responseStr);
        return JSON.parseObject(responseStr, SaobeiTransRespVO.class);
    }

    @Override
    public SaobeiQueryOrderResponse queryOrder(SaobeiQueryOrderRequest request) throws Exception {
        request.setApi_ver(saoBeiProperties.getApiVer());
        request.setInst_no(saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        // 3. 发送请求
        JSONObject obj = ApiUtil.convertRequest(request, saoBeiProperties.getInstkey(), "key");
        String jsonString = JSON.toJSONString(obj);
        log.info("分账详情信息查询报文:{}", jsonString);
        String responseStr = HttpClientUtil.post(saoBeiProperties.getMchServerUrl() + saoBeiProperties.getQueryOrderPath(), jsonString, 2000, "application/json", "utf-8");
        log.info("分账详情信息查询返回报文: {}", responseStr);
        return JSON.parseObject(responseStr, SaobeiQueryOrderResponse.class);
    }

    @Override
    public boolean existFailTransByRootDocNo(String rootDocNo) {
        boolean failFlag = true;
        failFlag = creditAccountFlowRepo.existsByRootDocNoAndSyncStatusIn(rootDocNo, FinConstant.SAO_BEI_TRANS_UNFINISHED);
        if (failFlag) {
            return failFlag;
        }
        failFlag = accountFlowRepo.existsByRootDocNoAndSyncStatusIn(rootDocNo, FinConstant.SAO_BEI_TRANS_UNFINISHED);
        return failFlag;
    }
}
