package com.elitesland.fin.domain.entity.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "aging_range_dtl")
@org.hibernate.annotations.Table(appliesTo = "aging_range_dtl", comment = "账龄区间设置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class AgingRangeDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2747506305451556191L;

    @Comment("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20)")
    private Long masId;

    @Comment("行号")
    @Column(name = "line_no", columnDefinition = "int(10)")
    private Integer lineNo;

    @Comment("账期描述")
    @Column(name = "payment_period_desc", columnDefinition = "varchar(200)")
    private String paymentPeriodDesc;

    @Comment("账期开始")
    @Column(name = "payment_period_begin", columnDefinition = "int(11)")
    private Integer paymentPeriodBegin;

    @Comment("账期结束")
    @Column(name = "payment_period_end", columnDefinition = "int(11)")
    private Integer paymentPeriodEnd;

    @Comment("账期总数")
    @Column(name = "total_period", columnDefinition = "int(11)")
    private Integer totalPeriod;


}
