package com.elitesland.fin.application.facade.vo.aptype;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.aptypeou
 * @date 2022/3/14 16:55
 */
@Data
public class ApTypeOuVO implements Serializable {

    private static final long serialVersionUID = -5949088978608780114L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "应付单类型定义ID")
    private Long apTypeId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    @ApiModelProperty("公司类型[UDC]ORG:OU_TYPE")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE")
    private String ouType;
    private String ouTypeName;
}
