package com.elitesland.fin.application.service.accountingengine;

import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinSetOfBookLineServiceImpl implements FinSetOfBookLineService {

    private final FinSetOfBookLineRepo finSetOfBookLineRepo;


    @Override
    public List<FinSetOfBookLineDTO> findByMasId(long masId) {
        List<FinSetOfBookLineDO> finSetOfBookLineDOS = finSetOfBookLineRepo.findAllByMasId(masId);
        if(CollectionUtils.isEmpty(finSetOfBookLineDOS)){
            return null;
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOS = FinSetOfBookLineConvert.INSTANCE.DOToDTO(finSetOfBookLineDOS);
        return finSetOfBookLineDTOS;
    }

    @Override
    public List<FinSetOfBookLineDTO> findByMasIds(List<Long> masIds) {
        List<FinSetOfBookLineDO> finSetOfBookLineDOS = finSetOfBookLineRepo.findAllByMasIdIn(masIds);
        if(CollectionUtils.isEmpty(finSetOfBookLineDOS)){
            return null;
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOS = FinSetOfBookLineConvert.INSTANCE.DOToDTO(finSetOfBookLineDOS);
        return finSetOfBookLineDTOS;
    }
}
