package com.elitesland.fin.application.facade.vo.push;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/27 周日
 */
@Getter
@Setter
public class FinPushResultVO implements Serializable {
    private static final long serialVersionUID = 7973769004920159922L;

    @ApiModelProperty("单据ID")
    private Long docId;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("接口编码")
    private String interCode;

    @ApiModelProperty("推送状态, [UDC]yst-supp:PUSH_RESULT")
    private String pushResult;
    private String pushResultName;

    @ApiModelProperty("首次推送时间")
    private LocalDateTime pushTimeFirst;

    @ApiModelProperty("最近推送时间")
    private LocalDateTime pushTimeLast;

    @ApiModelProperty("推送失败原因")
    private String failReason;

    @ApiModelProperty("推送记录ID")
    private Long pushRecordId;
}
