package com.elitesland.fin.application.service.invoice.impl;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.repo.invoice.InvoiceDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
public class InvoiceDtlDomainServiceImpl implements InvoiceDtlDomainService {

    public final InvoiceDtlRepoProc invoiceDtlRepoProc;

    @Override
    public List<SaleInvDtlDTO> getList(Long masId) {
        // 通过invoiceDtlRepoProc的getList方法，查询并返回指定masId的销售明细列表
        return invoiceDtlRepoProc.getList(masId);
    }

    @Override
    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        return invoiceDtlRepoProc.dtlPage(saleInvDtlPageParam);
    }
}
