/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.entity.aporder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApOrder {
    @ApiModelProperty(value="\u5185\u5916\u90e8\u5ba2\u6237(\u4f9b\u5e94\u5546\u7684\u5185\u5916\u90e8)")
    private String inOutCust;
    private Long id;
    private String sourceNo;
    private String apOrderNo;
    private String ouCode;
    private Long ouId;
    private String ouName;
    private String createMode;
    private Long apTypeId;
    private String apTypeName;
    private String apTypeCode;
    private String orderState;
    private LocalDateTime buDate;
    private BigDecimal totalAmt;
    private BigDecimal exclTaxAmt;
    private BigDecimal taxAmt;
    private BigDecimal totalCurAmt;
    private BigDecimal exclTaxCurAmt;
    private BigDecimal taxCurAmt;
    private String currCode;
    private String currName;
    private Long auditUserId;
    private String auditUser;
    private LocalDateTime auditDate;
    private BigDecimal exchangeRate;
    private Long operUserId;
    private String operator;
    private Boolean taxFlag;
    private Boolean initFlag;
    private String auditRejection;
    private Long suppId;
    private String suppCode;
    private String suppName;
    private Long buId;
    private String buCode;
    private String buName;
    private String buType;
    private String payMentName;
    private String payMentId;
    private String payMentCode;
    private String localCurrCode;
    private String localCurrName;
    private BigDecimal taxRate;
    private String remark;
    private List<ApOrderDtl> apOrderDtlList;
    private List<ApOrderDtlGroup> apOrderDtlGroupList;
    private String verState;
    private BigDecimal verAmt;
    private String creator;
    private Integer auditDataVersion;
    private String procInstId;
    private ProcInstStatus procInstStatus;
    private LocalDateTime submitTime;
    private LocalDateTime approvedTime;
    private String addrNo;
    private String suppAddrNo;
    @ApiModelProperty(value="\u7ea2\u51b2\u72b6\u6001")
    private Boolean redState;
    @ApiModelProperty(value="\u7ea2\u51b2\u6765\u6e90")
    private String redSourceNo;
    @ApiModelProperty(value="\u7ea2\u51b2\u6765\u6e90")
    private Long redSourceId;
    private String proposedStatus;
    private Boolean check = Boolean.TRUE;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long createUserId;
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4")
    private LocalDateTime createTime;
    @ApiModelProperty(value="\u4ed8\u6b3e\u534f\u8bae\u7f16\u7801")
    private String protocolCode;
    @ApiModelProperty(value="\u4ed8\u6b3e\u534f\u8bae\u540d\u79f0")
    private String protocolName;
    @ApiModelProperty(value="\u5173\u8054\u516c\u53f8\u7f16\u7801")
    private String relevanceOuCode;
    @ApiModelProperty(value="\u6269\u5c55\u4fe1\u606f\u5b57\u6bb5")
    private Map<String, String> extensionInfo;

    public void check() {
        if (!this.check.booleanValue()) {
            return;
        }
        if (this.createMode.equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            Assert.notNull((Object)this.apTypeId, (String)"\u5e94\u4ed8\u5355\u7c7b\u578b apTypeId is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.apTypeCode, (String)"\u5e94\u4ed8\u5355\u7c7b\u578b apTypeCode is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.apTypeName, (String)"\u5e94\u4ed8\u5355\u7c7b\u578b apTypeName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.totalAmt, (String)"\u542b\u7a0e\u91d1\u989d totalAmt is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.totalCurAmt, (String)"\u542b\u7a0e\u91d1\u989d totalCurAmt is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.exclTaxAmt, (String)"\u4e0d\u542b\u7a0e\u91d1\u989d exclTaxAmt is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.exclTaxCurAmt, (String)"\u4e0d\u542b\u7a0e\u91d1\u989d exclTaxCurAmt is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.currName, (String)"\u5e01\u79cd currName is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.currCode, (String)"\u5e01\u79cd currCode is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.suppId, (String)"\u4f9b\u5e94\u5546 suppId is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.suppCode, (String)"\u4f9b\u5e94\u5546 suppCode is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.suppName, (String)"\u4f9b\u5e94\u5546 suppName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.ouId, (String)"\u516c\u53f8 ouId is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.ouCode, (String)"\u516c\u53f8 ouCode is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.ouName, (String)"\u516c\u53f8 ouName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.buDate, (String)"\u4e1a\u52a1\u65e5\u671f buDate is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.protocolCode, (String)"\u4ed8\u6b3e\u534f\u8bae protocolCode is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.exchangeRate, (String)"\u6c47\u7387 exchangeRate is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.localCurrCode, (String)"\u672c\u4f4d\u5e01 localCurrCode is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.localCurrName, (String)"\u672c\u4f4d\u5e01 localCurrName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.taxAmt, (String)"\u7a0e\u989d taxAmt is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.taxCurAmt, (String)"\u7a0e\u989d(\u672c\u4f4d\u5e01) taxCurAmt is null", (Object[])new Object[0]);
        }
        if (this.createMode.equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            Assert.notEmpty((CharSequence)this.currName, (String)"\u5e01\u79cd currName is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.currCode, (String)"\u5e01\u79cd currCode is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.suppId, (String)"\u4f9b\u5e94\u5546 suppId is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.suppCode, (String)"\u4f9b\u5e94\u5546 suppCode is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.suppName, (String)"\u4f9b\u5e94\u5546 suppName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.ouId, (String)"\u516c\u53f8 ouId is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.ouCode, (String)"\u516c\u53f8 ouCode is null", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.ouName, (String)"\u516c\u53f8 ouName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.buDate, (String)"\u4e1a\u52a1\u65e5\u671f buDate is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.localCurrCode, (String)"\u672c\u4f4d\u5e01 localCurrCode is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.localCurrName, (String)"\u672c\u4f4d\u5e01 localCurrName is null", (Object[])new Object[0]);
            Assert.notNull((Object)this.exchangeRate, (String)"\u6c47\u7387 exchangeRate is null", (Object[])new Object[0]);
        }
    }

    public void checkDtlList() {
        if (!this.check.booleanValue()) {
            return;
        }
        Assert.notNull(this.apOrderDtlList, (String)"apOrderDtlList is null", (Object[])new Object[0]);
        this.apOrderDtlList.stream().forEach(x -> x.check(this.createMode));
        if (this.createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            Assert.notNull(this.apOrderDtlGroupList, (String)"apOrderDtlGroupList is null", (Object[])new Object[0]);
            this.apOrderDtlGroupList.stream().forEach(x -> x.check(this.createMode));
        }
    }

    public void checkAmt() {
        if (!this.check.booleanValue()) {
            return;
        }
        Assert.notNull((Object)this.exchangeRate, (String)"\u6c47\u7387exchangeRate\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.count();
    }

    private void count() {
        for (ApOrderDtl apOrderDtl : this.apOrderDtlList) {
            Assert.notNull((Object)apOrderDtl.getTaxRate(), (String)"taxRate\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)apOrderDtl.getQty(), (String)"qty\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)apOrderDtl.getExclTaxPrice(), (String)"exclTaxPrice\u5355\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)apOrderDtl.getPrice(), (String)"price\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.taxRate = apOrderDtl.getTaxRate();
            BigDecimal qty = apOrderDtl.getQty();
            BigDecimal exclTaxPrice = apOrderDtl.getExclTaxPrice();
            BigDecimal countPrice = apOrderDtl.getPrice();
            this.taxCount(apOrderDtl, qty, exclTaxPrice, countPrice);
        }
    }

    public void dtlAssign() {
        if (this.createMode.equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            this.apOrderDtlList.stream().forEach(x -> {
                if (StringUtils.isBlank((CharSequence)x.getProtocolCode())) {
                    x.setProtocolCode(this.protocolCode);
                }
            });
        }
    }

    private void taxCount(ApOrderDtl apOrderDtl, BigDecimal qty, BigDecimal exclTaxPrice, BigDecimal countPrice) {
        if (this.taxFlag.booleanValue()) {
            exclTaxPrice = countPrice.divide(this.taxRate.add(new BigDecimal(1)), 2, RoundingMode.HALF_UP);
        } else {
            countPrice = exclTaxPrice.multiply(this.taxRate.add(new BigDecimal(1))).setScale(2, RoundingMode.HALF_UP);
        }
        BigDecimal countExclTaxAmt = exclTaxPrice.multiply(qty).setScale(2, RoundingMode.HALF_UP);
        BigDecimal countTaxAmt = countExclTaxAmt.multiply(this.taxRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal countTotalAmt = countExclTaxAmt.add(countTaxAmt).setScale(2, RoundingMode.HALF_UP);
        BigDecimal countExclTaxCurAmt = countExclTaxAmt.multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal countTaxCurAmt = countTaxAmt.multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
    }

    public void countByPacck() {
        BigDecimal totalCurAmtSum;
        BigDecimal totalAmtSum;
        BigDecimal exclTaxCurAmtSum;
        BigDecimal exclTaxAmtSum;
        BigDecimal taxCurAmtSum;
        BigDecimal taxAmtSum;
        for (ApOrderDtl apOrderDtl : this.apOrderDtlList) {
            Assert.notNull((Object)apOrderDtl.getTaxRate(), (String)"taxRate\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)apOrderDtl.getQty(), (String)"qty\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)apOrderDtl.getExclTaxPrice(), (String)"exclTaxPrice\u5355\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            BigDecimal countTaxCurAmt = apOrderDtl.getTaxAmt().multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setTaxCurAmt(countTaxCurAmt);
            BigDecimal countExclTaxCurAmt = apOrderDtl.getExclTaxAmt().multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setExclTaxCurAmt(countExclTaxCurAmt);
            BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            apOrderDtl.setTotalCurAmt(countTotalCurAmt);
        }
        this.taxAmt = taxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.taxCurAmt = taxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxAmt = exclTaxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxCurAmt = exclTaxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalAmt = totalAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalCurAmt = totalCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
    }

    public void checkAmtSum() {
        if (!this.check.booleanValue()) {
            return;
        }
        BigDecimal qtySum = this.apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal taxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal taxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal exclTaxAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal exclTaxCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalCurAmtSum = this.apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        if (this.totalAmt.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u5355\u5934\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49!");
        }
        if (this.totalCurAmt.compareTo(totalCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u5355\u5934\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u76f8\u7b49!");
        }
        if (this.exclTaxAmt.compareTo(exclTaxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u5355\u5934\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49!");
        }
        if (this.exclTaxCurAmt.compareTo(exclTaxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u5355\u5934\u4e0d\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u76f8\u7b49!");
        }
        if (this.taxAmt.compareTo(taxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d\u4e4b\u548c\u4e0e\u5355\u5934\u7a0e\u989d\u4e0d\u76f8\u7b49!");
        }
        if (this.taxCurAmt.compareTo(taxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u5355\u5934\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e0d\u76f8\u7b49!");
        }
        BigDecimal qtyGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getQty).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal taxAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal taxCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal exclTaxAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal exclTaxCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalCurAmtGroSum = this.apOrderDtlGroupList.stream().map(ApOrderDtlGroup::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        if (qtyGroSum.compareTo(qtySum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u6570\u91cf\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u6570\u91cf\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (totalAmtGroSum.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (totalCurAmtGroSum.compareTo(totalCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (exclTaxAmtGroSum.compareTo(exclTaxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (exclTaxCurAmtGroSum.compareTo(exclTaxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u4e0d\u542b\u7a0e\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (taxAmtGroSum.compareTo(taxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u7a0e\u989d\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
        if (taxCurAmtGroSum.compareTo(taxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0e\u6c47\u603b\u884c\u7a0e\u989d(\u672c\u4f4d\u5e01)\u4e4b\u548c\u4e0d\u76f8\u7b49!");
        }
    }

    public void checkUpdate() {
        if (!this.check.booleanValue()) {
            return;
        }
        Assert.notNull((Object)this.id, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public void setDef() {
        this.verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        this.verAmt = new BigDecimal("0");
    }

    public void setPacckDef() {
        this.taxFlag = true;
        this.initFlag = false;
    }

    public String getInOutCust() {
        return this.inOutCust;
    }

    public Long getId() {
        return this.id;
    }

    public String getSourceNo() {
        return this.sourceNo;
    }

    public String getApOrderNo() {
        return this.apOrderNo;
    }

    public String getOuCode() {
        return this.ouCode;
    }

    public Long getOuId() {
        return this.ouId;
    }

    public String getOuName() {
        return this.ouName;
    }

    public String getCreateMode() {
        return this.createMode;
    }

    public Long getApTypeId() {
        return this.apTypeId;
    }

    public String getApTypeName() {
        return this.apTypeName;
    }

    public String getApTypeCode() {
        return this.apTypeCode;
    }

    public String getOrderState() {
        return this.orderState;
    }

    public LocalDateTime getBuDate() {
        return this.buDate;
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public BigDecimal getExclTaxAmt() {
        return this.exclTaxAmt;
    }

    public BigDecimal getTaxAmt() {
        return this.taxAmt;
    }

    public BigDecimal getTotalCurAmt() {
        return this.totalCurAmt;
    }

    public BigDecimal getExclTaxCurAmt() {
        return this.exclTaxCurAmt;
    }

    public BigDecimal getTaxCurAmt() {
        return this.taxCurAmt;
    }

    public String getCurrCode() {
        return this.currCode;
    }

    public String getCurrName() {
        return this.currName;
    }

    public Long getAuditUserId() {
        return this.auditUserId;
    }

    public String getAuditUser() {
        return this.auditUser;
    }

    public LocalDateTime getAuditDate() {
        return this.auditDate;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public Long getOperUserId() {
        return this.operUserId;
    }

    public String getOperator() {
        return this.operator;
    }

    public Boolean getTaxFlag() {
        return this.taxFlag;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public String getAuditRejection() {
        return this.auditRejection;
    }

    public Long getSuppId() {
        return this.suppId;
    }

    public String getSuppCode() {
        return this.suppCode;
    }

    public String getSuppName() {
        return this.suppName;
    }

    public Long getBuId() {
        return this.buId;
    }

    public String getBuCode() {
        return this.buCode;
    }

    public String getBuName() {
        return this.buName;
    }

    public String getBuType() {
        return this.buType;
    }

    public String getPayMentName() {
        return this.payMentName;
    }

    public String getPayMentId() {
        return this.payMentId;
    }

    public String getPayMentCode() {
        return this.payMentCode;
    }

    public String getLocalCurrCode() {
        return this.localCurrCode;
    }

    public String getLocalCurrName() {
        return this.localCurrName;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<ApOrderDtl> getApOrderDtlList() {
        return this.apOrderDtlList;
    }

    public List<ApOrderDtlGroup> getApOrderDtlGroupList() {
        return this.apOrderDtlGroupList;
    }

    public String getVerState() {
        return this.verState;
    }

    public BigDecimal getVerAmt() {
        return this.verAmt;
    }

    public String getCreator() {
        return this.creator;
    }

    public Integer getAuditDataVersion() {
        return this.auditDataVersion;
    }

    public String getProcInstId() {
        return this.procInstId;
    }

    public ProcInstStatus getProcInstStatus() {
        return this.procInstStatus;
    }

    public LocalDateTime getSubmitTime() {
        return this.submitTime;
    }

    public LocalDateTime getApprovedTime() {
        return this.approvedTime;
    }

    public String getAddrNo() {
        return this.addrNo;
    }

    public String getSuppAddrNo() {
        return this.suppAddrNo;
    }

    public Boolean getRedState() {
        return this.redState;
    }

    public String getRedSourceNo() {
        return this.redSourceNo;
    }

    public Long getRedSourceId() {
        return this.redSourceId;
    }

    public String getProposedStatus() {
        return this.proposedStatus;
    }

    public Boolean getCheck() {
        return this.check;
    }

    public Long getCreateUserId() {
        return this.createUserId;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getProtocolCode() {
        return this.protocolCode;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getRelevanceOuCode() {
        return this.relevanceOuCode;
    }

    public Map<String, String> getExtensionInfo() {
        return this.extensionInfo;
    }

    public void setInOutCust(String inOutCust) {
        this.inOutCust = inOutCust;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public void setApOrderNo(String apOrderNo) {
        this.apOrderNo = apOrderNo;
    }

    public void setOuCode(String ouCode) {
        this.ouCode = ouCode;
    }

    public void setOuId(Long ouId) {
        this.ouId = ouId;
    }

    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public void setCreateMode(String createMode) {
        this.createMode = createMode;
    }

    public void setApTypeId(Long apTypeId) {
        this.apTypeId = apTypeId;
    }

    public void setApTypeName(String apTypeName) {
        this.apTypeName = apTypeName;
    }

    public void setApTypeCode(String apTypeCode) {
        this.apTypeCode = apTypeCode;
    }

    public void setOrderState(String orderState) {
        this.orderState = orderState;
    }

    public void setBuDate(LocalDateTime buDate) {
        this.buDate = buDate;
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
    }

    public void setExclTaxAmt(BigDecimal exclTaxAmt) {
        this.exclTaxAmt = exclTaxAmt;
    }

    public void setTaxAmt(BigDecimal taxAmt) {
        this.taxAmt = taxAmt;
    }

    public void setTotalCurAmt(BigDecimal totalCurAmt) {
        this.totalCurAmt = totalCurAmt;
    }

    public void setExclTaxCurAmt(BigDecimal exclTaxCurAmt) {
        this.exclTaxCurAmt = exclTaxCurAmt;
    }

    public void setTaxCurAmt(BigDecimal taxCurAmt) {
        this.taxCurAmt = taxCurAmt;
    }

    public void setCurrCode(String currCode) {
        this.currCode = currCode;
    }

    public void setCurrName(String currName) {
        this.currName = currName;
    }

    public void setAuditUserId(Long auditUserId) {
        this.auditUserId = auditUserId;
    }

    public void setAuditUser(String auditUser) {
        this.auditUser = auditUser;
    }

    public void setAuditDate(LocalDateTime auditDate) {
        this.auditDate = auditDate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public void setOperUserId(Long operUserId) {
        this.operUserId = operUserId;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setTaxFlag(Boolean taxFlag) {
        this.taxFlag = taxFlag;
    }

    public void setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
    }

    public void setAuditRejection(String auditRejection) {
        this.auditRejection = auditRejection;
    }

    public void setSuppId(Long suppId) {
        this.suppId = suppId;
    }

    public void setSuppCode(String suppCode) {
        this.suppCode = suppCode;
    }

    public void setSuppName(String suppName) {
        this.suppName = suppName;
    }

    public void setBuId(Long buId) {
        this.buId = buId;
    }

    public void setBuCode(String buCode) {
        this.buCode = buCode;
    }

    public void setBuName(String buName) {
        this.buName = buName;
    }

    public void setBuType(String buType) {
        this.buType = buType;
    }

    public void setPayMentName(String payMentName) {
        this.payMentName = payMentName;
    }

    public void setPayMentId(String payMentId) {
        this.payMentId = payMentId;
    }

    public void setPayMentCode(String payMentCode) {
        this.payMentCode = payMentCode;
    }

    public void setLocalCurrCode(String localCurrCode) {
        this.localCurrCode = localCurrCode;
    }

    public void setLocalCurrName(String localCurrName) {
        this.localCurrName = localCurrName;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setApOrderDtlList(List<ApOrderDtl> apOrderDtlList) {
        this.apOrderDtlList = apOrderDtlList;
    }

    public void setApOrderDtlGroupList(List<ApOrderDtlGroup> apOrderDtlGroupList) {
        this.apOrderDtlGroupList = apOrderDtlGroupList;
    }

    public void setVerState(String verState) {
        this.verState = verState;
    }

    public void setVerAmt(BigDecimal verAmt) {
        this.verAmt = verAmt;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setAuditDataVersion(Integer auditDataVersion) {
        this.auditDataVersion = auditDataVersion;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    public void setProcInstStatus(ProcInstStatus procInstStatus) {
        this.procInstStatus = procInstStatus;
    }

    public void setSubmitTime(LocalDateTime submitTime) {
        this.submitTime = submitTime;
    }

    public void setApprovedTime(LocalDateTime approvedTime) {
        this.approvedTime = approvedTime;
    }

    public void setAddrNo(String addrNo) {
        this.addrNo = addrNo;
    }

    public void setSuppAddrNo(String suppAddrNo) {
        this.suppAddrNo = suppAddrNo;
    }

    public void setRedState(Boolean redState) {
        this.redState = redState;
    }

    public void setRedSourceNo(String redSourceNo) {
        this.redSourceNo = redSourceNo;
    }

    public void setRedSourceId(Long redSourceId) {
        this.redSourceId = redSourceId;
    }

    public void setProposedStatus(String proposedStatus) {
        this.proposedStatus = proposedStatus;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setProtocolCode(String protocolCode) {
        this.protocolCode = protocolCode;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setRelevanceOuCode(String relevanceOuCode) {
        this.relevanceOuCode = relevanceOuCode;
    }

    public void setExtensionInfo(Map<String, String> extensionInfo) {
        this.extensionInfo = extensionInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApOrder)) {
            return false;
        }
        ApOrder other = (ApOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ouId = this.getOuId();
        Long other$ouId = other.getOuId();
        if (this$ouId == null ? other$ouId != null : !((Object)this$ouId).equals(other$ouId)) {
            return false;
        }
        Long this$apTypeId = this.getApTypeId();
        Long other$apTypeId = other.getApTypeId();
        if (this$apTypeId == null ? other$apTypeId != null : !((Object)this$apTypeId).equals(other$apTypeId)) {
            return false;
        }
        Long this$auditUserId = this.getAuditUserId();
        Long other$auditUserId = other.getAuditUserId();
        if (this$auditUserId == null ? other$auditUserId != null : !((Object)this$auditUserId).equals(other$auditUserId)) {
            return false;
        }
        Long this$operUserId = this.getOperUserId();
        Long other$operUserId = other.getOperUserId();
        if (this$operUserId == null ? other$operUserId != null : !((Object)this$operUserId).equals(other$operUserId)) {
            return false;
        }
        Boolean this$taxFlag = this.getTaxFlag();
        Boolean other$taxFlag = other.getTaxFlag();
        if (this$taxFlag == null ? other$taxFlag != null : !((Object)this$taxFlag).equals(other$taxFlag)) {
            return false;
        }
        Boolean this$initFlag = this.getInitFlag();
        Boolean other$initFlag = other.getInitFlag();
        if (this$initFlag == null ? other$initFlag != null : !((Object)this$initFlag).equals(other$initFlag)) {
            return false;
        }
        Long this$suppId = this.getSuppId();
        Long other$suppId = other.getSuppId();
        if (this$suppId == null ? other$suppId != null : !((Object)this$suppId).equals(other$suppId)) {
            return false;
        }
        Long this$buId = this.getBuId();
        Long other$buId = other.getBuId();
        if (this$buId == null ? other$buId != null : !((Object)this$buId).equals(other$buId)) {
            return false;
        }
        Integer this$auditDataVersion = this.getAuditDataVersion();
        Integer other$auditDataVersion = other.getAuditDataVersion();
        if (this$auditDataVersion == null ? other$auditDataVersion != null : !((Object)this$auditDataVersion).equals(other$auditDataVersion)) {
            return false;
        }
        Boolean this$redState = this.getRedState();
        Boolean other$redState = other.getRedState();
        if (this$redState == null ? other$redState != null : !((Object)this$redState).equals(other$redState)) {
            return false;
        }
        Long this$redSourceId = this.getRedSourceId();
        Long other$redSourceId = other.getRedSourceId();
        if (this$redSourceId == null ? other$redSourceId != null : !((Object)this$redSourceId).equals(other$redSourceId)) {
            return false;
        }
        Boolean this$check = this.getCheck();
        Boolean other$check = other.getCheck();
        if (this$check == null ? other$check != null : !((Object)this$check).equals(other$check)) {
            return false;
        }
        Long this$createUserId = this.getCreateUserId();
        Long other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !((Object)this$createUserId).equals(other$createUserId)) {
            return false;
        }
        String this$inOutCust = this.getInOutCust();
        String other$inOutCust = other.getInOutCust();
        if (this$inOutCust == null ? other$inOutCust != null : !this$inOutCust.equals(other$inOutCust)) {
            return false;
        }
        String this$sourceNo = this.getSourceNo();
        String other$sourceNo = other.getSourceNo();
        if (this$sourceNo == null ? other$sourceNo != null : !this$sourceNo.equals(other$sourceNo)) {
            return false;
        }
        String this$apOrderNo = this.getApOrderNo();
        String other$apOrderNo = other.getApOrderNo();
        if (this$apOrderNo == null ? other$apOrderNo != null : !this$apOrderNo.equals(other$apOrderNo)) {
            return false;
        }
        String this$ouCode = this.getOuCode();
        String other$ouCode = other.getOuCode();
        if (this$ouCode == null ? other$ouCode != null : !this$ouCode.equals(other$ouCode)) {
            return false;
        }
        String this$ouName = this.getOuName();
        String other$ouName = other.getOuName();
        if (this$ouName == null ? other$ouName != null : !this$ouName.equals(other$ouName)) {
            return false;
        }
        String this$createMode = this.getCreateMode();
        String other$createMode = other.getCreateMode();
        if (this$createMode == null ? other$createMode != null : !this$createMode.equals(other$createMode)) {
            return false;
        }
        String this$apTypeName = this.getApTypeName();
        String other$apTypeName = other.getApTypeName();
        if (this$apTypeName == null ? other$apTypeName != null : !this$apTypeName.equals(other$apTypeName)) {
            return false;
        }
        String this$apTypeCode = this.getApTypeCode();
        String other$apTypeCode = other.getApTypeCode();
        if (this$apTypeCode == null ? other$apTypeCode != null : !this$apTypeCode.equals(other$apTypeCode)) {
            return false;
        }
        String this$orderState = this.getOrderState();
        String other$orderState = other.getOrderState();
        if (this$orderState == null ? other$orderState != null : !this$orderState.equals(other$orderState)) {
            return false;
        }
        LocalDateTime this$buDate = this.getBuDate();
        LocalDateTime other$buDate = other.getBuDate();
        if (this$buDate == null ? other$buDate != null : !((Object)this$buDate).equals(other$buDate)) {
            return false;
        }
        BigDecimal this$totalAmt = this.getTotalAmt();
        BigDecimal other$totalAmt = other.getTotalAmt();
        if (this$totalAmt == null ? other$totalAmt != null : !((Object)this$totalAmt).equals(other$totalAmt)) {
            return false;
        }
        BigDecimal this$exclTaxAmt = this.getExclTaxAmt();
        BigDecimal other$exclTaxAmt = other.getExclTaxAmt();
        if (this$exclTaxAmt == null ? other$exclTaxAmt != null : !((Object)this$exclTaxAmt).equals(other$exclTaxAmt)) {
            return false;
        }
        BigDecimal this$taxAmt = this.getTaxAmt();
        BigDecimal other$taxAmt = other.getTaxAmt();
        if (this$taxAmt == null ? other$taxAmt != null : !((Object)this$taxAmt).equals(other$taxAmt)) {
            return false;
        }
        BigDecimal this$totalCurAmt = this.getTotalCurAmt();
        BigDecimal other$totalCurAmt = other.getTotalCurAmt();
        if (this$totalCurAmt == null ? other$totalCurAmt != null : !((Object)this$totalCurAmt).equals(other$totalCurAmt)) {
            return false;
        }
        BigDecimal this$exclTaxCurAmt = this.getExclTaxCurAmt();
        BigDecimal other$exclTaxCurAmt = other.getExclTaxCurAmt();
        if (this$exclTaxCurAmt == null ? other$exclTaxCurAmt != null : !((Object)this$exclTaxCurAmt).equals(other$exclTaxCurAmt)) {
            return false;
        }
        BigDecimal this$taxCurAmt = this.getTaxCurAmt();
        BigDecimal other$taxCurAmt = other.getTaxCurAmt();
        if (this$taxCurAmt == null ? other$taxCurAmt != null : !((Object)this$taxCurAmt).equals(other$taxCurAmt)) {
            return false;
        }
        String this$currCode = this.getCurrCode();
        String other$currCode = other.getCurrCode();
        if (this$currCode == null ? other$currCode != null : !this$currCode.equals(other$currCode)) {
            return false;
        }
        String this$currName = this.getCurrName();
        String other$currName = other.getCurrName();
        if (this$currName == null ? other$currName != null : !this$currName.equals(other$currName)) {
            return false;
        }
        String this$auditUser = this.getAuditUser();
        String other$auditUser = other.getAuditUser();
        if (this$auditUser == null ? other$auditUser != null : !this$auditUser.equals(other$auditUser)) {
            return false;
        }
        LocalDateTime this$auditDate = this.getAuditDate();
        LocalDateTime other$auditDate = other.getAuditDate();
        if (this$auditDate == null ? other$auditDate != null : !((Object)this$auditDate).equals(other$auditDate)) {
            return false;
        }
        BigDecimal this$exchangeRate = this.getExchangeRate();
        BigDecimal other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$auditRejection = this.getAuditRejection();
        String other$auditRejection = other.getAuditRejection();
        if (this$auditRejection == null ? other$auditRejection != null : !this$auditRejection.equals(other$auditRejection)) {
            return false;
        }
        String this$suppCode = this.getSuppCode();
        String other$suppCode = other.getSuppCode();
        if (this$suppCode == null ? other$suppCode != null : !this$suppCode.equals(other$suppCode)) {
            return false;
        }
        String this$suppName = this.getSuppName();
        String other$suppName = other.getSuppName();
        if (this$suppName == null ? other$suppName != null : !this$suppName.equals(other$suppName)) {
            return false;
        }
        String this$buCode = this.getBuCode();
        String other$buCode = other.getBuCode();
        if (this$buCode == null ? other$buCode != null : !this$buCode.equals(other$buCode)) {
            return false;
        }
        String this$buName = this.getBuName();
        String other$buName = other.getBuName();
        if (this$buName == null ? other$buName != null : !this$buName.equals(other$buName)) {
            return false;
        }
        String this$buType = this.getBuType();
        String other$buType = other.getBuType();
        if (this$buType == null ? other$buType != null : !this$buType.equals(other$buType)) {
            return false;
        }
        String this$payMentName = this.getPayMentName();
        String other$payMentName = other.getPayMentName();
        if (this$payMentName == null ? other$payMentName != null : !this$payMentName.equals(other$payMentName)) {
            return false;
        }
        String this$payMentId = this.getPayMentId();
        String other$payMentId = other.getPayMentId();
        if (this$payMentId == null ? other$payMentId != null : !this$payMentId.equals(other$payMentId)) {
            return false;
        }
        String this$payMentCode = this.getPayMentCode();
        String other$payMentCode = other.getPayMentCode();
        if (this$payMentCode == null ? other$payMentCode != null : !this$payMentCode.equals(other$payMentCode)) {
            return false;
        }
        String this$localCurrCode = this.getLocalCurrCode();
        String other$localCurrCode = other.getLocalCurrCode();
        if (this$localCurrCode == null ? other$localCurrCode != null : !this$localCurrCode.equals(other$localCurrCode)) {
            return false;
        }
        String this$localCurrName = this.getLocalCurrName();
        String other$localCurrName = other.getLocalCurrName();
        if (this$localCurrName == null ? other$localCurrName != null : !this$localCurrName.equals(other$localCurrName)) {
            return false;
        }
        BigDecimal this$taxRate = this.getTaxRate();
        BigDecimal other$taxRate = other.getTaxRate();
        if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        List<ApOrderDtl> this$apOrderDtlList = this.getApOrderDtlList();
        List<ApOrderDtl> other$apOrderDtlList = other.getApOrderDtlList();
        if (this$apOrderDtlList == null ? other$apOrderDtlList != null : !((Object)this$apOrderDtlList).equals(other$apOrderDtlList)) {
            return false;
        }
        List<ApOrderDtlGroup> this$apOrderDtlGroupList = this.getApOrderDtlGroupList();
        List<ApOrderDtlGroup> other$apOrderDtlGroupList = other.getApOrderDtlGroupList();
        if (this$apOrderDtlGroupList == null ? other$apOrderDtlGroupList != null : !((Object)this$apOrderDtlGroupList).equals(other$apOrderDtlGroupList)) {
            return false;
        }
        String this$verState = this.getVerState();
        String other$verState = other.getVerState();
        if (this$verState == null ? other$verState != null : !this$verState.equals(other$verState)) {
            return false;
        }
        BigDecimal this$verAmt = this.getVerAmt();
        BigDecimal other$verAmt = other.getVerAmt();
        if (this$verAmt == null ? other$verAmt != null : !((Object)this$verAmt).equals(other$verAmt)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$procInstId = this.getProcInstId();
        String other$procInstId = other.getProcInstId();
        if (this$procInstId == null ? other$procInstId != null : !this$procInstId.equals(other$procInstId)) {
            return false;
        }
        ProcInstStatus this$procInstStatus = this.getProcInstStatus();
        ProcInstStatus other$procInstStatus = other.getProcInstStatus();
        if (this$procInstStatus == null ? other$procInstStatus != null : !this$procInstStatus.equals(other$procInstStatus)) {
            return false;
        }
        LocalDateTime this$submitTime = this.getSubmitTime();
        LocalDateTime other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        LocalDateTime this$approvedTime = this.getApprovedTime();
        LocalDateTime other$approvedTime = other.getApprovedTime();
        if (this$approvedTime == null ? other$approvedTime != null : !((Object)this$approvedTime).equals(other$approvedTime)) {
            return false;
        }
        String this$addrNo = this.getAddrNo();
        String other$addrNo = other.getAddrNo();
        if (this$addrNo == null ? other$addrNo != null : !this$addrNo.equals(other$addrNo)) {
            return false;
        }
        String this$suppAddrNo = this.getSuppAddrNo();
        String other$suppAddrNo = other.getSuppAddrNo();
        if (this$suppAddrNo == null ? other$suppAddrNo != null : !this$suppAddrNo.equals(other$suppAddrNo)) {
            return false;
        }
        String this$redSourceNo = this.getRedSourceNo();
        String other$redSourceNo = other.getRedSourceNo();
        if (this$redSourceNo == null ? other$redSourceNo != null : !this$redSourceNo.equals(other$redSourceNo)) {
            return false;
        }
        String this$proposedStatus = this.getProposedStatus();
        String other$proposedStatus = other.getProposedStatus();
        if (this$proposedStatus == null ? other$proposedStatus != null : !this$proposedStatus.equals(other$proposedStatus)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$protocolCode = this.getProtocolCode();
        String other$protocolCode = other.getProtocolCode();
        if (this$protocolCode == null ? other$protocolCode != null : !this$protocolCode.equals(other$protocolCode)) {
            return false;
        }
        String this$protocolName = this.getProtocolName();
        String other$protocolName = other.getProtocolName();
        if (this$protocolName == null ? other$protocolName != null : !this$protocolName.equals(other$protocolName)) {
            return false;
        }
        String this$relevanceOuCode = this.getRelevanceOuCode();
        String other$relevanceOuCode = other.getRelevanceOuCode();
        if (this$relevanceOuCode == null ? other$relevanceOuCode != null : !this$relevanceOuCode.equals(other$relevanceOuCode)) {
            return false;
        }
        Map<String, String> this$extensionInfo = this.getExtensionInfo();
        Map<String, String> other$extensionInfo = other.getExtensionInfo();
        return !(this$extensionInfo == null ? other$extensionInfo != null : !((Object)this$extensionInfo).equals(other$extensionInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ouId = this.getOuId();
        result = result * 59 + ($ouId == null ? 43 : ((Object)$ouId).hashCode());
        Long $apTypeId = this.getApTypeId();
        result = result * 59 + ($apTypeId == null ? 43 : ((Object)$apTypeId).hashCode());
        Long $auditUserId = this.getAuditUserId();
        result = result * 59 + ($auditUserId == null ? 43 : ((Object)$auditUserId).hashCode());
        Long $operUserId = this.getOperUserId();
        result = result * 59 + ($operUserId == null ? 43 : ((Object)$operUserId).hashCode());
        Boolean $taxFlag = this.getTaxFlag();
        result = result * 59 + ($taxFlag == null ? 43 : ((Object)$taxFlag).hashCode());
        Boolean $initFlag = this.getInitFlag();
        result = result * 59 + ($initFlag == null ? 43 : ((Object)$initFlag).hashCode());
        Long $suppId = this.getSuppId();
        result = result * 59 + ($suppId == null ? 43 : ((Object)$suppId).hashCode());
        Long $buId = this.getBuId();
        result = result * 59 + ($buId == null ? 43 : ((Object)$buId).hashCode());
        Integer $auditDataVersion = this.getAuditDataVersion();
        result = result * 59 + ($auditDataVersion == null ? 43 : ((Object)$auditDataVersion).hashCode());
        Boolean $redState = this.getRedState();
        result = result * 59 + ($redState == null ? 43 : ((Object)$redState).hashCode());
        Long $redSourceId = this.getRedSourceId();
        result = result * 59 + ($redSourceId == null ? 43 : ((Object)$redSourceId).hashCode());
        Boolean $check = this.getCheck();
        result = result * 59 + ($check == null ? 43 : ((Object)$check).hashCode());
        Long $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : ((Object)$createUserId).hashCode());
        String $inOutCust = this.getInOutCust();
        result = result * 59 + ($inOutCust == null ? 43 : $inOutCust.hashCode());
        String $sourceNo = this.getSourceNo();
        result = result * 59 + ($sourceNo == null ? 43 : $sourceNo.hashCode());
        String $apOrderNo = this.getApOrderNo();
        result = result * 59 + ($apOrderNo == null ? 43 : $apOrderNo.hashCode());
        String $ouCode = this.getOuCode();
        result = result * 59 + ($ouCode == null ? 43 : $ouCode.hashCode());
        String $ouName = this.getOuName();
        result = result * 59 + ($ouName == null ? 43 : $ouName.hashCode());
        String $createMode = this.getCreateMode();
        result = result * 59 + ($createMode == null ? 43 : $createMode.hashCode());
        String $apTypeName = this.getApTypeName();
        result = result * 59 + ($apTypeName == null ? 43 : $apTypeName.hashCode());
        String $apTypeCode = this.getApTypeCode();
        result = result * 59 + ($apTypeCode == null ? 43 : $apTypeCode.hashCode());
        String $orderState = this.getOrderState();
        result = result * 59 + ($orderState == null ? 43 : $orderState.hashCode());
        LocalDateTime $buDate = this.getBuDate();
        result = result * 59 + ($buDate == null ? 43 : ((Object)$buDate).hashCode());
        BigDecimal $totalAmt = this.getTotalAmt();
        result = result * 59 + ($totalAmt == null ? 43 : ((Object)$totalAmt).hashCode());
        BigDecimal $exclTaxAmt = this.getExclTaxAmt();
        result = result * 59 + ($exclTaxAmt == null ? 43 : ((Object)$exclTaxAmt).hashCode());
        BigDecimal $taxAmt = this.getTaxAmt();
        result = result * 59 + ($taxAmt == null ? 43 : ((Object)$taxAmt).hashCode());
        BigDecimal $totalCurAmt = this.getTotalCurAmt();
        result = result * 59 + ($totalCurAmt == null ? 43 : ((Object)$totalCurAmt).hashCode());
        BigDecimal $exclTaxCurAmt = this.getExclTaxCurAmt();
        result = result * 59 + ($exclTaxCurAmt == null ? 43 : ((Object)$exclTaxCurAmt).hashCode());
        BigDecimal $taxCurAmt = this.getTaxCurAmt();
        result = result * 59 + ($taxCurAmt == null ? 43 : ((Object)$taxCurAmt).hashCode());
        String $currCode = this.getCurrCode();
        result = result * 59 + ($currCode == null ? 43 : $currCode.hashCode());
        String $currName = this.getCurrName();
        result = result * 59 + ($currName == null ? 43 : $currName.hashCode());
        String $auditUser = this.getAuditUser();
        result = result * 59 + ($auditUser == null ? 43 : $auditUser.hashCode());
        LocalDateTime $auditDate = this.getAuditDate();
        result = result * 59 + ($auditDate == null ? 43 : ((Object)$auditDate).hashCode());
        BigDecimal $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $auditRejection = this.getAuditRejection();
        result = result * 59 + ($auditRejection == null ? 43 : $auditRejection.hashCode());
        String $suppCode = this.getSuppCode();
        result = result * 59 + ($suppCode == null ? 43 : $suppCode.hashCode());
        String $suppName = this.getSuppName();
        result = result * 59 + ($suppName == null ? 43 : $suppName.hashCode());
        String $buCode = this.getBuCode();
        result = result * 59 + ($buCode == null ? 43 : $buCode.hashCode());
        String $buName = this.getBuName();
        result = result * 59 + ($buName == null ? 43 : $buName.hashCode());
        String $buType = this.getBuType();
        result = result * 59 + ($buType == null ? 43 : $buType.hashCode());
        String $payMentName = this.getPayMentName();
        result = result * 59 + ($payMentName == null ? 43 : $payMentName.hashCode());
        String $payMentId = this.getPayMentId();
        result = result * 59 + ($payMentId == null ? 43 : $payMentId.hashCode());
        String $payMentCode = this.getPayMentCode();
        result = result * 59 + ($payMentCode == null ? 43 : $payMentCode.hashCode());
        String $localCurrCode = this.getLocalCurrCode();
        result = result * 59 + ($localCurrCode == null ? 43 : $localCurrCode.hashCode());
        String $localCurrName = this.getLocalCurrName();
        result = result * 59 + ($localCurrName == null ? 43 : $localCurrName.hashCode());
        BigDecimal $taxRate = this.getTaxRate();
        result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        List<ApOrderDtl> $apOrderDtlList = this.getApOrderDtlList();
        result = result * 59 + ($apOrderDtlList == null ? 43 : ((Object)$apOrderDtlList).hashCode());
        List<ApOrderDtlGroup> $apOrderDtlGroupList = this.getApOrderDtlGroupList();
        result = result * 59 + ($apOrderDtlGroupList == null ? 43 : ((Object)$apOrderDtlGroupList).hashCode());
        String $verState = this.getVerState();
        result = result * 59 + ($verState == null ? 43 : $verState.hashCode());
        BigDecimal $verAmt = this.getVerAmt();
        result = result * 59 + ($verAmt == null ? 43 : ((Object)$verAmt).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $procInstId = this.getProcInstId();
        result = result * 59 + ($procInstId == null ? 43 : $procInstId.hashCode());
        ProcInstStatus $procInstStatus = this.getProcInstStatus();
        result = result * 59 + ($procInstStatus == null ? 43 : $procInstStatus.hashCode());
        LocalDateTime $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        LocalDateTime $approvedTime = this.getApprovedTime();
        result = result * 59 + ($approvedTime == null ? 43 : ((Object)$approvedTime).hashCode());
        String $addrNo = this.getAddrNo();
        result = result * 59 + ($addrNo == null ? 43 : $addrNo.hashCode());
        String $suppAddrNo = this.getSuppAddrNo();
        result = result * 59 + ($suppAddrNo == null ? 43 : $suppAddrNo.hashCode());
        String $redSourceNo = this.getRedSourceNo();
        result = result * 59 + ($redSourceNo == null ? 43 : $redSourceNo.hashCode());
        String $proposedStatus = this.getProposedStatus();
        result = result * 59 + ($proposedStatus == null ? 43 : $proposedStatus.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $protocolCode = this.getProtocolCode();
        result = result * 59 + ($protocolCode == null ? 43 : $protocolCode.hashCode());
        String $protocolName = this.getProtocolName();
        result = result * 59 + ($protocolName == null ? 43 : $protocolName.hashCode());
        String $relevanceOuCode = this.getRelevanceOuCode();
        result = result * 59 + ($relevanceOuCode == null ? 43 : $relevanceOuCode.hashCode());
        Map<String, String> $extensionInfo = this.getExtensionInfo();
        result = result * 59 + ($extensionInfo == null ? 43 : ((Object)$extensionInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ApOrder(inOutCust=" + this.getInOutCust() + ", id=" + this.getId() + ", sourceNo=" + this.getSourceNo() + ", apOrderNo=" + this.getApOrderNo() + ", ouCode=" + this.getOuCode() + ", ouId=" + this.getOuId() + ", ouName=" + this.getOuName() + ", createMode=" + this.getCreateMode() + ", apTypeId=" + this.getApTypeId() + ", apTypeName=" + this.getApTypeName() + ", apTypeCode=" + this.getApTypeCode() + ", orderState=" + this.getOrderState() + ", buDate=" + this.getBuDate() + ", totalAmt=" + this.getTotalAmt() + ", exclTaxAmt=" + this.getExclTaxAmt() + ", taxAmt=" + this.getTaxAmt() + ", totalCurAmt=" + this.getTotalCurAmt() + ", exclTaxCurAmt=" + this.getExclTaxCurAmt() + ", taxCurAmt=" + this.getTaxCurAmt() + ", currCode=" + this.getCurrCode() + ", currName=" + this.getCurrName() + ", auditUserId=" + this.getAuditUserId() + ", auditUser=" + this.getAuditUser() + ", auditDate=" + this.getAuditDate() + ", exchangeRate=" + this.getExchangeRate() + ", operUserId=" + this.getOperUserId() + ", operator=" + this.getOperator() + ", taxFlag=" + this.getTaxFlag() + ", initFlag=" + this.getInitFlag() + ", auditRejection=" + this.getAuditRejection() + ", suppId=" + this.getSuppId() + ", suppCode=" + this.getSuppCode() + ", suppName=" + this.getSuppName() + ", buId=" + this.getBuId() + ", buCode=" + this.getBuCode() + ", buName=" + this.getBuName() + ", buType=" + this.getBuType() + ", payMentName=" + this.getPayMentName() + ", payMentId=" + this.getPayMentId() + ", payMentCode=" + this.getPayMentCode() + ", localCurrCode=" + this.getLocalCurrCode() + ", localCurrName=" + this.getLocalCurrName() + ", taxRate=" + this.getTaxRate() + ", remark=" + this.getRemark() + ", apOrderDtlList=" + this.getApOrderDtlList() + ", apOrderDtlGroupList=" + this.getApOrderDtlGroupList() + ", verState=" + this.getVerState() + ", verAmt=" + this.getVerAmt() + ", creator=" + this.getCreator() + ", auditDataVersion=" + this.getAuditDataVersion() + ", procInstId=" + this.getProcInstId() + ", procInstStatus=" + this.getProcInstStatus() + ", submitTime=" + this.getSubmitTime() + ", approvedTime=" + this.getApprovedTime() + ", addrNo=" + this.getAddrNo() + ", suppAddrNo=" + this.getSuppAddrNo() + ", redState=" + this.getRedState() + ", redSourceNo=" + this.getRedSourceNo() + ", redSourceId=" + this.getRedSourceId() + ", proposedStatus=" + this.getProposedStatus() + ", check=" + this.getCheck() + ", createUserId=" + this.getCreateUserId() + ", createTime=" + this.getCreateTime() + ", protocolCode=" + this.getProtocolCode() + ", protocolName=" + this.getProtocolName() + ", relevanceOuCode=" + this.getRelevanceOuCode() + ", extensionInfo=" + this.getExtensionInfo() + ")";
    }
}

