package com.elitesland.fin.application.service.payorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.payorder.ApOrderToPaySaveParam;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 13:03
 */
public interface PayOrderService {

    PagingVO<PayOrderVO> page(PayOrderPageParam param);

    PayOrderVO queryById(Long id);

    ApiResult<List<Long>> deleteByIds(List<Long> ids);

    ApiResult<Long> save(PayOrderSaveParam param);

    ApiResult<Long> submit(PayOrderSaveParam param);

    ApiResult<PayOrderVO> defaultValue();

    PayOrderVO queryDetailsById(Long id);

    ApiResult<String> saveByApOrder(ApOrderToPaySaveParam param);

    void approved(Long id);

    /**
     * 取消审批
     *
     * @param ids
     * @return
     */
    ApiResult<Void> cancelApprove(List<Long> ids);

    /**
     * 红冲
     *
     * @param id
     * @return
     */
    ApiResult<Long> redPunch(Long id);
    public PagingVO<PayOrderVO> writeoffPage(PayOrderPageParam param);

    public void updateMiddleVerAmt(Long payDId, BigDecimal amt);

    /**
     * 更新核销金额.
     *
     * @param recDId 明细ID
     * @param amt    金额
     * @param verType    核销类型
     */
    void updateVerAmt(Long payDId, BigDecimal amt,String verType);


    /**
     * 查询明细集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    List<PayOrderDtlVO> listPayOrderDetail(FinPayOrderDetailQuery query);

}
