package com.elitesland.fin.domain.service.apordertopay;

import com.elitesland.fin.application.convert.apordertopay.ApOrderToPayConvert;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPayDO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.repo.apordertopay.ApOrderToPayRepo;
import com.elitesland.fin.infr.repo.apordertopay.ApOrderToPayRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/3/28 13:19
 */
@Service
@RequiredArgsConstructor
public class ApOrderToPayDomainServiceImpl implements ApOrderToPayDomainService {

    private final ApOrderToPayRepo apOrderToPayRepo;

    private final ApOrderToPayRepoProc apOrderToPayRepoProc;

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> save(List<ApOrderToPay> orderToPays) {
        List<ApOrderToPayDO> apOrderToPayDOS = ApOrderToPayConvert.INSTANCE.convertDo(orderToPays);
        orderToPays.forEach(ApOrderToPay::checkNotNull);
        List<ApOrderToPayDO> order = apOrderToPayRepo.saveAll(apOrderToPayDOS);
        return order.stream().map(ApOrderToPayDO::getId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void deleteByPayId(Long payId) {
        apOrderToPayRepoProc.deleteByPayId(payId);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void deleteByPayIds(List<Long> payIds) {
        apOrderToPayRepoProc.deleteByPayIds(payIds);
    }

    @Override
    public List<ApOrderToPayDTO> queryByApId(List<Long> apIds) {
        return apOrderToPayRepoProc.queryByApIds(apIds);
    }
}
