/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.saleinv;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.ByteMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvEmailParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvSumVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvAppPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDtlDomainService;
import com.elitesland.fin.infinity.utils.MessageUtil;
import com.elitesland.fin.infr.dto.saleinv.SaleInvAppDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvSumDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SaleInvServiceImpl
implements SaleInvService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvServiceImpl.class);
    public final SaleInvDomainService saleInvDomainService;
    public final SaleInvDtlDomainService saleInvDtlDomainService;
    public final WorkflowRpcService workflowRpcService;
    public final ArOrderService arOrderService;
    private final TaskExecutor taskExecutor;
    private final FlexFieldUtilService flexFieldUtilService;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final SaleInvRepo saleInvRepo;
    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<SaleInvVO> page(SaleInvPageParam param) {
        PagingVO<SaleInvDTO> page = this.saleInvDomainService.page(param);
        PagingVO<SaleInvVO> res = SaleInvConvert.INSTANCE.convertPage(page);
        if (CollectionUtils.isNotEmpty((Collection)res.getRecords())) {
            this.flexFieldUtilService.handleFlexFieldShowNameForVO("SALE_INV", res.getRecords());
        }
        Map orderType3 = this.udcProvider.getValueMapByUdcCode("yst-order", "ORDER_TYPE3");
        res.getRecords().forEach(record -> record.setDocType3Name((String)orderType3.get(record.getDocType3())));
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleInvAppVO> appPage(SaleInvAppPageParam param) {
        PagingVO<SaleInvAppDTO> page = this.saleInvDomainService.appPage(param);
        PagingVO<SaleInvAppVO> res = SaleInvConvert.INSTANCE.convertAppPage(page);
        if (res.isNotEmpty()) {
            List records = res.getRecords();
            List<Long> invIds = records.stream().map(SaleInvAppVO::getId).collect(Collectors.toList());
            List<SaleInvDtlDO> details = this.saleInvDtlDomainService.findByMasIds(invIds);
            Map<Long, List<SaleInvDtlDO>> dtlMap = details.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
            records.forEach(record -> {
                List saleInvDtlDOS = (List)dtlMap.get(record.getId());
                record.setTotalAmt(saleInvDtlDOS.stream().map(SaleInvDtlDO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                Optional<LocalDateTime> earliestRootDocTime = saleInvDtlDOS.stream().map(SaleInvDtlDO::getRootDocTime).filter(Objects::nonNull).min(LocalDateTime::compareTo);
                record.setRootDocTimeFrom(earliestRootDocTime.orElse(record.getCreateTime()));
                Optional<LocalDateTime> latestRootDocTime = saleInvDtlDOS.stream().map(SaleInvDtlDO::getRootDocTime).filter(Objects::nonNull).max(LocalDateTime::compareTo);
                record.setRootDocTimeTo(latestRootDocTime.orElse(record.getCreateTime()));
            });
        }
        return res;
    }

    @Override
    @SysCodeProc
    public SaleInvSumVO selectListSum(SaleInvPageParam param) {
        SaleInvSumDTO saleInvSumDTO = this.saleInvDomainService.selectListSum(param);
        SaleInvSumVO saleInvSumVO = SaleInvConvert.INSTANCE.sumDtoConvertSumVo(saleInvSumDTO);
        return saleInvSumVO;
    }

    @Override
    @SysCodeProc
    public List<SaleInvDtlVO> getList(Long masId) {
        List<SaleInvDtlDTO> list = this.saleInvDtlDomainService.getList(masId);
        List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
        return res;
    }

    @Override
    public List<SaleInvDtlVO> getSummaryList(List<SaleInvDtlParam> saleInvDtlParamList) {
        return this.saleInvDtlDomainService.getSummaryList(saleInvDtlParamList);
    }

    @Override
    @SysCodeProc
    public SaleInvVO get(Long id) {
        SaleInvDTO saleInvDTO = this.saleInvDomainService.get(id);
        SaleInvVO res = SaleInvConvert.INSTANCE.convert(saleInvDTO);
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("SALE_INV", (CustomFieldBaseModelVo)res);
        return res;
    }

    @Override
    public Long save(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = this.saleInvDomainService.save(saleInv);
        return res;
    }

    @Override
    public Long del(List<Long> ids) {
        Long res = this.saleInvDomainService.del(ids);
        return res;
    }

    @Override
    public Long update(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = this.saleInvDomainService.update(saleInv);
        return res;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long submit(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long resId = this.saleInvDomainService.submit(saleInv);
        if (saleInv.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInv.getProcInstStatus())) {
            String procInstName = "\u9500\u552e\u53d1\u7968\u5ba1\u6838-" + saleInv.getInvRegNo();
            String procKey = WorkFlowDefKey.FIN_SALE_INV.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, resId);
        }
        return resId;
    }

    @Override
    @SysCodeProc
    public List<SaleInvdDtlVO> getInvdLists(Long masId) {
        List<SaleInvdDtlDTO> list = this.saleInvDomainService.getInvdLists(masId);
        List<SaleInvdDtlVO> res = SaleInvConvert.INSTANCE.convertInvdListVO(list);
        return res;
    }

    @Override
    public Long updateInvInfo(SaleInvParam saleInvParam) {
        Long res = this.saleInvDomainService.updateInvInfo(saleInvParam);
        return res;
    }

    @Override
    public PagingVO<SaleInvDtlVO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = this.saleInvDtlDomainService.dtlPage(saleInvDtlPageParam);
        return SaleInvConvert.INSTANCE.convertDtlPage(res);
    }

    @Override
    public SaleInvVO queryAmt() {
        return this.saleInvDomainService.queryAmt();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoCreateArOrder(SaleInvParam saleInvParam) {
        Long id = saleInvParam.getId();
        SaleInvDTO saleInvDTO = this.saleInvDomainService.get(id);
        List<SaleInvDtlDTO> saleInvDtlDTOList = saleInvDTO.getSaleInvDtlDTOList();
        if (saleInvDTO.getArFlag().booleanValue()) {
            throw new BusinessException("\u5e94\u6536\u5355\u5df2\u751f\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        ArOrderRecordSaveParam arOrderRecordSaveParam = new ArOrderRecordSaveParam();
        arOrderRecordSaveParam.setSourceDocType(UdcEnum.DOC_TYPE_SAINV.getValueCode());
        arOrderRecordSaveParam.setSourceDocStatus(UdcEnum.DOC_STATUS_SAINV.getValueCode());
        arOrderRecordSaveParam.setSourceNo(saleInvDTO.getApplyNo());
        arOrderRecordSaveParam.setCreateMode(UdcEnum.DOC_CLS_SAINV.getValueCode());
        arOrderRecordSaveParam.setOuCode(saleInvDTO.getOuCode());
        arOrderRecordSaveParam.setOuId(saleInvDTO.getOuId());
        arOrderRecordSaveParam.setOuName(saleInvDTO.getOuName());
        LocalDateTime drawDate = Objects.isNull(saleInvDTO.getDrawDate()) ? LocalDateTime.now() : saleInvDTO.getDrawDate();
        arOrderRecordSaveParam.setBuDate(drawDate);
        arOrderRecordSaveParam.setCurrCode(saleInvDTO.getCurrCode());
        arOrderRecordSaveParam.setCurrName(saleInvDTO.getCurrName());
        arOrderRecordSaveParam.setLocalCurrCode(saleInvDTO.getLocalCurrCode());
        arOrderRecordSaveParam.setLocalCurrName(saleInvDTO.getLocalCurrName());
        arOrderRecordSaveParam.setExchangeRate(saleInvDTO.getExchangeRate());
        arOrderRecordSaveParam.setCustCode(saleInvDTO.getInvCustCode());
        arOrderRecordSaveParam.setCustId(saleInvDTO.getInvCustId());
        arOrderRecordSaveParam.setCustName(saleInvDTO.getInvCustName());
        arOrderRecordSaveParam.setBuCode(null);
        arOrderRecordSaveParam.setBuId(null);
        arOrderRecordSaveParam.setBuName(null);
        arOrderRecordSaveParam.setPayMentCode(null);
        arOrderRecordSaveParam.setPayMentId(null);
        arOrderRecordSaveParam.setPayMentName(null);
        arOrderRecordSaveParam.setProtocolCode(null);
        arOrderRecordSaveParam.setSaleUserId(saleInvDtlDTOList.get(0).getAgentEmpId());
        arOrderRecordSaveParam.setSaleUserCode(null);
        arOrderRecordSaveParam.setSaleUser(saleInvDtlDTOList.get(0).getAgentName());
        arOrderRecordSaveParam.setEs1(saleInvDTO.getMainCustCode());
        arOrderRecordSaveParam.setEs2(null);
        arOrderRecordSaveParam.setEs3(null);
        arOrderRecordSaveParam.setEs4(null);
        arOrderRecordSaveParam.setEs6(null);
        List<ArOrderDtlRecordSaveParam> arOrderDtlRecordSaveParams = saleInvDtlDTOList.stream().map(saleInvDtlDTO -> {
            ArOrderDtlRecordSaveParam arOrderDtlRecordSaveParam = new ArOrderDtlRecordSaveParam();
            arOrderDtlRecordSaveParam.setSourceNo(saleInvDtlDTO.getSourceNo());
            arOrderDtlRecordSaveParam.setSourceLine(saleInvDtlDTO.getSourceLine());
            arOrderDtlRecordSaveParam.setItemCode(saleInvDtlDTO.getItemCode());
            arOrderDtlRecordSaveParam.setItemName(saleInvDtlDTO.getItemName());
            arOrderDtlRecordSaveParam.setItemType(saleInvDtlDTO.getItemType());
            arOrderDtlRecordSaveParam.setSmallCateCode(null);
            arOrderDtlRecordSaveParam.setSmallCateName(null);
            arOrderDtlRecordSaveParam.setUom(saleInvDtlDTO.getUom());
            arOrderDtlRecordSaveParam.setUomName(saleInvDtlDTO.getUomName());
            arOrderDtlRecordSaveParam.setQty(saleInvDtlDTO.getQty());
            BigDecimal settlePrice = saleInvDtlDTO.getInvAmt().divide(saleInvDtlDTO.getQty(), 6, RoundingMode.HALF_UP);
            BigDecimal settleNetPrice = settlePrice.divide(BigDecimal.ONE.add(saleInvDtlDTO.getTaxRate()), 6, RoundingMode.HALF_UP);
            arOrderDtlRecordSaveParam.setExclTaxPrice(settleNetPrice);
            arOrderDtlRecordSaveParam.setPrice(settlePrice);
            arOrderDtlRecordSaveParam.setTaxRate(saleInvDtlDTO.getTaxRate());
            arOrderDtlRecordSaveParam.setTotalAmt(saleInvDtlDTO.getInvAmt());
            BigDecimal invNetAmt = saleInvDtlDTO.getInvAmt().divide(BigDecimal.ONE.add(saleInvDtlDTO.getTaxRate()), 2, RoundingMode.HALF_UP);
            arOrderDtlRecordSaveParam.setExclTaxAmt(invNetAmt);
            BigDecimal invTaxAmt = saleInvDtlDTO.getInvAmt().subtract(invNetAmt);
            arOrderDtlRecordSaveParam.setTaxAmt(invTaxAmt);
            BigDecimal totalCurAmt = arOrderDtlRecordSaveParam.getTotalAmt().multiply(arOrderRecordSaveParam.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            arOrderDtlRecordSaveParam.setTotalCurAmt(totalCurAmt);
            BigDecimal exclTaxCurAmt = arOrderDtlRecordSaveParam.getExclTaxAmt().multiply(arOrderRecordSaveParam.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            arOrderDtlRecordSaveParam.setExclTaxCurAmt(exclTaxCurAmt);
            BigDecimal taxCurAmt = totalCurAmt.subtract(exclTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            arOrderDtlRecordSaveParam.setTaxCurAmt(taxCurAmt);
            arOrderDtlRecordSaveParam.setBuCode(null);
            arOrderDtlRecordSaveParam.setBuId(null);
            arOrderDtlRecordSaveParam.setBuName(null);
            arOrderDtlRecordSaveParam.setEs11(saleInvDtlDTO.getSourceNo());
            arOrderDtlRecordSaveParam.setEs12(saleInvDtlDTO.getSourceId());
            arOrderDtlRecordSaveParam.setEs13(saleInvDTO.getMainCustCode());
            arOrderDtlRecordSaveParam.setEs14(saleInvDTO.getCustCode());
            arOrderDtlRecordSaveParam.setEs15(null);
            arOrderDtlRecordSaveParam.setEs16(saleInvDtlDTO.getTaxCode());
            arOrderDtlRecordSaveParam.setEs17(saleInvDtlDTO.getInvNo());
            arOrderDtlRecordSaveParam.setEs18(saleInvDtlDTO.getInvType());
            arOrderDtlRecordSaveParam.setEs19(null);
            arOrderDtlRecordSaveParam.setProtocolCode(null);
            if (Objects.nonNull(saleInvDtlDTO.getAgentEmpId())) {
                arOrderDtlRecordSaveParam.setEs20(String.valueOf(saleInvDtlDTO.getAgentEmpId()));
            }
            arOrderDtlRecordSaveParam.setEs21(null);
            arOrderDtlRecordSaveParam.setEs22(null);
            arOrderDtlRecordSaveParam.setEs23(null);
            arOrderDtlRecordSaveParam.setEs24(null);
            return arOrderDtlRecordSaveParam;
        }).collect(Collectors.toList());
        BigDecimal totalAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmtSum = arOrderDtlRecordSaveParams.stream().map(ArOrderDtlRecordSaveParam::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        arOrderRecordSaveParam.setTotalAmt(totalAmtSum);
        arOrderRecordSaveParam.setExclTaxAmt(exclTaxAmtSum);
        arOrderRecordSaveParam.setTaxAmt(taxAmtSum);
        arOrderRecordSaveParam.setTotalCurAmt(totalCurAmtSum);
        arOrderRecordSaveParam.setExclTaxCurAmt(exclTaxCurAmtSum);
        arOrderRecordSaveParam.setTaxCurAmt(taxCurAmtSum);
        arOrderRecordSaveParam.setArOrderDtlRecordSaveParams(arOrderDtlRecordSaveParams);
        CompletableFuture.runAsync(() -> this.arOrderService.autoCreate(arOrderRecordSaveParam), (Executor)this.taskExecutor);
    }

    @Override
    @SysCodeProc
    public SaleInvAppVO appGet(Long id) {
        SaleInvAppDTO saleInvAppDTO = this.saleInvDomainService.appGet(id);
        SaleInvAppVO saleInvAppVO = SaleInvConvert.INSTANCE.convertAppPage(saleInvAppDTO);
        List<SaleInvDtlDO> dtlList = this.saleInvDtlRepo.findAllByMasIdIn(List.of(id));
        Map<String, List<SaleInvDtlDO>> dtlGroup = dtlList.stream().collect(Collectors.groupingBy(d -> this.getDtlKey(d.getSourceNo(), d.getRootDocNo())));
        saleInvAppVO.setDocNum(dtlGroup.size());
        ArrayList<SaleInvDtlAppVO> detailList = new ArrayList<SaleInvDtlAppVO>();
        dtlGroup.values().forEach(list -> {
            SaleInvDtlAppVO invDtlAppVO = new SaleInvDtlAppVO();
            SaleInvDtlDO saleInvDtlDO = (SaleInvDtlDO)list.get(0);
            invDtlAppVO.setSourceNo(saleInvDtlDO.getSourceNo());
            invDtlAppVO.setSourceId(saleInvDtlDO.getSourceId());
            invDtlAppVO.setSourceTime(saleInvDtlDO.getSourceTime());
            invDtlAppVO.setRootDocNo(saleInvDtlDO.getRootDocNo());
            invDtlAppVO.setRootDocId(saleInvDtlDO.getRootDocId());
            invDtlAppVO.setRootDocTime(saleInvDtlDO.getRootDocTime());
            invDtlAppVO.setRecApplyTime(saleInvAppVO.getRecApplyTime());
            invDtlAppVO.setTotalAmt(list.stream().map(SaleInvDtlDO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<SaleInvDtlAppVO.SaleInvDtlItemAppVO> itemList = list.stream().map(d -> {
                SaleInvDtlAppVO.SaleInvDtlItemAppVO item = new SaleInvDtlAppVO.SaleInvDtlItemAppVO();
                item.setItemCode(d.getItemCode());
                item.setItemName(d.getItemName());
                item.setQty(d.getQty());
                return item;
            }).toList();
            invDtlAppVO.setDetailList(itemList);
            detailList.add(invDtlAppVO);
        });
        saleInvAppVO.setDocDetails(detailList);
        List<SaleInvdDtlDO> allById = this.saleInvdDtlRepo.findAllByMasId(id);
        if (CollectionUtils.isNotEmpty(allById)) {
            List<String> list2 = allById.stream().map(SaleInvdDtlDO::getInvPdfBase64).filter(Objects::nonNull).toList();
            saleInvAppVO.setInvPics(list2);
            saleInvAppVO.setInvNum(list2.size());
        } else {
            saleInvAppVO.setInvNum(0);
        }
        return saleInvAppVO;
    }

    @Override
    public void sendEmail(SaleInvEmailParam param) {
        List<Long> idList = param.getIds();
        String email = param.getEmail();
        List allById = this.saleInvRepo.findAllById(idList);
        if (CollectionUtils.isEmpty((Collection)allById)) {
            throw new BusinessException("\u53d1\u7968\u4e0d\u5b58\u5728");
        }
        Map saleInvDOMap = allById.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        List<SaleInvdDtlDO> saleInvdDtlDOList = this.saleInvdDtlRepo.findAllByMasIdIn(saleInvDOMap.keySet());
        if (CollectionUtils.isEmpty(saleInvdDtlDOList)) {
            throw new BusinessException("\u53d1\u7968\u8be6\u60c5\u4e0d\u5b58\u5728");
        }
        Map<Long, List<SaleInvdDtlDO>> invdMap = saleInvdDtlDOList.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getMasId));
        for (SaleInvDO saleInvDO : allById) {
            List attachmentVOList;
            List<SaleInvdDtlDO> saleInvdDtlDOS = invdMap.get(saleInvDO.getId());
            if (CollectionUtils.isEmpty(saleInvdDtlDOS)) {
                log.error("\u53d1\u7968\u8be6\u60c5\u4e3a\u7a7a:{}", (Object)saleInvDO.getId());
                continue;
            }
            SaleInvdDtlDO saleInvdDtlDO = saleInvdDtlDOS.get(0);
            if (!saleInvdDtlDO.getInvState().equals(UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                log.error("\u53ea\u6709\u5f00\u7968\u72b6\u6001\u4e3a\u5f00\u7968\u6210\u529f\u624d\u80fd\u53d1\u9001\u90ae\u4ef6:{}", (Object)saleInvDO.getId());
                continue;
            }
            if (email == null && saleInvDO.getEmail() == null) {
                log.error("\u6536\u4ef6\u90ae\u7bb1\u4e3a\u7a7a:{}", (Object)saleInvDO.getId());
                continue;
            }
            MultipartFile file = MessageUtil.convert(saleInvdDtlDO.getInvPdfBase64(), saleInvdDtlDO.getInvNo() + saleInvDO.getCustName() + ".pdf", "application/pdf");
            try {
                attachmentVOList = file.isEmpty() ? Collections.emptyList() : List.of(new ByteMessageAttachmentVO(file.getBytes(), file.getOriginalFilename(), file.getContentType()));
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            try {
                String invDateFormat = "";
                if (saleInvdDtlDO.getInvDate() != null) {
                    invDateFormat = saleInvdDtlDO.getInvDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                }
                String totalAmt = saleInvdDtlDO.getTotalAmt().stripTrailingZeros().toPlainString();
                Messenger.richTextEmail().setSubject(saleInvDO.getCustName() + "\u53d1\u7968" + saleInvdDtlDO.getInvNo()).setContent("<!DOCTYPE html>\n<html lang=\"zh-CN\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n        body {\n            font-family: Arial, sans-serif;\n            font-size: 14px;\n            line-height: 1.5;\n            color: #333333;\n        }\n\n        a {\n            color: #0073aa;\n        }\n    </style>\n</head>\n<body>\n<div>\n    <p>\u53d1\u7968\u91d1\u989d:" + totalAmt + "</p>\n    <p>\u5f00\u7968\u65e5\u671f:" + invDateFormat + "</p>\n    <p>\u8d2d\u65b9\u540d\u79f0:" + saleInvDO.getCustName() + "</p>\n    <p>\u53d1\u7968\u53f7\u7801:" + saleInvdDtlDO.getInvNo() + "</p>\n\n\n    <!--\u7b7e\u540d-->\n    <div style=\"margin-top:50px;\">\n        <div style=\"border-bottom:1px dashed #e5e5e5;\"></div>\n        <div style=\"padding:8px;color:#999999; font-size:12px\">\u6e29\u99a8\u63d0\u793a \u90ae\u4ef6\u7531\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001\uff0c\u8bf7\u52ff\u76f4\u63a5\u56de\u590d\u3002</div>\n        <div style=\"padding:8px;color:#999999; font-size:15px\">\u60a8\u5df2\u6536\u5230\u6570\u7535\u53d1\u7968\u3002\u5176\u6cd5\u5f8b\u6548\u529b\u3001\u57fa\u672c\u7528\u9014\u7b49\u4e0e\u73b0\u6709\u7eb8\u8d28\u53d1\u7968\u76f8\u540c\u3002</div>\n    </div>\n</div>\n</body>\n</html>").setReceiverList(List.of(new MessageAccountVO(email == null ? saleInvDO.getEmail() : email))).setAttachments(attachmentVOList).build().send();
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String getDtlKey(String sourceNo, String rootDocNo) {
        return rootDocNo + "_" + sourceNo;
    }

    public SaleInvServiceImpl(SaleInvDomainService saleInvDomainService, SaleInvDtlDomainService saleInvDtlDomainService, WorkflowRpcService workflowRpcService, ArOrderService arOrderService, TaskExecutor taskExecutor, FlexFieldUtilService flexFieldUtilService, SaleInvDtlRepo saleInvDtlRepo, SaleInvdDtlRepo saleInvdDtlRepo, SaleInvRepo saleInvRepo, UdcProvider udcProvider) {
        this.saleInvDomainService = saleInvDomainService;
        this.saleInvDtlDomainService = saleInvDtlDomainService;
        this.workflowRpcService = workflowRpcService;
        this.arOrderService = arOrderService;
        this.taskExecutor = taskExecutor;
        this.flexFieldUtilService = flexFieldUtilService;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.saleInvRepo = saleInvRepo;
        this.udcProvider = udcProvider;
    }
}

