package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@Data
@ApiModel("分页查询重新开票")
public class InvoiceRedraftQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("换开申请单号")
    private String origApplyNo;

    @ApiModelProperty("发票号码")
    private String invoiceNo;

    @ApiModelProperty("开票日期起")
    private LocalDateTime invoiceDateStart;

    @ApiModelProperty("开票日期止")
    private LocalDateTime invoiceDateEnd;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("发票是否抵扣 0-否 1-是")
    private String invoiceDeduction;

    @ApiModelProperty("新开票申请单号")
    private String redraftApplyNo;

    @ApiModelProperty("审批状态 [UDC]yst-franchisee:FLOW_STATUS")
    private ProcInstStatus workflowProcInstStatus;

}
