package com.elitesland.fin.application.facade.vo.rectype;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:46
 */
@Data
public class RecTypeVO implements Serializable {

    private static final long serialVersionUID = -4058405876803679757L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("收款单类型定义编码")
    private String recTypeCode;

    @ApiModelProperty("收款单类型定义名称")
    private String recTypeName;

    @ApiModelProperty("是否启用")
    private Boolean enableFlag;

    @ApiModelProperty("是否默认")
    private Boolean defaultFlag;

    @ApiModelProperty("是否自动审核")
    private Boolean autoAudit;
}
