package com.elitesland.fin.application.service.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.*;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.order.param.SaleReconciliatDTO;

import java.util.List;
import java.util.Map;

public interface InvoiceAwaitService {

    PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param);

    List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId);

    List<InvoiceSaveVO> invoiceApply(InvoiceApplyParam param);

    List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam);


    /**
     * 生成待开发票数据并去开票
     *
     * @param param
     * @return
     */
    List<InvoiceAwaitDTO> generateAwaitOrderAndInvoice(String param);

    /**
     * 更新开票状态
     * @param param
     */
    void updateInvedState(SaleInvStatusParam param);

    void updateRedState(SaleInvStatusParam statusParam);

    /**
     * 根据来源单号批量逻辑删除
     *
     * @param optDocNos 来源单号
     * @return
     */
    void updateDeleteFlagByOptDocNoBatch(List<String> optDocNos);

    /**
     * 根据来源单据主键id批量逻辑删除
     *
     * @param optDocIds 来源单据主键id
     * @return
     */
    void updateDeleteFlagByOptDocIdBatch(List<Long> optDocIds);


    /**
     * 销售发货单/销售退货收货单生成待开申请发票列表
     * @param param
     */
    void invoiceAwaitOrderBySalDo(String param);


    List<InvoiceAwaitRespVO> checkAndQueryInvoiceAwait(InvoiceApplyParam param);

    Map<String, List<InvoiceAwaitRespVO>> groupByDocCls(List<InvoiceAwaitRespVO> records, List<InvoiceRuleConfigDTO> configDTOList);

    List<InvoiceApplySaveParam> getInvoiceApplySaveParams(List<InvoiceAwaitRespVO> records,InvoiceApplyParam param);

    List<InvoiceAwaitDTO> buildSalRecToInvoiceAwaitOrder(List<SaleReconciliatDTO> saleReconciliatDTOS);

    InvoiceApplyParam getInvoiceApplyParamByAwaitOrder(InvoiceAwaitDO save);
}
