package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedSaveRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceDtlDomainService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.writeoff.RmiUdcService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedInvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedInitialResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.RedInvoiceOpenResp;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhiMing
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvoiceServiceImpl implements InvoiceService {

    private final InvoiceApplyService invoiceApplyService;
    private final InvoiceSaveService invoiceSaveService;
    private final InvoiceRedraftRepo invoiceRedraftRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvService saleInvService;
    private final InvoiceDtlDomainService invoiceDtlDomainService;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final ItmItemRpcService itmItemRpcService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    @Autowired
    private RmiUdcService rmiSysUdcRpcService;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final AisinoService aisinoService;
    private final AisinoPayloadService aisinoPayloadService;

    @Override
    public long create(InvoiceApplyParam param) {
        //参数校验
        this.checeInvParam(param);
        // 验重
        InvoiceQueryParam queryParam = new InvoiceQueryParam();
        queryParam.setSourceDocId(param.getIds());
        List<InvoiceApplyRpcDTO> applyRpcDTO = invoiceApplyService.queryIdBySource(queryParam);
        if (CollUtil.isNotEmpty(applyRpcDTO)) {
            throw new BusinessException("单据已开票，不能重复操作");
        }
        List<InvoiceSaveVO> save = invoiceSaveService.save(param);
        if (!CollUtil.isEmpty(save)) {
            return save.get(0).getApplyId();
        }
        return 0L;
    }

    @Transactional
    @Override
    public Long redraft(String applyNo) {
        InvoiceRedraftDO invRedraftDO = invoiceRedraftRepo.findByOrigApplyNo(applyNo);
        if (!ObjectUtils.isEmpty(invRedraftDO) && !ObjectUtils.isEmpty(invRedraftDO.getWorkflowProcInstStatus())) {
            throw new BusinessException("存在未完结的重新开票审批");
        }
        // 不做特殊校验，直接开票
        InvoiceApplyRpcDTO applyRpcDTO = invoiceApplyService.queryIdByApplyNo(applyNo);
        Assert.notNull(applyRpcDTO.getApplyId(), applyNo + " 单据不存在");
        /*if (!applyRpcDTO.isRedState()) {
            throw new BusinessException("重新开票失败：没有发票或发票没有红冲");
        }*/
        //生成重新开票记录
        InvoiceRedraftDO invoiceRedraftDO = this.saveInvoiceRedraft(applyRpcDTO);
        return invoiceRedraftDO.getId();
    }

    @Override
    public void rePushSaleInvDDtl(List<Long> idList) {
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(idList);
        if (CollectionUtils.isEmpty(allById)) {
            throw new BusinessException("未找到单据");
        }
        allById.forEach(invdDtlDO -> {
            Boolean b = abstractInvoiceSaveService.invoiceReApply(invdDtlDO);
            if (b) {
                this.getBase64Result(new ArrayList<>() {{
                    add(invdDtlDO.getId());
                }});
            }
        });
    }

    @Override
    @Transactional
    public void rePushSaleInv(ApplyRePushParam param) {
        List<SaleInvDO> applyList = saleInvRepo.findByApplyNoIn(param.getApplyNoList());
        if (CollectionUtils.isEmpty(applyList)) {
            throw new BusinessException("未找到单据");
        }

        List<Long> idList = applyList.stream().map(BaseModel::getId).toList();

        List<SaleInvdDtlDO> allByMasIdIn1 = saleInvdDtlRepo.findAllByMasIdIn(idList);
        Map<Long, List<SaleInvdDtlDO>> saleInvdDtlMap;
        if (CollectionUtil.isNotEmpty(allByMasIdIn1)) {
            saleInvdDtlMap = allByMasIdIn1.stream().collect(Collectors.groupingBy(SaleInvdDtlDO::getMasId));
        } else {
            saleInvdDtlMap = new HashMap<>();
        }

        List<SaleInvDtlDO> allByMasIdIn = saleInvDtlRepo.findAllByMasIdIn(idList);
        Map<Long, List<SaleInvDtlDO>> saleInvDtlMap;
        if (CollectionUtil.isNotEmpty(allByMasIdIn)) {
            saleInvDtlMap = allByMasIdIn.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));
        } else {
            saleInvDtlMap = new HashMap<>();
        }

        List<InvoiceApplySaveParam> invoiceApplySaveParamList = new ArrayList<>();
        List<Long> deleteSaleInvDDtlIdList = new ArrayList<>();
        applyList.forEach(apply -> {
            List<SaleInvdDtlDO> saleInvdDtlDOS = saleInvdDtlMap.get(apply.getId());
            if (CollectionUtil.isNotEmpty(saleInvdDtlDOS)) {
                // 如果状态是开票成功，则不能重推
                saleInvdDtlDOS.forEach(saleInvdDtlDO -> {
                    if (Objects.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
                        throw new BusinessException("单据" + apply.getApplyNo() + "已开票成功，不能重复操作");
                    }
                    deleteSaleInvDDtlIdList.add(saleInvdDtlDO.getId());
                });
            }

            InvoiceApplySaveParam invoiceApplySaveParam = new InvoiceApplySaveParam();
            BeanUtils.copyProperties(apply, invoiceApplySaveParam);
            List<InvoiceDetailSaveParam> detail = new ArrayList<>();
            List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(apply.getId());
            saleInvDtlDOS.forEach(v -> {
                InvoiceDetailSaveParam invoiceDetailSaveParam = new InvoiceDetailSaveParam();
                BeanUtils.copyProperties(v, invoiceDetailSaveParam);
                invoiceDetailSaveParam.setLineNo(v.getSourceLine());
                detail.add(invoiceDetailSaveParam);
            });
            invoiceApplySaveParam.setDetails(detail);
            invoiceApplySaveParamList.add(invoiceApplySaveParam);
        });

        if (CollectionUtil.isNotEmpty(invoiceApplySaveParamList)) {
            invoiceApplySaveParamList.forEach(invoiceApplySaveParam -> {
                abstractInvoiceSaveService.invoiceApply(invoiceApplySaveParam, null);
            });
        }
        if (CollectionUtil.isNotEmpty(deleteSaleInvDDtlIdList)){
            saleInvdDtlRepo.deleteAllById(deleteSaleInvDDtlIdList);
        }
    }

    @Override
    public void getBlueResult(List<Long> saleInvIdList) {
        // 开票申请单号
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(saleInvIdList);
        // 查询获取蓝票结果
        for (SaleInvdDtlDO saleInvdDtlDO : allById) {
            abstractInvoiceSaveService.getInvoiceInfoByFlowNo(saleInvdDtlDO);
            abstractInvoiceSaveService.getBlueResult(saleInvdDtlDO);
        }
        saleInvdDtlRepo.saveAll(allById);
    }

    @Override
    public void getBase64Result(List<Long> saleInvIdList) {
        // 开票申请单号
        List<SaleInvdDtlDO> allById = saleInvdDtlRepo.findAllById(saleInvIdList);
        // 查询获取蓝票结果
        for (SaleInvdDtlDO saleInvdDtlDO : allById) {
            abstractInvoiceSaveService.getBase64Result(saleInvdDtlDO);
        }
        saleInvdDtlRepo.saveAll(allById);
    }

    /**
     * 红冲接口
     *
     * @param saveParam
     */
    public String redInvoice(InvoiceRedApplySaveParam saveParam) {
        String aisinoRedPayload = aisinoPayloadService.convertRedInitial(saveParam);
        // 红票确认单初始化
        AisinoRedInitialResultResp response = aisinoService.redInvoiceInitial(
                aisinoPayloadService.assembleAisinoPayload(aisinoRedPayload, saveParam.getSaleTaxNo()),
                aisinoRedPayload);
        if (response != null && Objects.equals(response.getCODE(), "0000")) {
            // 初始化结果
            InvoiceRedInitialRespVO invoiceRedInitialRespVO = JSON.parseObject(response.getDATA(), InvoiceRedInitialRespVO.class);
            // todo lance 红票确认单初始化结果，需要保存
            String redSaveParam = aisinoPayloadService.convertRedSave(invoiceRedInitialRespVO);
            AisinoCoverParamPayload redSavePayload = aisinoPayloadService.assembleAisinoPayload(redSaveParam, saveParam.getSaleTaxNo());
            // 通过红票确认单保存
            AisinoRedInitialResultResp redSaveResp = aisinoService.redInvoiceSave(redSavePayload, redSaveParam);
            if (redSaveResp != null && Objects.equals(redSaveResp.getCODE(), "0000")) {
                // 如果2.2.2.4响应数据中QRJKPBZ = Y（是否确认即开票标志）,表示当“申请红字确认单保存时”或“购/销方确认后”，会自动开具红票，则不必再使用2.2.2.6红字发票开具接口.
                if (!Objects.equals(invoiceRedInitialRespVO.getQRJKPBZ(), "Y")) {
                    InvoiceRedSaveRespVO invoiceRedSaveRespVO = JSON.parseObject(redSaveResp.getDATA(), InvoiceRedSaveRespVO.class);
                    // 通过红票确认单保存
                    InvoiceRedSaveRespVO.Data saveRespVODATA = invoiceRedSaveRespVO.getDATA();
                    InvoiceRedSaveRespVO.Qrjkpfpqx qrjkpfpxx = saveRespVODATA.getQRJKPFPXX();
                    // 调用红票开具接口
                    AisinoRedInvoiceParam aisinoRedInvoiceParam = new AisinoRedInvoiceParam();
                    aisinoRedInvoiceParam.setUUID(saveRespVODATA.getUUID());
                    //税号 +随机数 长度为30 唯一值
                    aisinoRedInvoiceParam.setFPQQLSH(qrjkpfpxx.getXSFNSRSBH() + RandomUtil.randomNumbers(30));
                    aisinoRedInvoiceParam.setYFPHM(qrjkpfpxx.getFPHM());
                    aisinoRedInvoiceParam.setHZFPXXQRDBH(saveRespVODATA.getHZFPXXQRDBH());
                    aisinoRedInvoiceParam.setSFZZFP("N");
                    String redOpenParamStr = JSON.toJSONString(aisinoRedInvoiceParam);
                    AisinoCoverParamPayload redOpenParam = aisinoPayloadService.assembleAisinoPayload(redOpenParamStr, saveParam.getSaleTaxNo());
                    AisinoRedInitialResultResp redOpenResp = aisinoService.redInvoiceOpen(redOpenParam, redOpenParamStr);
                    if (redOpenResp != null && Objects.equals(redOpenResp.getCODE(), "0000")) {
                        RedInvoiceOpenResp redInvoiceOpenResp = JSON.parseObject(redOpenResp.getDATA(), RedInvoiceOpenResp.class);
                    } else {
                        // 红票开具失败日志
                        return redOpenResp != null ? redOpenResp.getRETURNMESSAGE() : "红票开具失败";
                    }
                }
            } else {
                // 红票保存失败日志
                return redSaveResp != null ? redSaveResp.getRETURNMESSAGE() : "红票保存失败";
            }
        } else {
            // 红票初始化失败日志
            return response != null ? response.getRETURNMESSAGE() : "红票初始化失败";
        }
        return null;
    }

    /**
     * 获取指定主表ID的销售明细列表。
     *
     * @param masId 主表ID，用于查询相关的销售明细数据。
     * @return 返回销售明细的VO（值对象）列表，这个列表是通过DTO（数据传输对象）转换而来的。
     */
    @Override
    public List<SaleInvDtlVO> getDtlList(Long masId) {
        try {
            // 从发票明细领域服务获取指定主表ID的销售明细DTO列表
            List<SaleInvDtlDTO> list = invoiceDtlDomainService.getList(masId);

            // 获取商品编码和商品名称
            Set<String> itemCodeList = list.stream().map(SaleInvDtlDTO::getItemCode).collect(Collectors.toSet());
            Set<Long> itemIdList = list.stream().map(SaleInvDtlDTO::getItemId).collect(Collectors.toSet());

            ItmItemRpcDtoParam itmItemParam = new ItmItemRpcDtoParam();
            itmItemParam.setItemCodes(new ArrayList<>(itemCodeList));
            itmItemParam.setItemIds(new ArrayList<>(itemIdList));
            List<ItmItemRpcDTO> itmItemResps = itmItemRpcService.findItemRpcDtoByParam(itmItemParam);

            Map<String, String> itemCodeAndNameMap = itmItemResps.stream()
                    .collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemName));

            Map<String, String> itemNameAndCodeMap = itemCodeAndNameMap.entrySet().stream()
                    .collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

            // 获取税收分类编码UDC信息
            Map<String, String> udcValues = org.apache.commons.lang3.ObjectUtils.defaultIfNull(
                    rmiSysUdcRpcService.getUdcMapByUdcCode("yst-supp", "TAXONOMY_CODE"),
                    new HashMap<>()
            );

            // 设置税收分类名称
            list = list.stream().peek(v -> {
                String taxName = udcValues.getOrDefault(v.getTaxCode(), "");
                v.setTaxName(taxName);
                if (!ObjectUtils.isEmpty(v.getItemCode()) && ObjectUtils.isEmpty(v.getItemName())) {
                    String itemName = itemCodeAndNameMap.getOrDefault(v.getItemCode(), v.getItemName());
                    v.setItemName(itemName);
                } else if (!ObjectUtils.isEmpty(v.getItemName()) && ObjectUtils.isEmpty(v.getItemCode())) {
                    String itemCode = itemNameAndCodeMap.getOrDefault(v.getItemName(), v.getItemCode());
                    v.setItemCode(itemCode);
                }
            }).collect(Collectors.toList());

            // 将获取到的DTO列表转换为VO列表，以供前端使用
            List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
            return res;
        } catch (Exception e) {
            // 日志记录异常，可以进一步细化异常处理，如重试逻辑、返回特定错误信息等
            log.error("Fetching sale details failed" + e.getMessage(), e);
            throw new BusinessException("Fetching sale details failed", e);
        }
    }

    private InvoiceRedraftDO saveInvoiceRedraft(InvoiceApplyRpcDTO applyRpcDTO) {
        SaleInvDO saleInvDO = saleInvRepo.findByApplyNo(applyRpcDTO.getApplyNo());
        List<SaleInvdDtlVO> saleInvdDtlVOs = saleInvService.getInvdLists(saleInvDO.getId());
        if (!CollectionUtils.isEmpty(saleInvdDtlVOs)) {
            SaleInvdDtlVO saleInvdDtlVO = saleInvdDtlVOs.get(0);
            InvoiceRedraftDO invoiceRedraftDO = new InvoiceRedraftDO();
            invoiceRedraftDO.setOrigApplyNo(applyRpcDTO.getApplyNo());
            invoiceRedraftDO.setInvoiceNo(saleInvdDtlVO.getInvNo());
            invoiceRedraftDO.setSerialNo(saleInvdDtlVO.getFlowNo());
            invoiceRedraftDO.setInvoiceAmt(saleInvdDtlVO.getTotalAmt());
            invoiceRedraftDO.setInvoiceDate(saleInvdDtlVO.getInvDate());
            invoiceRedraftDO.setInvoiceType(saleInvDO.getInvType());
            invoiceRedraftDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);

            // 设计加盟商和门店信息
            invoiceRedraftDO.setCustCode(saleInvDO.getCustCode());
            invoiceRedraftDO.setStoreCode(saleInvDO.getStoreCode());
            invoiceRedraftRepo.save(invoiceRedraftDO);
            return invoiceRedraftDO;
        } else {
            throw new BusinessException("当前销售发票无开票明细" + applyRpcDTO.getApplyId());
        }
    }

    /**
     * 开票参数校验
     *
     * @param param
     */
    public void checeInvParam(InvoiceApplyParam param) {
        Assert.notNull(param.getInvType(), "发票类型不能为空");
        Assert.notNull(param.getCustInvTitle(), "开票抬头不能为空");
        Assert.notNull(param.getCustTaxNo(), "税号不能为空");
    }

}
