package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.*;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocRespVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocSaveVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface AccountIocService {

    /**
     * 新增账户事务码数据
     *
     * @param saveVo 新增账户事务码数据
     * @return 新增账户事务码ID
     */
    ApiResult<Long> createOne(AccountIocSaveVO saveVo);

    /**
     * 修改账户事务码数据
     *
     * @param saveVo 修改账户事务码对象
     * @return 账户事务码ID
     */
    ApiResult<Long> update(AccountIocSaveVO saveVo);

    /**
     * 通过账户事务码ID查询单条数据
     *
     * @param id 账户事务码ID
     * @return 单条账户事务码数据
     */
    ApiResult<AccountIocRespVO> findIdOne(Long id);

    /**
     * 通过账户事务码查询单条数据
     *
     * @param code 账户事务码编码
     * @return 单条账户事务码数据
     */
    Optional<AccountIocRespVO> findByCode(String code);

    /**
     * 通过账户事务码集合查询数据
     *
     * @param codeList 账户事务码编码集合
     * @return 账户事务码数据集合
     */
    List<AccountIocRespVO> findByCodeBatch(List<String> codeList);

    /**
     * 分页查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    PagingVO<AccountIocRespVO> search(AccountIocParamVO param);

    /**
     * 根据账户事务码ID批量逻辑删除
     *
     * @param ids 账户事务码ID集合
     * @return 账户事务码ID集合
     */
    ApiResult<String> deleteBatch(List<Long> ids);

    /**
     * 根据入参查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    List<AccountIocRespVO> select(AccountIocParamVO param);

    List<AccountIocDTO> queryByAccountIocParam(AccountIocParam accountIocParam);
}
