package com.elitesland.fin.application.service.unionpay.entity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author sunxw
 * @description 银联回调code枚举
 * @Date 2023/6/8
 */
@Getter
@AllArgsConstructor
public enum RespCodeEnum {

    SUCCESS_0000("0000","交易成功"),
    INNER_0001("0001","初始状态"),
    FAILURE_0003("0003","消费交易失败"),
    FAILURE_0006("0006","签约失败"),
    FAILURE_0007("0007","重复签约"),
    FAILURE_0009("0009","退款交易失败"),
    FAILURE_0012("0012","交易撤销成功"),
    INNER_0014("0014","数据接收成功"),
    FAILURE_0024("0024","退款撤销成功"),
    FAILURE_0025("0025","重复交易"),
    SUCCESS_0026("0026","预授权完成处理成功"),
    FAILURE_0029("0029","预授权撤销成功"),
    FAILURE_0031("0031","退款撤销审核不通过"),
    FAILURE_0037("0037","预授权完成撤销成功"),
    FAILURE_1002("1002","商户审核不通过"),
    INNER_1003("1003","商户已审核"),
    INNER_1005("1005","交易撤销中"),
    INNER_1007("1007","退款撤销中"),
    INNER_1008("1008","预授权完成处理中"),
    INNER_1009("1009","预授权撤销中"),
    INNER_1010("1010","重汇已申请"),
    INNER_1011("1011","重汇审核通过"),
    FAILURE_1012("1012","重汇审核不通过"),
    SUCCESS_1013("1013","退款成功(重汇)"),
    INNER_1014("1014","预授权完成撤销中"),
    INNER_1015("1015","交易发送成功"),
    INNER_1016("1016","交易发送失败"),
    INNER_1017("1017","初始发送状态"),
    INNER_1018("1018","生成支付账单号成功"),
    INNER_1019("1019","经办成功"),
    FUILURE_1021("1021","单边账已退款"),
    SUCCESS_1022("1022","商户已申请"),
    INNER_1026("1026","退款调账已申请"),
    SUCCESS_1027("1027","退款调账成功"),
    SUCCESS_1028("1028","重汇文件已下载"),
    FIALURE_1029("1029","重汇确认失败"),
    SUCCESS_1030("1030","财务已审核"),
    INNER_1049("1049","退款预终止"),
    FAILURE_1050("1050","退款已终止"),
    FAILURE_1099("1099","风险交易（渠道应答中部分信息与请求不符）"),
    FAILURE_2001("2001","报文解析失败"),
    FAILURE_2002("2002","无效的令牌"),
    FAILURE_2003("2003","卡已过期"),
    FAILURE_2004("2004","请求频繁"),
    FAILURE_2006("2006","交易超时"),
    FAILURE_2007("2007","获取动态验证码失败"),
    FAILURE_2015("2015","IP 地址非法"),
    FAILURE_2016("2016","非法服务请求"),
    FAILURE_2017("2017","平台校验失败"),
    FAILURE_2018("2018","无效证书"),
    FAILURE_2027("2027","商户支付机构信息表无记录"),
    FAILURE_2028("2028","查询系统配置表无记录"),
    FAILURE_2031("2031","非法商户"),
    FAILURE_2032("2032","CVN2 失效"),
    FAILURE_2034("2034","重复退款"),
    FAILURE_2036("2036","交易报文信息不一致"),
    FAILURE_2040("2040","订单数据已同步，请至新菜单做退款"),
    FAILURE_2042("2042","格式校验失败"),
    FAILURE_2043("2043","系统异常，请查询后处理"),
    FAILURE_2044("2044","基本格式检验失败-字段非空未填"),
    FAILURE_2045("2045","基本格式检验失败-字段类型错误"),
    FAILURE_2046("2046","基本格式检验失败-字段长度错误"),
    FAILURE_2049("2049","风控受限"),
    FAILURE_2061("2061","银行卡非法"),
    FAILURE_2064("2064","资金不足"),
    FAILURE_2066("2066","手机号已失效"),
    FAILURE_2067("2067","手机号格式错误"),
    FAILURE_2071("2071","无效短信码"),
    FAILURE_2402("2402","原交易判定失败"),
    FAILURE_3003("3003","验签失败"),
    FAILURE_3004("3004","防钓鱼校验失败"),
    FAILURE_3007("3007","订单有效期失效"),
    FAILURE_3010("3010","商户未开通此交易类型"),
    FAILURE_3011("3011","单笔交易超限"),
    FAILURE_3012("3012","累计交易笔数超限"),
    FAILURE_3013("3013","累计交易金额超限"),
    FAILURE_3014("3014","单笔交易超限-商户"),
    FAILURE_3015("3015","累计交易笔数超限-商户"),
    FAILURE_3016("3016","累计交易金额超限-商户"),
    FAILURE_3019("3019","分账方和订单商户非分账关系"),
    FAILURE_3020("3020","分账金额与订单金额不符"),
    FAILURE_3022("3022","该笔订单已经支付成功请查实"),
    FAILURE_3034("3034","未找到原始交易"),
    FAILURE_3201("3201","查发卡方失败"),
    FAILURE_3229("3229","不正确的 PIN"),
    FAILURE_3233("3233","受限制的卡"),
    FAILURE_3239("3239","允许的输入 PIN 次数超限"),
    FAILURE_3249("3249","交换中心转发了原交易请求，但未收到发卡方应答"),
    FAILURE_3251("3251","受理方状态非法"),
    FAILURE_3264("3264","已发送银行"),
    FAILURE_3270("3270","不支持此类卡交易"),
    FAILURE_3285("3285","预授权号不匹配"),
    FAILURE_3290("3290","预授权取消、完成交易不得超过原交易 30 天以上"),
    FAILURE_3293("3293","交易结果未知"),
    FAILURE_3295("3295","累计退货金额大于原交易金额"),
    FAILURE_3302("3302","卡号与证件号码不符"),
    FAILURE_3305("3305","该储种不能办理代收付业务"),
    FAILURE_3308("3308","账户状态不正常"),
    FAILURE_3309("3309","帐户已销户"),
    FAILURE_3310("3310","账户已冻结"),
    FAILURE_3325("3325","密码错误"),
    FAILURE_3326("3326","户名不符"),
    FAILURE_3333("3333","原交易信息记录不存在"),
    FAILURE_3346("3346","银行分户存款余额不足"),
    FAILURE_3359("3359","交易提交银行错误请与 ChinaPay 系统管理员联系"),
    FAILURE_3389("3389","密码输错次数超限，请联系发卡行"),
    FAILURE_3397("3397","未开通银联无卡支付业务"),
    FAILURE_3400("3400","路由失败"),
    FAILURE_3401("3401","地区信息错误"),
    FAILURE_3417("3417","签名错误"),
    FAILURE_3422("3422","撤销交易的日期不是当天的日期"),
    FAILURE_3427("3427","交易金额超出待支付金额"),
    FAILURE_3432("3432","处理失败"),
    FAILURE_3441("3441","无流水"),
    SUCCESS_3444("3444","商户日期与系统日期相差超过一天，拒绝交易"),
    FAILURE_3445("3445","交易币种非法"),
    FAILURE_3446("3446","原交易已做过退款，撤销拒绝"),
    FAILURE_3448("3448","授权码校验不一致"),
    FAILURE_3450("3450","退款交易状态非失败，退款撤销拒绝"),
    FAILURE_3452("3452","商户未配置所属收单机构"),
    FAILURE_3455("3455","商户未关联分账商户"),
    FAILURE_3456("3456","该商户不是分账商户"),
    FAILURE_3458("3458","商户费用分账数据未配置"),
    FAILURE_3459("3459","分账数据错误"),
    FAILURE_3460("3460","分账订单已分账"),
    FAILURE_3461("3461","非延时分账交易"),
    FAILURE_3462("3462","非分账交易"),
    FAILURE_3463("3463","批量-明细信息不匹配"),
    FAILURE_4364("4364","支付机构号不支持前台交易"),
    FAILURE_3468("3468","商户未关联在该接入机构下"),
    FAILURE_3470("3470","未查询到签约信息或签约信息已变更"),
    FAILURE_3473("3473","渠道无流水");


    private String code;

    private String msg;

    public static String find(String code){
        if (StringUtils.isEmpty(code)){
            return "";
        }
        for (RespCodeEnum value:values()){
            if (value.getCode().equals(code)){
                return value.getMsg();
            }
        }
        return code;
    }

}
