package com.elitesland.fin.application.web.adjustorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.service.excel.imp.AdjustOrderSubmitJob;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 调整单手动提交控制器
 */
@RestController
@RequestMapping("/api/adjust")
@Api(tags = "调整单管理")
@Slf4j
@RequiredArgsConstructor
public class AdjustOrderSubmitController {

    private final AdjustOrderSubmitJob adjustOrderSubmitJob;

    /**
     * 手动触发提交草稿状态的调整单
     *
     * @return 操作结果
     */
    @PostMapping("/submit")
    @ApiOperation("手动提交草稿状态的调整单")
    public ApiResult<String> submitDraftAdjustOrders() {
        try {
            adjustOrderSubmitJob.submitDraftAdjustOrders(null);
            return ApiResult.ok("调整单提交任务已启动");
        } catch (Exception e) {
            log.error("手动提交草稿调整单时发生异常", e);
            return ApiResult.fail("提交草稿调整单时发生异常: " + e.getMessage());
        }
    }
}
